/*
 * grafex1.c
 *
 * example program using the Grafix library. draws an n-gon and all
 * its diagonals.
 *
 * compile with:
 *  MSC - msc grafex1;
 *        link grafex1,,,grafix
 *
 *  TC  - tcc grafex1 <grafix lib directory>\grafix.lib
 */

#include <stdio.h>
#include <conio.h>
#include <math.h>
#include "graf.h"

#define pi 3.1415926
#define MAXVERT 100

main()
{
  int n, i, j, d;
  unsigned c;
  struct g_info inf;
  struct {
    int x, y;
  } vert[MAXVERT];

  printf("n: ");
  scanf("%d", &n);
  if (n < 2 || n > MAXVERT) {
    printf("Oop Ack!\n");
    exit(1);
  }

  g_init(0);
  g_open(CGA_320);	/* use 4-color mode on CGA. on an EGA, the mode   */
			/* parameter is ignored and 16-color mode is used */
  g_info(&inf);

/* space n vertices equally on an ellipse that fits nicely on the screen */

  for (i=0; i<n; i++) {
    vert[i].x = inf.xsize/2 + (inf.xsize/3)*sin(2*pi/n*i);
    vert[i].y = inf.ysize/2 - (inf.ysize/3)*cos(2*pi/n*i);
  }

/*
 * draw the figure. the colors are selected so that points that are the
 * same distance from each other on the ellipse have the same color.
 */

  for (i=0; i<n; i++)
    for (j=i+1; j<n; j++) {
      d = j-i;
      if (d > n/2) d = n - d;
      c = (float)d/(n/2+1)*inf.colormax + 1;
      g_line(vert[i].x, vert[i].y, vert[j].x, vert[j].y, c);
    }

/* wait... */

  g_writestr(0, 0, "Press any key...", 1, -1);
  getch();

/* and clean up. */

  g_close();
}
