/*
 * grafix --- graf.h
 *
 * graphics definitions
 *
 * Written 4/87 by Scott Snyder (ssnyder@romeo.caltech.edu or @citromeo.bitnet)
 *
 */

/* graphics card definitions */

#define CGA 1
#define EGA 2

/* display type definitions */

#define EN 1
#define CD 2
#define MO 3

/* graphics mode definitions */

#define CGA_640 1
#define CGA_320 2

/* info structure definition */

struct g_info {
  unsigned card;
  unsigned display;
  unsigned xsize, ysize;
  unsigned xchsize, ychsize;
  unsigned colormax;
  unsigned pages;
  unsigned curpage;
};

/* graphics interface function definitions */

extern void g_box(int, int, int, int, unsigned);
extern void g_circle(int, int, int, unsigned);
extern void g_clear(unsigned);
extern void g_clearall(unsigned);
extern void g_close(void);
extern void g_ellipse(int, int, int, float, unsigned);
extern void g_info(struct g_info *);
extern void g_init(unsigned, ...);
extern void g_line(int, int, int, int, unsigned);
extern void g_open(unsigned);
extern void g_point(int, int, unsigned);
extern void g_regfill(int, int, int, int, unsigned);
extern void g_setback(unsigned);
extern void g_setbuf(unsigned);
extern void g_setclip(int, int, int, int);
extern void g_setpal(unsigned, unsigned);
extern void g_setxor(unsigned);
extern void g_show(void);
extern void g_writech(unsigned, unsigned, char, unsigned, int);
extern void g_writestr(unsigned, unsigned, char *, unsigned, int);
