;
; This is aset of C-linkable routines, in large model, for directly
; calling a Fossil driver.
;
fsubs_text    segment word public 'CODE'
        assume  cs:fsubs_text

public  _f_recv
public  _f_send
public  _f_status
public  _f_setbaud
public  _f_initialize
public  _f_dtr
public  _f_flushin
public  _f_flushout
public  _f_flowctrl
public  _f_purgeout
public  _f_deinit
public  _f_writechar
public  _f_readchar
public  _f_getinfo
public  _f_setbufsize
public  _f_defline
public  _f_insertchar
public  _f_getioport
public  _f_kill
public  _f_getmaxbuf
public  _f_setmonline
public  _f_readmonbuf
public  _f_lock
public  _f_getoba
public  _f_getibw
public  _f_getfc
public  _f_ovrunerrs


_f_ovrunerrs proc    far
        push    bp
        mov     bp,sp
        push    dx
        mov     dx,[bp+6]
        mov     ah,4eh
        int     14h
        pop     dx
        pop     bp
        ret
_f_ovrunerrs endp

_f_recv proc    far
        push    bp
        mov     bp,sp
        push    cx
        push    es
        push    di
        push    dx
        mov     dx,[bp+6]       ;line number
        mov     ax,[bp+10]       ;segment
        mov     es,ax
        mov     di,[bp+8]       ;offset
        mov     cx,[bp+12]      ;count
        mov     ah,18h
        int     14h
        pop     dx
        pop     di
        pop     es
        pop     cx
        pop     bp
        ret
_f_recv endp

_f_send proc    far
        push    bp
        mov     bp,sp
        push    cx
        push    es
        push    di
        push    dx
        mov     dx,[bp+6]       ;line number
        mov     ax,[bp+10]       ;segment
        mov     es,ax
        mov     di,[bp+8]       ;offset
        mov     cx,[bp+12]      ;count
        mov     ah,19h
        int     14h
        pop     dx
        pop     di
        pop     es
        pop     cx
        pop     bp
        ret
_f_send endp

_f_getinfo proc    far
        push    bp
        mov     bp,sp
        push    cx
        push    es
        push    di
        push    dx
        mov     dx,[bp+6]       ;line number
        mov     ax,[bp+10]       ;segment
        mov     es,ax
        mov     di,[bp+8]       ;offset
        mov     cx,[bp+12]      ;count
        mov     ah,1bh
        int     14h
        pop     dx
        pop     di
        pop     es
        pop     cx
        pop     bp
        ret
_f_getinfo endp

_f_status       proc    far
        push    bp
        mov     bp,sp
        push    dx
        mov     dx,[bp+6]
        mov     ah,3
        int     14h
        pop     dx
        pop     bp
        ret
_f_status       endp

_f_setbaud      proc    far
        push    bp
        mov     bp,sp
        push    dx
        mov     dx,[bp+6]
        mov     ax,[bp+8]       ;get line parameters
        mov     ah,0
        int     14h
        pop     dx
        pop     bp
        ret
_f_setbaud      endp

_f_initialize   proc    far
        push    bp
        mov     bp,sp
        push    dx
        mov     dx,[bp+6]
        mov     ah,4
        int     14h
        pop     dx
        pop     bp
        ret
_f_initialize   endp

_f_dtr  proc    far
        push    bp
        mov     bp,sp
        push    dx
        mov     dx,[bp+6]
        mov     ax,[bp+8]       ;get dtr parameters
        mov     ah,6
        int     14h
        pop     dx
        pop     bp
        ret
_f_dtr  endp

_f_flushin      proc    far
        push    bp
        mov     bp,sp
        push    dx
        mov     dx,[bp+6]
        mov     ah,0ah
        int     14h
        pop     dx
        pop     bp
        ret
_f_flushin      endp

_f_flushout     proc    far
        push    bp
        mov     bp,sp
        push    dx
        mov     dx,[bp+6]
        mov     ah,9
        int     14h
        pop     dx
        pop     bp
        ret
_f_flushout     endp

;
; what flow control is currently active ?
;
_f_getfc     proc    far
        push    bp
        mov     bp,sp
        push    dx
        mov     dx,[bp+6]
        mov     ah,48h
        int     14h
        pop     dx
        pop     bp
        ret
_f_getfc     endp

_f_flowctrl     proc    far
        push    bp
        mov     bp,sp
        push    dx
        mov     dx,[bp+6]
        mov     ax,[bp+8]       ;get flow control parameters
        mov     ah,0fh
        int     14h
        pop     dx
        pop     bp
        ret
_f_flowctrl     endp

_f_purgeout     proc    far     ;wait until output buffer is empty
        push    bp
        mov     bp,sp
        push    dx
fp_loop:
        mov     ah,1
        int     62h
        mov     dx,[bp+6]
        mov     ah,3            ;get status
        int     14h
        test    ah,40h          ;output buffer empty ?
        jz      fp_loop
        pop     dx
        pop     bp
        ret
_f_purgeout     endp

_f_deinit proc  far
        push    bp
        mov     bp,sp
        push    dx
        push    bx
        mov     dx,[bp+6]
        mov     ah,5
        int     14h
        pop     bx
        pop     dx
        pop     bp
        ret
_f_deinit endp

_f_writechar  proc    far
        push    bp
        mov     bp,sp
        push    dx
        mov     dx,[bp+6]
        mov     ax,[bp+8]       ;get char to write
        mov     ah,0bh
        int     14h
        pop     dx
        pop     bp
        ret
_f_writechar  endp

_f_readchar  proc    far
        push    bp
        mov     bp,sp
        push    dx
        mov     dx,[bp+6]
        mov     ah,2
        int     14h
        xor     ah,ah   ;get rid of hi byte
        pop     dx
        pop     bp
        ret
_f_readchar  endp

; parameters : line, address, irq

_f_defline proc far
        push    bp
        mov     bp,sp
        push    di
        push    dx
        push    cx
        push    bx
        mov     dx,[bp+6]
        mov     bx,[bp+8]
        mov     cx,[bp+10]
        mov     di,[bp+12]      ;buffer para address
        mov     ah,40h
        int     14h
        pop     bx
        pop     cx
        pop     dx
        pop     di
        pop     bp
        ret
_f_defline endp

_f_getioport    proc    far
        push    bp
        mov     bp,sp
        push    dx
        push    bx
        push    si
        push    es
        mov     ah,41h
        int     14h
        mov     dx,ax
        mov     si,[bp+6]
        mov     ax,[bp+8]
        mov     es,ax
        mov     es:[si],bx  ;offset of address
        mov     es:[si+2],dx    ;segment
        pop     es
        pop     si
        pop     bx
        pop     dx
        pop     bp
        ret
_f_getioport    endp

_f_kill proc    far
        mov     ah,42h
        int     14h
        ret
_f_kill endp

_f_setbufsize proc far
        push    bp
        mov     bp,sp
        push    dx
        push    cx
        push    bx
        mov     dx,[bp+6]
        mov     bx,[bp+8]
        mov     cx,[bp+10]
        mov     ah,43h
        int     14h
        pop     bx
        pop     cx
        pop     dx
        pop     bp
        ret
_f_setbufsize endp

_f_getmaxbuf    proc    far     ;return maximum buffer size useable
        mov     ah,44h
        int     14h
        ret
_f_getmaxbuf    endp

_f_setmonline   proc    far
        push    bp
        mov     bp,sp
        push    dx
        mov     dx,[bp+6]
        mov     ah,45h
        int     14h
        pop     dx
        pop     bp
        ret
_f_setmonline   endp

_f_readmonbuf   proc    far
        push    bp
        mov     bp,sp
        push    es
        push    di
        mov     di,[bp+6]       ;offset of buffer
        mov     ax,[bp+8]      ;segment
        mov     es,ax
        mov     ah,46h
        int     14h
        pop     di
        pop     es
        pop     bp
        ret
_f_readmonbuf   endp

;
; insert a character onto the line's input queue
;

_f_insertchar   proc    far
        push    bp
        mov     bp,sp
        push    dx
        mov     dx,[bp+6]
        mov     ax,[bp+8]
        mov     ah,49h
        int     14h
        pop     dx
        pop     bp
        ret
_f_insertchar   endp

;
; lock or unlock line settings, if al ==1 lock, if al == 0, unlock
;

_f_lock   proc    far
        push    bp
        mov     bp,sp
        push    dx
        mov     dx,[bp+6]
        mov     ax,[bp+8]
        mov     ah,4ah
        int     14h
        pop     dx
        pop     bp
        ret
_f_lock   endp

_f_getoba       proc    far
        push    bp
        mov     bp,sp
        push    dx
        mov     dx,[bp+6]
        mov     ah,4bh
        int     14h
        pop     dx
        pop     bp
        ret
_f_getoba       endp

_f_getibw       proc    far
        push    bp
        mov     bp,sp
        push    dx
        mov     dx,[bp+6]
        mov     ah,4ch
        int     14h
        pop     dx
        pop     bp
        ret
_f_getibw       endp


fsubs_text     ends
        end

