/* Set the ramdisk to the specified number of kbytes */
/* must be linked with -s1000 */
/* written by John N. White */

unsigned size;
unsigned zero[2],loci[256];
int err,drive,loc,old;

main(argc,argv)
char **argv;{
	int i;
	if(argc<2){
usage:	puts("setram - program to set size of ramdisk in kbytes\n");
		puts("usage:\n");
		puts("setram drive kbytes    to allocate memory for ramdisk\n");
		puts("setram drive           to free memory from ramdisk");
		exit(1);
	}
	i=argv[1][0];
	if(i>='a') i-=32;		/* set to upper case */
	drive=i-'A'+1;
	if(drive<0 || drive>31) goto usage;
	getold();
	if(old){
		if(argc>2){
			puts("ramdisk already has memory");
			exit(1);
		}
		clear();
		exit(0);
	}
	if(argc<3){
		puts("no memory allocated to ramdisk");
		exit(1);
	}
	size=atoi(argv[2]);
	if(size<8 || size>800) goto usage;
	loci[1]=size<<1;
	size<<=6;
#asm
	mov		ah,4ah			;modify programs allocated block
	mov		cx,cs
	sub		cx,10h
	mov		word loc_,cx
	mov		word loci_,cx
	mov		es,cx			;start of partition
	mov		bx,word size_	;new size
	int		21h
	jc		err

	mov		ax,cs			;get pointer to environment block
	sub		ax,10h
	mov		es,ax
	mov		es,es:[2Ch]
	mov		ah,49h			;dealloc environment block
	int		21h
	jc		err

	mov		ax,4405h		;IOCTL call to ramdisk
	mov		bx,word drive_
	mov		dx,offset loci_
	mov		cx,4
	int		21h
	jnc		ok
err:
	mov		word err_,ax
	jmp		main_error_
ok:
	mov		ax,3100h
	mov		dx,word size_
	int		21h
	jmp		err
#
error:
	puts("error number ");
	err&=63;
	if(err>9) putchar(err/10+'0');
	putchar(err%10+'0');
	puts(" (decimal)");
	exit(1);
}

getold(){
#asm
	mov		ax,4404h		;IOCTL call to ramdisk
	mov		bx,word drive_
	mov		dx,offset loci_
	mov		cx,2
	int		21h
	jc		err
#
	old=loci[0];
}

/* Clear the ramdisk */
clear(){
#asm
	mov		ah,49h			;free mem
	mov		es,word old_
	int		21h
	jc		err

	mov		ax,4405h		;IOCTL call to ramdisk
	mov		bx,word drive_
	mov		dx,offset zero_
	mov		cx,4
	int		21h
	jc		err
#
	return;
}
