/*+
    Name:       HLTIMES.C
    Author:     Kent J. Quirk
		(c) Copyright 1988 Ziff Communications Co.
    Date:       April 1988
    Abstract:   This file contains routines to save benchmark timings.
		Each program using this file has particular set of records
		to fill, each with a timing description.  Each record is
		64 bytes, and each program can report up to 8 timings.
		The first (zero) timing record is always reserved (by
		convention) for the total benchmark time.
		An item with a time of -1 is considered the last for
		that program.
    History:	09-Sep-88   kjq     Version 1.00
-*/

#include <stdio.h>
#include <string.h>
#include "hltimes.h"

#define NRECS 8
#define NPROGS 8

FILE *timefile;

TIME_REC blankrec = { -1L, "" };
TIME_REC hldesc[] = { 
    { -1L, "     System:" },
    { -1L, "        CPU:" },
    { -1L, "Coprocessor:" },
    { -1L, "     Memory:" },
    { -1L, "      Video:" },
    { -1L, "       Disk:" },
    { -1L, "   Software:" },
    { -1L, "      Other:" },
};

void savetime(programid, record, timerec)
int programid, record;
TIME_REC *timerec;
{
    long fp;

    fp = (long)(((long)programid * NRECS + (long)record)
		* (long)sizeof(TIME_REC));

    fseek(timefile, fp, SEEK_SET);
    fwrite(timerec, sizeof(TIME_REC), 1, timefile);
    return;
}

TIME_REC *readtime(programid, record)
{
    static TIME_REC timerec;

    if ((programid >= NPROGS) || (record >= NRECS))
	return(NULL);
    fseek(timefile, (long)(((long)programid * NRECS + (long)record)
	* (long)sizeof(TIME_REC)), SEEK_SET);
    fread(&timerec, sizeof(TIME_REC), 1, timefile);
    return(&timerec);
}

int opentime(name)
char *name;
{
    int i, j;
    char fname[32];

    strcpy(fname, name);
    if (strchr(fname, '.') != NULL)	/* if it has extension */
	*(strchr(fname, '.')) = 0;	/* replace it */
    strcat(fname, ".tim");

    if ((timefile = fopen(fname, "r+b")) == NULL)
    {	 
	if ((timefile = fopen(fname, "w+b")) == NULL)
	    return(0);
	else
	{
	    /* creating new file, zero it all out */
	    for (j=0; j<NRECS; j++)
		savetime(0, j, &(hldesc[j]));
	    
	    for (i=1; i<NPROGS; i++)
		for (j=0; j<NRECS; j++)
		    savetime(i, j, &blankrec);
	    return(-1);
	}
    }
    else
	return(-1);
}

void closetime()
{
    fclose(timefile);
}
