;---------------------------------------------------------------    
;drvstruc.inc - structures for DRVLOAD Utility                 |
;--------------------------------------------------------------|
;DRVLOAD Copyright (c) 1993                                    |
;                                                              |
;Rick Knoblaugh All rights reserved.                           |
;First Appeared in PC MAGAZINE, US Edition,                    |
;November 9, 1993                                              |
;--------------------------------------------------------------|
; 7/04/93                      Rick Knoblaugh                  |
;--------------------------------------------------------------|

doub_word       struc   
d_offset        dw      ?
d_segment       dw      ?
doub_word       ends    

psp             struc
psp_int20       dw      ?
psp_nextpar     dw      ?
                db      ?
psp_farcall     db      5 dup(?)
psp_termadrs    dd      ?               ;int 22h  address
psp_cntrlc      dd      ?               ;int 23h  address
psp_crit_err    dd      ?               ;int 24h  address
                dw      11 dup(?)
psp_environ_seg dw      ?
                dw      23 dup(?)
psp_fcb1        db      16 dup(?)
psp_fcb2        db      16 dup(?)
                dd      ?
psp_cmd_len     db      ?               ;length of cmd tail
psp_cmd_tail    db      ?
psp             ends

list_lists30    struc                   ;list of lists info (DOS 3.0)
dpb_ptr30       dd      ?               ;ptr 1st DOS DPB
file_tab30      dd      ?               ;ptr DOS file tables
clock_ptr30     dd      ?               ;ptr to CLOCK$ device
con_ptr30       dd      ?               ;ptr to CON device
num_blk30       db      ?               ;number block devices
max_byte30      dw      ?               ;max bytes/block
dsk_buf30       dd      ?               ;ptr 1st disk buffer
cds_ptr30       dd      ?               ;ptr to current disk struc
last_drv30      db      ?               ;LASTDRIVE value
strg_wrk30      dd      ?               ;STRING workspace area
srg_size30      dw      ?               ;size of STRING area
fcb_tab30       dd      ?               ;ptr to FCB table
fcb_y_30        dw      ?               ;y in FCBs=x,y
nul_dev30       db      18 dup(?)       ;NUL device header                                
list_lists30    ends 


list_lists31    struc                   ;list of lists info (DOS 3.1)
dpb_ptr31       dd      ?               ;ptr 1st DOS DPB
file_tab31      dd      ?               ;ptr DOS file tables
clock_ptr31     dd      ?               ;ptr to CLOCK$ device
con_ptr31       dd      ?               ;ptr to CON device
max_byte31      dw      ?               ;max bytes/block
dsk_buf31       dd      ?               ;ptr 1st disk buffer
cds_ptr31       dd      ?               ;ptr to current disk struc
fcb_tab31       dd      ?               ;ptr to FCB table
fcb_y_31        dw      ?               ;y in FCBs=x,y
num_blk31       db      ?               ;number block devices
last_drv31      db      ?               ;LASTDRIVE value
nul_dev31       db      18 dup(?)       ;NUL device header                                
num_join31      db      ?               ;number of JOINed drives
list_lists31    ends 

rh              struc                   ;request header
rh_len          db      0               ;len of packet
rh_unit         db      0               ;unit code (block devices)
rh_cmd          db      INIT_CMD        ;device driver command
rh_status       dw      0               ;returned by driver
rh_res1         dd      0               ;reserved
rh_res2         dd      0               ;reserved
rh              ends

init_req        struc                   ;Init (command 0)
init_rh         db      size rh dup (0) ;std req header
init_numunits   db      0               ;Number of units
init_brk_ofs    dw      0               ;Offset of break
init_brk_seg    dw      0               ;Segment of break
init_bpb_tbo    dw      0               ;Offset of pointer to
                                        ;to bpb array
init_bpb_tbs    dw      0               ;Segment of pointer to
                                        ;to bpb array
init_drv_first  db      0               ;First Available drive
                db      0               
init_req        ends

bpb             struc                   ;Bios Parameter Block
bpb_ss          dw      ?               ;Bpb Sector Size
bpb_au          db      ?               ;Cluster size
bpb_rs          dw      ?               ;1 boot sector
bpb_nf          db      ?               ;Number of FAT
bpb_de          dw      ?               ;Number of dir entries
bpb_ts          dw      ?               ;total sectors
bpb_md          db      ?               ;Media descriptor
bpb_fs          dw      ?               ;Fat sectors in each FAT
bpb_spt         dw      ?               ;Sectors per track
bpb_head        dw      ?               ;Heads
bpb_hidsec      dd      ?               ;Hidden sectors
bpb_huge_sec    dd      ?               ;DOS 5
bpb             ends

dpb_format_3    struc
dpb_drv_num_3   db      ?               ;drive number
dpb_log_unit_3  db      ?               ;logical unit within driver
dpb_bytes_sec_3 dw      ?               ;bytes per sector
dpb_sec_clust_3 db      ?               ;sectors per cluster -1
dpb_shift_cnt_3 db      ?               ;shift count
dpb_res_sec_3   dw      ?               ;res boot sectors
dpb_num_fat_3   db      ?               ;copies of FAT
dpb_num_root_3  dw      ?               ;max number root entries
dpb_1st_data_3  dw      ?               ;first data sector
dpb_high_clus_3 dw      ?               ;highest cluster num
dpb_sec_fat_3   db      ?               ;sectors per FAT
dpb_1st_dir_3   dw      ?               ;first dir sector
dpb_driver_3    dd      ?               ;address of device driver
dpb_med_desc_3  db      ?               ;media descriptor byte
dpb_aflag_3     db      ?               ;access flag
dpb_ptr_nxt_3   dd      ?               ;ptr to next parm block
dpb_res_3       dd      ?               ;reserved bytes
dpb_format_3    ends

;
;From DOS 4 and up, dpb is a different format as sectors per FAT is a word
;
dpb_format_4    struc
dpb_drv_num_4   db      ?               ;drive number
dpb_log_unit_4  db      ?               ;logical unit within driver
dpb_bytes_sec_4 dw      ?               ;bytes per sector
dpb_sec_clust_4 db      ?               ;sectors per cluster -1
dpb_shift_cnt_4 db      ?               ;shift count
dpb_res_sec_4   dw      ?               ;res boot sectors
dpb_num_fat_4   db      ?               ;copies of FAT
dpb_num_root_4  dw      ?               ;max number root entries
dpb_1st_data_4  dw      ?               ;first data sector
dpb_high_clus_4 dw      ?               ;highest cluster num
dpb_sec_fat_4   dw      ?               ;sectors per FAT
dpb_1st_dir_4   dw      ?               ;first dir sector
dpb_driver_4    dd      ?               ;address of device driver
dpb_med_desc_4  db      ?               ;media descriptor byte
dpb_aflag_4     db      ?               ;access flag
dpb_ptr_nxt_4   dd      ?               ;ptr to next parm block
dpb_res_4       dd      ?               ;reserved bytes
dpb_format_4    ends

cds_3_0         struc   
cds_drv_3       dw      ?               ;drive designator        
cds_path_3      db      41h dup(?)      ;CWD path string
cds_drv_stat3   dw      ?               ;drive status bitmap
cds_dbp_ptr3    dd      ?               ;ptr to DPB
cds_start_clus3 dw      ?               ;starting cluster of cur dir
cds_dk13        dd      ?
cds_slash3      dw      ?               ;slash loc in path
cds_3_0         ends

cds_4_0         struc   
cds_drv_4       dw      ?               ;drive designator        
cds_path_4      db      41h dup(?)      ;path string
cds_drv_stat4   dw      ?               ;drive status bitmap
cds_dbp_ptr4    dd      ?               ;ptr to DPB
cds_start_clus4 dw      ?               ;starting cluster of cur dir
cds_dk14        dd      ?
cds_slash4      dw      ?               ;slash loc in path
cds_dk24        db      ?
cds_ifs         dd      ?               ;ptr to IFS driver
cds_dk34        dw      ?        
cds_4_0         ends

dev_header      struc
dev_chain       dd      ?
dev_attrib      dw      ?
dev_stratr      dw      ?
dev_intr        dw      ?
dev_num_units   db      ?               ;first byte of char name
dev_char_name   db      7 dup(?)        
dev_header      ends

file_info       struc
file_res        db      21 dup(?)
file_atrib      db      ?
file_time       dw      ?
file_date       dw      ?
file_size       dd      ?
file_name       db      31 dup(?)       
file_info       ends

over_lay        struc
over_seg        dw      ?
over_relo_fac   dw      ?
over_lay        ends

;
;Since values returned in undocumented DOS "Lists of lists" function
;call 52h are DOS version specific, this structure is used to 
;conveniently know the offsets to the items we seek.
;
ver_spec_off    struc                   ;version specific offsets
vcds_ptr        dw      ?               ;offset of CDS ptr
vdpb_ptr        dw      ?               ;offset of DPB ptr
vnul_dev_ptr    dw      ?               ;offset of NUL device header
vlast_drive     dw      ?               ;offset of LASTDRIVE
ver_spec_off    ends

drvattrib       record  char_dev:1, ioctl_rw:1, out_busy:1, unuse1:1,  \
                        sup_open:1, unuse2:3, ioctl_q:1, unuse3:1, \
                        unuse4:1, fast_char:1, is_clock:1, is_nul:1,  \
                        sup_huge:1, std_input:1

stat_bits       record  err_bit:1, stdk:5, stat_bsy:1, stat_done:1, stat_err_val:8

cds_bits        record  net_work:1, physical:1, join:1, subst:1, cds_dk:12



;------end of drvstruc.inc

