'********** BLINDENT.BAS

'Kirk Woodward
'
'Subprogram and demo shows how to accept passwords and other text
'without echoing it to the screen.

DEFINT A-Z
DECLARE SUB BlindEnter (Text$, Row, Column)

CLS
LOCATE 10
PRINT "Enter some data:"
   
Text$ = SPACE$(10)              'set the maximum field length
COLOR 0, 7                      'input with reverse colors
CALL BlindEnter(Text$, 10, 19)
COLOR 7, 0

LOCATE 15, 1
PRINT "You entered: "; Text$

SUB BlindEnter (Text$, Row, Column)

  '  Where:  Text$   =  The entered string (returned to caller)
  '          Row     =  The line where the data is entered
  '          Column  =  The left column where the data is entered
  '
  '  At entry, BlindEnter expects Text$ to be filled with spaces in
  '  order to know the maximum length of the field.
  '
  '  CHR$(176) =  is displayed in place of the actual key stroke,
  '  but that can be changed to anything you like in the code below.
  '
  '  The only editing key that is accepted is the backspace key.

  MaxLength = LEN(Text$)        'save the incoming string length
  Text$ = ""                    'then clear it to start fresh
 
  DO

    LOCATE Row, Column, 0
    PRINT Display$; SPC(MaxLength - LEN(Display$));
    IF LEN(Text$) = MaxLength THEN EXIT SUB
   
    DO
      K$ = INKEY$
    LOOP UNTIL LEN(K$)                  'wait for a keypress

    SELECT CASE ASC(K$)                 'handle keys as needed

      CASE 13, 27                       'Enter or Escape keys
        EXIT SUB
     
      CASE 8                            'backspace key
        IF LEN(Display$) >= 1 THEN
          Display$ = LEFT$(Display$, LEN(Display$) - 1)
          Text$ = LEFT$(Text$, LEN(Text$) - 1)
        ELSE
          BEEP
        END IF

      CASE ELSE
        IF ASC(K$) >= 32 THEN           'accept character keys only
          Text$ = Text$ + K$
          Display$ = Display$ + CHR$(176)
        ELSE
          BEEP
        END IF

    END SELECT

  LOOP

END SUB

