{$K+}
PROGRAM CrtLog;
USES WinCrt, WinTypes, WinProcs, Strings, Win31, FileCdrImport;
CONST
  AppName : PChar = 'CrtLog';
  MsgName : PChar = 'CrtLog Message';
  wm_FileSysChange = $0034;
VAR
  CrtHandle : hWnd;
  OldProc   : TFarProc;

  PROCEDURE CheckINI;
  VAR Value : ARRAY[0..20] OF Char;
  BEGIN
    GetPrivateProfileString('386Enh', 'FileSysChange', '', Value, 20,
      'SYSTEM.INI');
    IF StrIComp(Value, 'ON') <> 0 THEN
      BEGIN
        MessageBeep(mb_IconQuestion);
        IF MessageBox(CrtHandle, 'Windows is not set up to receive '+
          'notification of file activity in DOS boxes.  Enable this '+
          'feature and restart Windows?', MsgName,
          mb_YesNo + mb_IconQuestion) = id_Yes THEN
          BEGIN
             WritePrivateProfileString('386Enh', 'FileSysChange',
               'ON', 'SYSTEM.INI');
             ExitWindows(ew_RestartWindows, 0);
          END;
      END;
  END;

  FUNCTION NewWinProc(Window : hWnd; Message, wParam : Word;
    lParam : LongInt) : LongInt; EXPORT;
  VAR buff : ARRAY[0..255] OF Char;
  BEGIN
    NewWinProc := CallWindowProc(OldProc, Window, Message, wParam,
      lParam);
    CASE Message OF
      wm_Close : FileCdrUninstall(CrtHandle);
      wm_FileSysChange : BEGIN
        IF wParam > 9 THEN Write('(W) ') ELSE Write('(D) ');
        Write(GetEventName(buff, wParam, 255), '':20-StrLen(buff));
        StrCopy(buff, PChar(lParam));
        IF (wParam = 2) OR (wParam = $56) THEN
          BEGIN
            StrCat(buff, ' TO ');
            StrCat(buff, StrEnd(PChar(lParam))+1);
          END;
        WriteLn(StrUpper(buff));
      END;
    END;
  END;

BEGIN
  IF GetWinFlags AND WF_ENHANCED = 0 THEN
    MessageBox(0, 'Because Windows is not in 386 Enhanced mode, '+
      'CrtLog will not be able to log file events occurring in DOS '+
      'boxes', MsgName, mb_Ok + mb_IconInformation)
  ELSE CheckINI;
  ScreenSize.X := (GetSystemMetrics(sm_CXScreen) -
    GetSystemMetrics(sm_CXVScroll) -
    GetSystemMetrics(sm_CXFrame)) DIV 8;
  ScreenSize.Y := 65520 DIV ScreenSize.X;
  AutoTracking := FALSE;
  StrCopy(WindowTitle,   'CrtLog Window');
  StrCopy(InactiveTitle, 'CrtLog Window');
  InitWinCrt;
  CrtHandle := GetActiveWindow;
  IF NOT FileCdrInstall(CrtHandle) THEN
    BEGIN
      MessageBox(CrtHandle, 'The FileCdr function is already in use '+
        'by another program - probably File Manager.', MsgName,
        mb_Ok + mb_IconStop);
      DoneWinCrt;
    END;
  OldProc := TFarProc(GetWindowLong(CrtHandle, gwl_WndProc));
  SetWindowLong(CrtHandle, gwl_WndProc, LongInt(@NewWinProc));
END.
