{ Utility to scrub the extra nybble from the 36-bit SIMTEL20 word. }

program scrub_zeros;

var infile    : file;
    outfile   : file;
    buf       : array[1..9] of byte;
    in_count  : word;
    out_count : word;
    p         : integer;

begin
if (ParamStr(1)='') or (ParamStr(2)='')
   then writeln('Command :     Scrub0 <input.fil> <output.fil>')
   else
       begin
       assign(infile,ParamStr(1));
       reset(infile,1);
       assign(outfile,ParamStr(2));
       rewrite(outfile,1);

       blockread(infile,buf,9,in_count);
       while in_count=9 do
          begin
          for p:=5 to 8 do
             begin
             buf[p]:=    ((buf[p]   shl 4) and $F0)
                      or ((buf[p+1] shr 4) and $0F);
             end;
             blockwrite(outfile,buf,8,out_count);
             blockread(infile,buf,9,in_count);
          end;
       if in_count=5 then blockwrite(outfile,buf,4,out_count);

       close(infile);
       close(outfile);
       end;
end.