/*****************************************************************
Module name: Cntl-DE.H
Programmer : Jeffrey M. Richter.
*****************************************************************/

// This function should be called first in the ClassInfo
// function to initialize the new control.
HGLOBAL WINAPI ControlInfo (WORD wVersion, LPSTR szClass,
   LPSTR szTitle);



// This function should be called repeatedly to add new control 
// types to the structure returned by the ControlInfo function.  
// This function should be called in the ClassInfo function.
BOOL WINAPI AddControlType (HGLOBAL hGlbl, WORD wType,
   WORD wWidth, WORD wHeight, DWORD dwStyle, LPSTR szDescr);



// This function displays the control's style dialog box and 
// should be called from the ClassStyle function.
int WINAPI ShowStyleDlg (HINSTANCE hInstance, LPCSTR szTemplate,
   HWND hWndParent, DLGPROC fpDlgProc, LPARAM lParam,
   HGLOBAL hGlblCtlStyle, LPFNSTRTOID lpfnStrToId,
   LPFNIDTOSTR lpfnIdToStr);


// This function should only be called from the ClassDlgFn
// function.  It locks the memory block containing the CTLSTYLE
// structure for the selected control and returns the FAR
// address to that structure.
LPCTLSTYLE WINAPI CtlStyleLock (HWND hDlg);


// This function should only be called from the ClassDlgFn
// function.  It unlocks the memory block containing the CTLSTYLE
// structure for the selected control and returns whether the 
// block was successfully unlocked.
BOOL WINAPI CtlStyleUnlock (HWND hDlg);


// This function should only be called from the ClassDlgFn
// function.  It converts the ID value for the control into a 
// identifier string and stores the string in the address passed
// in.  The number of characters in the string is returned.
WORD WINAPI GetIdString (HWND hDlg, LPSTR szId, WORD wIdMaxLen);


// This function should only be called from the ClassDlgFn
// function.  It converts an ID string value into its numeric 
// equivalent and stores the numeric value in the CTLSTYLE 
// structure for the control.  If the loword of the result is 0,
// the ID is invalid, otherwise, the hiword contains the numeric
// value of the ID.
DWORD WINAPI SetIdValue (HWND hDlg, LPSTR szId);
