#include "logo.h"
#include "globals.h"
#include <dos.h>
#include <dir.h>

#ifdef __ZTC__
#include <signal.h>
#define SIGQUIT SIGTERM
#endif

#ifndef TIOCSTI
#include <setjmp.h>
jmp_buf iblk_buf;
#endif

char combo_buff[MAX_BUFFER_SIZE];

void mputcombobox(char *str) /*routine*/
   {
   char tempbuff[MAX_BUFFER_SIZE];
   
   int i;
   int j;
   int k;
   int l;   
   
   l=strlen(combo_buff);
   strncat(combo_buff,str,MAX_BUFFER_SIZE-l);
   
   k=0;
   tempbuff[k] = '\0';
   
   i=strlen(combo_buff);
   
   for (j=0;j<i;j++)
      {
      if (combo_buff[j] == '\n')
         {
         tempbuff[k] = '\0';
         putcombobox(tempbuff);
         k = 0;
         tempbuff[k] = '\0';
         }
      else
         {
         tempbuff[k++] = combo_buff[j];
         }
      }
   
   if (k!=0)
      {
      tempbuff[k] = '\0';
      putcombobox(tempbuff);
      }
   
   combo_buff[0] = '\0';
   
   }

void putcombochar(char c) /*routine*/
   {
   int i;
   
   if (c == '\n')
      {
      putcombobox(combo_buff);
      combo_buff[0] = '\0';
      }
   else
      {
      i = strlen(combo_buff);
      if ((i+2) < MAX_BUFFER_SIZE)
         {
         combo_buff[i] = c;
         combo_buff[i+1] = '\0';
         }
      else
         {
         combo_buff[i] = '\n';
         combo_buff[i+1] = '\0';
         putcombobox(combo_buff);
         combo_buff[0] = c;
         combo_buff[1] = '\0';
         }
      
      }
   
   }

void nputs(char *str) /*routine*/
   {
   char c;
   
   while((c = *str++) != 0) putcombochar(c);
   
   }

int printfx(char *fmt) /*routine*/
   {
   mputcombobox(fmt);
   
   return(strlen(fmt));
   }

int printfx(char *fmt,char *str) /*routine*/
   {
   long cnt;				/* Result of SPRINTF for return */
   char buff[MAX_BUFFER_SIZE];
   
   cnt = sprintf(buff, fmt, str);
   
   mputcombobox(buff);
   
   return(cnt);
   }

int printfx(char *fmt,long str) /*routine*/
   {
   long cnt;				/* Result of SPRINTF for return */
   char buff[MAX_BUFFER_SIZE];
   
   cnt = sprintf(buff, fmt, str);
   
   mputcombobox(buff);
   
   return(cnt);
   }

int printfx(char *fmt,long str, char *str2) /*routine*/
   {
   long cnt;				/* Result of SPRINTF for return */
   char buff[MAX_BUFFER_SIZE];
   
   cnt = sprintf(buff, fmt, str, str2);
   
   mputcombobox(buff);
   
   return(cnt);
   }

int printfx(char *fmt,short str, long str2) /*routine*/
   {
   long cnt;				/* Result of SPRINTF for return */
   char buff[MAX_BUFFER_SIZE];
   
   cnt = sprintf(buff, fmt, str, str2);
   
   mputcombobox(buff);
   
   return(cnt);
   }

int printfx(char *fmt,short str, short str2) /*routine*/
   {
   long cnt;				/* Result of SPRINTF for return */
   char buff[MAX_BUFFER_SIZE];
   
   cnt = sprintf(buff, fmt, str, str2);
   
   mputcombobox(buff);
   
   return(cnt);
   }

long putcharx(long ch) /*routine*/
   {
   putcombochar((char)ch);
   
   return(ch);
   }

long putsx(const char *ch) /*routine*/
   {
   mputcombobox((char *)ch);
   
   return(1);
   }

NODE *lpushdir(NODE *arg) /*routine*/
   {
   char fname[80];
   
   cnv_strnode_string(fname, arg);
   
   if (chdir(fname))
      {
      printfx("Could not Push to directory %s\n",fname);
      }
   else
      {
      getcwd(fname,80);
      printfx("Pushed to %s\n",fname);
      }
   
   return (UNBOUND);
   }

NODE *lpopdir(void) /*routine*/
   {
   char fname[80];
   
   chdir("..");
   getcwd(fname,80);
   printfx("Popped to %s\n",fname);
   
   return (UNBOUND);
   }

NODE *lmkdir(NODE *arg) /*routine*/
   {
   char fname[80];
   
   cnv_strnode_string(fname, arg);
   
   if (mkdir(fname))
      {
      printfx("Failed to create directory %s\n",fname);
      }
   else
      {
      chdir(fname);
      printfx("Now in newly created directory %s\n",fname);
      }
   
   return (UNBOUND);
   }

NODE *lrmdir(NODE *arg) /*routine*/
   {
   char fname[80];
   
   cnv_strnode_string(fname, arg);
   
   if (rmdir(fname))
      {
      printfx("Failed to remove directory %s\n",fname);
      printfx("Make sure the directory is empty before trying to remove\n");
      }
   else
      {
      printfx("Logo directory %s removed\n",fname);
      }
   
   return (UNBOUND);
   }

NODE *ldir(void) /*routine*/
   {
   struct find_t ffblk;
   int done;
   
   done = _dos_findfirst("*.*",0,&ffblk);
   while (!done)
      {
      if (ffblk.attrib != FA_DIREC) printfx("File %s\n",ffblk.name);
      done = _dos_findnext(&ffblk);
      }
   
   done = _dos_findfirst("*.*",FA_DIREC,&ffblk);
   while (!done)
      {
      if (ffblk.attrib == FA_DIREC) printfx("Directory %s\n",ffblk.name);
      done = _dos_findnext(&ffblk);
      }
   
   return(UNBOUND);
   }

   void unblock_input() {
      if (input_blocking) {
      input_blocking = 0;
#ifdef TIOCSTI
      ioctl(0,TIOCSTI,"\n");
#else
      longjmp(iblk_buf,1);
#endif
      }
   }

#ifdef __ZTC__
void logo_stop(int sig)
#else
void logo_stop(int sig)
#endif
   {
   to_pending = 0;
#ifndef unix
   err_logo(STOP_ERROR,NIL);
#else
      if (ufun != NIL) {
      err_logo(STOP_ERROR,NIL);
      } else {
      new_line(stdout);
      }
#endif
#ifndef bsd
   signal(SIGINT, logo_stop);
#endif
   unblock_input();
   }

#ifdef __ZTC__
void logo_pause(int sig)
#else
void logo_pause(int sig) //
#endif
   {
   to_pending = 0;
#ifdef bsd
   sigsetmask(0);
#else
   signal(SIGQUIT, logo_pause);
#endif
#ifndef unix
   lpause();
#else
      if (ufun != NIL) {
      lpause();
      } else {
      new_line(stdout);
      unblock_input();
      }
#endif
   }

