#include "allwind.h"

int critical = 0;

void qlist::insert(ent a, int t)
   {
   
   /* class "event list queue" member to insert event */
   
   qlink *h;
   qlink *ph;
   
   if (last)
      {
      ph = last->next;
      h = new qlink(a, NULL, NULL, t);
      last->next = h;
      h->prev = last;
      h->next = ph;
      ph->prev = h;
      last = last->next;
      }
   else
      {
      last = new qlink(a, NULL, NULL, t);
      last->next = last;
      last->prev = last;
      }
   }

ent qlist::get(void)
   {
   
   /* class "event list queue" member to get event */
   
   if (last==NULL) return NULL;
   
   return(last->next->e);
   }

void qlist::zap(void)
   {
   
   /* class "event list queue" member to zap all events */
   
   qlink* p;
   
   if (last==NULL) return;
   
   p = last->next;
   
   if (last == p)
      {
      last = NULL;
      }
   else
      {
      p->prev->next = p->next;
      p->next->prev = p->prev;
      }
   
   delete p;
   
   }

void qlist::clear()
   {
   qlink* l = last;
   
   if (l == NULL) return;
   
   do
      {
      qlink* ll = l;
      l = l->next;
      delete ll;
      }
   while (l!=last);
   }

calllist calllists;

TMyWindow::TMyWindow(PTWindowsObject AParent, LPSTR ATitle)
: TWindow(AParent, ATitle)
   {
   /* main window initialization */
   
   AssignMenu("COMMANDS");
   PenSize = 1;
   
   /* build the bitmap */
   
   bitCount = 8;
   
   size = sizeof(BITMAPINFOHEADER) + ((1 << bitCount) * sizeof(RGBQUAD));
   BitmapInfo = (BITMAPINFO *)new char[size];
   
   BitmapInfo->bmiHeader.biSize          = sizeof(BITMAPINFOHEADER);
   BitmapInfo->bmiHeader.biWidth         = BitMapWidth;
   BitmapInfo->bmiHeader.biHeight        = BitMapHeight;
   BitmapInfo->bmiHeader.biPlanes        = 1;
   BitmapInfo->bmiHeader.biBitCount      = bitCount;
   BitmapInfo->bmiHeader.biCompression   = BI_RGB;
   BitmapInfo->bmiHeader.biSizeImage     = ((((BitmapInfo->bmiHeader.biWidth*BitmapInfo->bmiHeader.biBitCount)+31)/32)*4)*BitmapInfo->bmiHeader.biHeight;
   BitmapInfo->bmiHeader.biXPelsPerMeter = 0;
   BitmapInfo->bmiHeader.biYPelsPerMeter = 0;
   BitmapInfo->bmiHeader.biClrUsed       = 0;
   BitmapInfo->bmiHeader.biClrImportant  = 0;
   
   /* check if a palette exists */
   
   ScreenDC = CreateDC("Display", NULL, NULL, NULL);
   
   if ((GetDeviceCaps(ScreenDC, RASTERCAPS) & RC_PALETTE) == 0)
      {
      EnablePalette = 0;
      }
   else
      {
      EnablePalette = 1;
      }
   
   /* pack memory and eat up a whole bunch of memory */
   
   MemoryBitMap = CreateDIBitmap(ScreenDC, &(BitmapInfo->bmiHeader), 0L, NULL, NULL, DIB_RGB_COLORS);
   
   /* If fail try again after a compact */
   
   if (!MemoryBitMap)
      {
      GlobalCompact(-1);
      MemoryBitMap = CreateDIBitmap(ScreenDC, &(BitmapInfo->bmiHeader), 0L, NULL, NULL, DIB_RGB_COLORS);
      }   
   
   /* this is not fatal, you just loose backing store */
   
   if (!MemoryBitMap) MessageBox(0, "Not enough Memory to repaint", "Warning", MB_OK | MB_ICONEXCLAMATION);
   
   /* clear window */
   
   MemDC = CreateCompatibleDC(ScreenDC);
   OldBitmap = (HBITMAP)SelectObject(MemDC, MemoryBitMap);
   
   PatBlt(MemDC, 0, 0, BitMapWidth, BitMapHeight, WHITENESS);
   
   SelectObject(MemDC, OldBitmap);
   DeleteDC(MemDC);
   DeleteDC(ScreenDC);
   
   /* create printer object */
   
   Printer = new TPrinter;
   
   /* flag that screen clean */
   
   IsNewFile = TRUE;
   IsNewBitmap = TRUE;
   
   /* setup scrollers (LOTS of code for these things) */
   
   Attr.Style |= WS_VSCROLL | WS_HSCROLL;
   Scroller = new TScroller(this, 1, 1, BitMapWidth, BitMapHeight);
   
   /* If palette then build one */
   
   if (EnablePalette)
      {
      MyLogPalette = (LPLOGPALETTE) new char[sizeof(LOGPALETTE)+sizeof(PALETTEENTRY)*MaxColors];
      MyLogPalette->palVersion = 0x300;
      MyLogPalette->palNumEntries = 2;
      
      MyLogPalette->palPalEntry[0].peRed = 0;
      MyLogPalette->palPalEntry[0].peGreen = 0;
      MyLogPalette->palPalEntry[0].peBlue = 0;
      MyLogPalette->palPalEntry[0].peFlags = 0;
      
      MyLogPalette->palPalEntry[1].peRed = 255;
      MyLogPalette->palPalEntry[1].peGreen = 255;
      MyLogPalette->palPalEntry[1].peBlue = 255;
      MyLogPalette->palPalEntry[1].peFlags = 0;
      
      ThePalette = CreatePalette(MyLogPalette);
      }
   
   }

TMyWindow::~TMyWindow()
   {
   int i;
   
   /* clean things up */
   
   delete Printer;
   delete Scroller;
   DeleteObject(MemoryBitMap);
   delete EditboxWindow;
   delete ListboxWindow;
   delete CommandWindow;
   
   /* if palette clean it too */
   
   if (EnablePalette)
      {
      DeleteObject(ThePalette);
      delete MyLogPalette;
      }
   
   free(gcstack);
   free(hash_table);
   
   /* Note Bitmap index 0 belongs to CLipboard */
   
   for (i=1;i<MaxBitCuts;i++)
   if (CutBmp[i].CutFlag) DeleteObject(CutBmp[i].CutMemoryBitMap);
   
   // Borland will take care of freeing most mallocs (I hope)
   
   //    GlobalUnlock(HashHandle);
   //    GlobalFree(HashHandle);
   
   //    GlobalUnlock(StackHandle);
   //    GlobalFree(StackHandle);
   
   }

void TMyWindow::WMGetDlgCode( RTMessage msg )
   {
   TWindow::DefWndProc( msg );
   msg.Result |= DLGC_WANTARROWS;
   }

void TMyWindow::WMKeyDown(RTMessage Msg)
   { 
   callthing *callevent;
   
   // if keyboard was on and up and down is enabled then continue
   
   if (keyboard_on == 2)
      {
      
      // if key is down skip it
      
      if (!(Msg.LParam & 0x40000000))
         {
         callevent = new callthing;
         
         callevent->func = keyboard_keydown;
         callevent->arg1 = Msg.WParam;
         callevent->kind = 2;
         
         calllists.insert(callevent,2);
         checkqueue();
         //        PostMessage(MainHWindow, WM_CHECKQUEUE, 0, 0);
         }
      }
   
   // scroll main window with arrow keys
   
   switch (Msg.WParam)
      {
      case VK_UP:
         {
         Scroller->ScrollBy(0,-Scroller->YLine);
         break;
         }
      case VK_DOWN:
         {
         Scroller->ScrollBy(0,Scroller->YLine);
         break;
         }
      case VK_LEFT:
         {
         Scroller->ScrollBy(-Scroller->XLine,0);
         break;
         }
      case VK_RIGHT:
         {
         Scroller->ScrollBy(Scroller->XLine,0);
         break;
         }
      
      // else do your normal stuff
      
      default:
         {
         DefWndProc( Msg );
         break;
         }
      }
   }

void TMyWindow::WMKeyUp(RTMessage Msg)
   { 
   callthing *callevent;
   
   // if keyboard was on and up and down is enabled then continue
   
   if (keyboard_on == 2)
      {
      callevent = new callthing;
      
      callevent->func = keyboard_keyup;
      callevent->arg1 = Msg.WParam;
      callevent->kind = 2;
      
      calllists.insert(callevent,2);
      checkqueue();
      //      PostMessage(MainHWindow, WM_CHECKQUEUE, 0, 0);
      }
   
   // else do your normal stuff
   
   else
      {
      DefWndProc( Msg );
      }
   }

void TMyWindow::WMChar(RTMessage Msg)
   { 
   callthing *callevent;
   
   // if keyboard was on and NOT up and down is enabled then continue
   
   if (keyboard_on == 1)
      {
      callevent = new callthing;
      
      callevent->func = keyboard_keyup;
      callevent->arg1 = Msg.WParam;
      callevent->kind = 2;
      
      calllists.insert(callevent,2);
      checkqueue();
      //      PostMessage(MainHWindow, WM_CHECKQUEUE, 0, 0);
      }
   
   // else do your normal stuff
   
   else
      {
      DefWndProc( Msg );
      }
   }

void TMyWindow::GetWindowClass(WNDCLASS& WndClass)
   {
   TWindow::GetWindowClass( WndClass );
   WndClass.lpszMenuName = "Logo";
   WndClass.hIcon = LoadIcon( GetApplication()->hInstance, "LogoIcon");
   }

void TMyWindow::Paint( HDC PaintDC, PAINTSTRUCT& )
   {
   
   /*
   This is a compromise between speed and memory (as is most code).
   All drawing is written to the backing store 1 to 1 even when zoomed.
   When zoomed all drawing and painting is scaled to the display on the fly.
   Painting can be a bit slow while zoomed. It also can be inaccurate when
   mixing scaled painting and scaled drawing. Printing is never zoomed.
   User can use Bitfit if he/she wants data scaled.
   
   Must of rewrote this routine 20 times, at least.
   */
   
   HDC MemDC;
   
   RECT RRR;
   
   int i;
   int Pnx;
   int Pny;
   int Snx;
   int Sny;
   int Pox;
   int Poy;
   int Sox;
   int Soy;
   
   /* grab the backing store (a bitmap) */
   
   ScreenDC = GetDC(0);
   MemDC = CreateCompatibleDC(ScreenDC);
   
   OldBitmap = (HBITMAP)SelectObject(MemDC, MemoryBitMap);
   
   /* if palette allocate it */
   
   if (EnablePalette)
      {
      OldPalette = SelectPalette(PaintDC, ThePalette, FALSE);
      RealizePalette(PaintDC);
      
      OldPalette2 = SelectPalette(MemDC, ThePalette, FALSE);
      RealizePalette(MemDC);
      }
   
   /* if 1 to 1 the just do normal paint */
   
   if (the_zoom == 1.0)
      {
      BitBlt(PaintDC,
      0,
      0,
      BitMapWidth,
      BitMapHeight,
      MemDC,
      0,
      0,
      SRCCOPY);
      }
   
   /* else compute scaling and then display */
   
   else
      {
      GetClientRect(HWindow,&RRR);
      
      Sox = (RRR.right-RRR.left)/the_zoom;
      Soy = (RRR.bottom-RRR.top)/the_zoom;
      
      Pox = ((TMyWindow *)MainWindowx)->Scroller->XPos/the_zoom;
      Poy = ((TMyWindow *)MainWindowx)->Scroller->YPos/the_zoom;
      
      Snx = (RRR.right-RRR.left);
      Sny = (RRR.bottom-RRR.top);
      
      Pnx = ((TMyWindow *)MainWindowx)->Scroller->XPos; 
      Pny = ((TMyWindow *)MainWindowx)->Scroller->YPos;
      
      if (Pox+Sox > BitMapWidth)
         {
         Sox = BitMapWidth-Pox;
         Snx = Sox*the_zoom;
         }
      
      if (Poy+Soy > BitMapHeight)
         {
         Soy = BitMapHeight-Poy;
         Sny = Soy*the_zoom;
         }
      
      SetStretchBltMode(PaintDC,COLORONCOLOR);
      
      // Load hour-glass cursor.
      
      hCursor = SetCursor(hCursorWait);
      
      /* streeeeeeeeeeeeeeeeeeeech it */
      
      StretchBlt(PaintDC,
      Pnx,
      Pny,
      Snx,
      Sny,
      MemDC,
      Pox,
      Poy,
      Sox,
      Soy,
      SRCCOPY);
      
      // Reload arrow cursor.
      SetCursor(hCursor);
      
      }
   
   /* restore resources */
   
   if (EnablePalette)
      {
      SelectPalette(MemDC, OldPalette2, FALSE);
      SelectPalette(PaintDC, OldPalette, FALSE);
      }
   
   SelectObject(MemDC, OldBitmap);
   DeleteDC(MemDC);
   ReleaseDC(0, ScreenDC);
   
   /* if turtle do it */
   
   if (turtle_shown)
      {
      SetROP2(PaintDC, R2_NOT);
      
      for (i=0;i<3;i++)
         {
         MoveTo(PaintDC, TurtlePoints[i].from.x*the_zoom, TurtlePoints[i].from.y*the_zoom);
         LineTo(PaintDC, TurtlePoints[i].to.x*the_zoom, TurtlePoints[i].to.y*the_zoom);
         }
      }
   }

void TMyWindow::Printit( HDC PrintDC )
   {
   
   /*
   Must of rewrote this at least 25 times :-) and it still does not
   work in some situations. This is just the "Paint" of printing.
   See the print module for all the other stuff.
   */  
   
   HDC ScreenDC;

   int TempWidth;
   int TempHeight;

   LPSTR BitsPtr;
   HBITMAP BitsHandle;
   
   /* do we even have a chance ? */
   
   if ((GetDeviceCaps(PrintDC, RASTERCAPS) & RC_BITBLT) == 0)
      {
      MessageBox(HWindow, "Driver NOT supported", "Error", MB_OK | MB_ICONEXCLAMATION);
      }
   
   /* we don't need hour glass here because print module takes care of it */
   
   BitsHandle = (HBITMAP)GlobalAlloc(GMEM_MOVEABLE | GMEM_ZEROINIT, BitmapInfo->bmiHeader.biSizeImage);
   
   /* If fail try again after a compact */
   
   if (!BitsHandle)
      {
      GlobalCompact(-1);
      BitsHandle = (HBITMAP)GlobalAlloc(GMEM_MOVEABLE | GMEM_ZEROINIT, BitmapInfo->bmiHeader.biSizeImage);
      }
   
   /* if we got the memory continue */
   
   if (BitsHandle)
      {
      
      /* get printer size */
      
      TempWidth = GetDeviceCaps(PrintDC, LOGPIXELSX);
      TempHeight = GetDeviceCaps(PrintDC, LOGPIXELSY);
      
      ScreenDC = GetDC(0);
      
      /* if palette allocate it */
   
      if (EnablePalette)
         {
         OldPalette = SelectPalette(ScreenDC, ThePalette, FALSE);
         RealizePalette(ScreenDC);
       
         OldPalette2 = SelectPalette(PrintDC, ThePalette, FALSE);
         RealizePalette(PrintDC);
         }
   
      /* set up an assured contrast ? */
      
      SetTextColor(PrintDC, 0x00000000L);
      SetBkColor(PrintDC, 0x00ffffffL);
      
      /* where is that memory anyway */
      
      BitsPtr = (LPSTR)GlobalLock((HGLOBAL)BitsHandle);
      
      /* if "active area" just print that */
      
      if (CustomFlag)
         {
         GetDIBits(ScreenDC, MemoryBitMap, 0, BitMapHeight, BitsPtr, BitmapInfo, DIB_RGB_COLORS);
         
         StretchDIBits(PrintDC,
         0,
         0,
         TempWidth*(int)((PrinterAreaXHigh-PrinterAreaXLow)/100),
         TempHeight*(int)((PrinterAreaYHigh-PrinterAreaYLow)/100),
         +PrinterAreaXLow+xoffset,
         BitMapHeight-(-PrinterAreaYLow+yoffset),
         PrinterAreaXHigh-PrinterAreaXLow,
         PrinterAreaYHigh-PrinterAreaYLow,
         BitsPtr, BitmapInfo, DIB_RGB_COLORS, SRCCOPY);        
         }
      
      /* else print the whole thing */
      
      else
         {
         GetDIBits(ScreenDC, MemoryBitMap, 0, BitMapHeight, BitsPtr, BitmapInfo, DIB_RGB_COLORS);
         
         StretchDIBits(PrintDC,
         0,
         0,
         TempWidth*(int)(BitMapWidth/100),
         TempHeight*(int)(BitMapHeight/100),
         0,
         0,
         BitMapWidth,
         BitMapHeight, BitsPtr, BitmapInfo, DIB_RGB_COLORS, SRCCOPY);
         }      
      
      /* restore resources */
   
      if (EnablePalette)
         {
         SelectPalette(PrintDC, OldPalette2, FALSE);
         SelectPalette(ScreenDC, OldPalette, FALSE);
         }
   
      GlobalUnlock(BitsHandle);
      
      GlobalFree(BitsHandle);
      
      ReleaseDC(0, ScreenDC);
      
      }
   
   /* can't do it */
   
   else
      {
      MessageBox(HWindow, "No Memory to Print", "Error", MB_OK | MB_ICONEXCLAMATION);
      }  
   }

BOOL TMyWindow::CanClose()
   {
   
   // if not halted warn user and give chance to abort shutdown
   
   if (halt_flag != 0)
   return MessageBox(HWindow, "Return to LOGO?","Logo is not Halted", MB_YESNO | MB_ICONQUESTION) == IDNO;
   
   // if dirty warn user and give chance to abort shutdown
   
   if ( !IsDirty )
   return TRUE;
   return MessageBox(HWindow, "Return to LOGO?","You have not done a SAVE", MB_YESNO | MB_ICONQUESTION) == IDNO;
   
   }

void TMyWindow::CMExit(RTMessage Msg)
   { 
   
   /* here on FILE-EXIT main window (screen) */
   
   if (halt_flag != 0) Time_To_Halt = 1;
   Time_To_Exit = 1;
   }

BOOL TMyWindow::WriteDIB(int TheFile)
   {
   WORD bitCount;
   WORD size;
   
   HDC TempMemDC;
   HDC MemDC;
   
   LPSTR BitsPtr;
   HBITMAP BitsHandle;
   BITMAPFILEHEADER BitmapFileHeader;
   
   /* hard code to 8-bit bitmap */
   
   bitCount = 8;
   
   /* compute size of bitmap */
   
   size = sizeof(BITMAPINFOHEADER) + ((1 << bitCount) * sizeof(RGBQUAD));
   
   /* grab a DC */
   
   ScreenDC = CreateDC("Display", NULL, NULL, NULL);
   
   // allocate space for the raw DIB data
   
   BitsHandle = (HBITMAP)GlobalAlloc(GMEM_MOVEABLE | GMEM_ZEROINIT, BitmapInfo->bmiHeader.biSizeImage);
   
   /* If fail try again after a compact */
   
   if (!BitsHandle)
      {
      GlobalCompact(-1);
      BitsHandle = (HBITMAP)GlobalAlloc(GMEM_MOVEABLE | GMEM_ZEROINIT, BitmapInfo->bmiHeader.biSizeImage);
      }
   
   /* bummer */
   if (!BitsHandle)
      {
      DeleteDC(ScreenDC);
      
      return(FALSE);
      }
   
   /* go find it */
   
   BitsPtr = (LPSTR)GlobalLock((HGLOBAL)BitsHandle);
   
   /* if palette yank it in */
   
   if (EnablePalette)
      {
      OldPalette2 = SelectPalette(ScreenDC, ThePalette, FALSE);
      RealizePalette(ScreenDC);
      }
   
   /* if custom then use custom dimensions */
   
   if (CustomFlag)
      {
      AreaMemoryBitMap = CreateCompatibleBitmap(ScreenDC, 
      PrinterAreaXHigh-PrinterAreaXLow,
      PrinterAreaYHigh-PrinterAreaYLow);
      if (!AreaMemoryBitMap) MessageBox(MainHWindow, "Write failed, Possibly no Memory", "Error", MB_OK | MB_ICONEXCLAMATION);
      
      MemDC = CreateCompatibleDC(ScreenDC);
      OldBitmap = (HBITMAP)SelectObject(MemDC, MemoryBitMap);
      
      TempMemDC = CreateCompatibleDC(ScreenDC);
      OldBitmap2 = (HBITMAP)SelectObject(TempMemDC, AreaMemoryBitMap);
      
      BitmapInfo->bmiHeader.biWidth         = PrinterAreaXHigh-PrinterAreaXLow;
      BitmapInfo->bmiHeader.biHeight        = PrinterAreaYHigh-PrinterAreaYLow;
      BitmapInfo->bmiHeader.biSizeImage     = ((((BitmapInfo->bmiHeader.biWidth*BitmapInfo->bmiHeader.biBitCount)+31)/32)*4)*BitmapInfo->bmiHeader.biHeight;
      
      BitBlt(TempMemDC,
      0,
      0,
      PrinterAreaXHigh-PrinterAreaXLow,
      PrinterAreaYHigh-PrinterAreaYLow,
      MemDC, 
      +PrinterAreaXLow+xoffset,
      -PrinterAreaYHigh+yoffset,
      SRCCOPY);
      
      SelectObject(TempMemDC, OldBitmap2);
      DeleteDC(TempMemDC);
      
      SelectObject(MemDC, OldBitmap);
      DeleteDC(MemDC);
      
      // convert logo bitmap to raw DIB in BitsPtr
      GetDIBits(ScreenDC, AreaMemoryBitMap, 0, PrinterAreaYHigh-PrinterAreaYLow, BitsPtr, BitmapInfo, DIB_RGB_COLORS);
      
      DeleteObject(AreaMemoryBitMap);
      }
   
   /* else do whole thing */
   
   else
      {
      // convert logo bitmap to raw DIB in BitsPtr
      GetDIBits(ScreenDC, MemoryBitMap, 0, BitMapHeight, BitsPtr, BitmapInfo, DIB_RGB_COLORS);
      }      
   
   /* restore some of the resourese */ 
   
   if (EnablePalette) SelectPalette(ScreenDC, OldPalette2, FALSE);
   DeleteDC(ScreenDC);
   
   /* build header */
   
   BitmapFileHeader.bfType      = 19778;
   BitmapFileHeader.bfSize      = size + sizeof(BITMAPFILEHEADER) + (int)(BitmapInfo->bmiHeader.biWidth*BitmapInfo->bmiHeader.biHeight*(bitCount/8));
   BitmapFileHeader.bfReserved1 = 0;
   BitmapFileHeader.bfReserved2 = 0;
   BitmapFileHeader.bfOffBits   = size + sizeof(BITMAPFILEHEADER);
   
   // write header
   
   _lwrite(TheFile, (LPSTR)&BitmapFileHeader, sizeof(BitmapFileHeader));
   _lwrite(TheFile, (LPSTR)BitmapInfo, size);
   
   // write out raw DIB data to file
   
   GlobalUnlock(BitsHandle);
   
   PutBitmapData(TheFile, BitsHandle, BitmapInfo->bmiHeader.biSizeImage);
   
   GlobalFree(BitsHandle);
   
   /* if custom we need to set the original bitmap back to the right size */
   
   if (CustomFlag)
      {
      BitmapInfo->bmiHeader.biWidth         = BitMapWidth;
      BitmapInfo->bmiHeader.biHeight        = BitMapHeight;
      BitmapInfo->bmiHeader.biSizeImage     = ((((BitmapInfo->bmiHeader.biWidth*BitmapInfo->bmiHeader.biBitCount)+31)/32)*4)*BitmapInfo->bmiHeader.biHeight;
      }      
   
   return TRUE;
   }

BOOL TMyWindow::DumpBitmapFile(LPSTR Name)
   {
   int TheFile;
   
   /* open and check if ok */
   
   TheFile = _lcreat(Name, 0);
   if ( TheFile != -1 )
      {
      
      // Load hour-glass cursor.
      hCursor = SetCursor(hCursorWait);
      
      /* do it and if error then let user know */
      
      if (!WriteDIB(TheFile))
         {
         MessageBox(HWindow, "Could not Write .BMP", "Error", MB_OK | MB_ICONEXCLAMATION);
         }
      
      // Reload arrow cursor.
      SetCursor(hCursor);
      
      _lclose(TheFile);
      }
   
   /* else file never opened */
   
   else
      {
      MessageBox(HWindow, "Could not Open .BMP", "Error", MB_OK | MB_ICONEXCLAMATION);
      }
   
   return TRUE;
   }


/* Attempt to open a Windows 3.0 device independent bitmap. */

BOOL TMyWindow::OpenDIB(int TheFile)
   {
   WORD bitCount;
   WORD size;
   
   long longWidth;
   HDC DCHandle;
   LPSTR BitsPtr;
   BITMAPINFO *BitmapInfo;
   
   HBITMAP BitsHandle;
   HBITMAP NewBitmapHandle;
   
   DWORD NewPixelWidth;
   DWORD NewPixelHeight;
   
   BITMAPFILEHEADER BitmapFileHeader;
   int i;
   
   /* get header */
   
   _llseek(TheFile, 0, 0);
   _lread(TheFile, (LPSTR)&BitmapFileHeader, sizeof(BitmapFileHeader));
   
   /* get the bit count */
   
   _llseek(TheFile, 28, 0);
   _lread(TheFile, (LPSTR)&bitCount, sizeof(bitCount));
   
   /* only allow 8 bit or less */
   
   if (bitCount > 8) return FALSE;
   
   /* compute size of bitmap */
   
   size = sizeof(BITMAPINFOHEADER) + ((1 << bitCount) * sizeof(RGBQUAD));
   BitmapInfo = (BITMAPINFO *)new char[size];
   
   /* get to the bits */
   
   _llseek(TheFile, sizeof(BITMAPFILEHEADER), 0);
   _lread(TheFile, (LPSTR)BitmapInfo, size);
   
   /* if palette load up palette from bitmap color table */
   
   if (EnablePalette)
      {
      for (i=0;i<(1<<bitCount);i++) LoadColor(
      BitmapInfo->bmiColors[i].rgbRed,
      BitmapInfo->bmiColors[i].rgbGreen,
      BitmapInfo->bmiColors[i].rgbBlue);
      }
   
   /* save some typing */
   
   NewPixelWidth = BitmapInfo->bmiHeader.biWidth;
   NewPixelHeight = BitmapInfo->bmiHeader.biHeight;
   
   /* compute image size */
   
   longWidth = (((NewPixelWidth * bitCount) + 31)/32) * 4;
   
   BitmapInfo->bmiHeader.biSizeImage = longWidth * NewPixelHeight;
   
   /* pack and allocate */
   
   BitsHandle = (HBITMAP)GlobalAlloc(GMEM_MOVEABLE | GMEM_ZEROINIT, BitmapInfo->bmiHeader.biSizeImage);
   
   /* If fail try again after a compact */
   
   if (!BitsHandle)
      {
      GlobalCompact(-1);
      BitsHandle = (HBITMAP)GlobalAlloc(GMEM_MOVEABLE | GMEM_ZEROINIT, BitmapInfo->bmiHeader.biSizeImage);
      }
   
   /* sorry */
   
   if (!BitsHandle)
      {
      delete BitmapInfo;
      return FALSE;
      }
   
   /* read the file into the bitmap */
   
   GetBitmapData(TheFile, BitsHandle, BitmapInfo->bmiHeader.biSizeImage);
   
   /* Create DC comaptible with screen */
   
   ScreenDC = GetDC(MainHWindow);
   
   MemDC = CreateCompatibleDC(ScreenDC);
   DCHandle = CreateCompatibleDC(ScreenDC);
   
   /* if palette yank it */
   
   if (EnablePalette)
      {
      OldPalette2 = SelectPalette(ScreenDC, ThePalette, FALSE);
      RealizePalette(ScreenDC);
      
      OldPalette = SelectPalette(MemDC, ThePalette, FALSE);
      RealizePalette(MemDC);
      }
   
   /* find it */
   
   BitsPtr = (LPSTR)GlobalLock((HGLOBAL)BitsHandle);
   
   /* now create the bitmap with the bits just loaded */
   
   NewBitmapHandle = CreateDIBitmap(ScreenDC, &(BitmapInfo->bmiHeader), CBM_INIT, BitsPtr,BitmapInfo, 0);
   
   /* now dump the bits */
   
   GlobalUnlock(BitsHandle);
   GlobalFree(BitsHandle);
   
   delete BitmapInfo;
   
   if (EnablePalette) SelectPalette(ScreenDC, OldPalette2, FALSE);
   ReleaseDC(MainHWindow,ScreenDC);
   
   /* now that things are clean we can check if we are ok */
   
   if ( !NewBitmapHandle ) return FALSE;
   
   /*
   We've now made a bonafied bitmap. But we want to copy it into the
   existing backing store.
   */
   
   if (EnablePalette)
      {
      OldPalette2 = SelectPalette(DCHandle, ThePalette, FALSE);
      RealizePalette(DCHandle);
      }
   
   OldBitmap2 = (HBITMAP)SelectObject(DCHandle, NewBitmapHandle);
   OldBitmap = (HBITMAP)SelectObject(MemDC, MemoryBitMap);
   
   /* if either dimension is more than half then put in corner */
   
   if ((NewPixelWidth > (BitMapWidth/2)) || (NewPixelHeight > (BitMapHeight/2)))
      {
      BitBlt(MemDC, 0, 0, NewPixelWidth, NewPixelHeight, DCHandle, 0, 0, SRCCOPY);
      }
   
   /* else put at turtle */
   
   else
      {
      BitBlt(MemDC,
      +turtle_x+xoffset,
      -turtle_y+yoffset-NewPixelHeight,
      NewPixelWidth,
      NewPixelHeight, DCHandle, 0, 0, SRCCOPY);
      }
   
   /* return resources */
   
   if (EnablePalette)
      {
      SelectPalette(MemDC, OldPalette, FALSE);
      SelectPalette(DCHandle, OldPalette2, FALSE);
      }
   SelectObject(MemDC, OldBitmap);
   SelectObject(DCHandle, OldBitmap2);
   DeleteDC(MemDC);
   DeleteDC(DCHandle);
   DeleteObject(NewBitmapHandle);
   
   return TRUE;
   }

BOOL TMyWindow::LoadBitmapFile(LPSTR Name)
   {
   
   /* Test if the passed file is a Windows 3.0 DIB bitmap and if so read it */
   
   int TheFile;
   long TestWin30Bitmap;
   char ErrorMsg[50] = "";
   BOOL retval;
   
   /* open then check if open */
   
   TheFile = _lopen(Name, OF_READ);
   if ( TheFile != -1 )
      {
      
      /* check if valid bitmap */
      
      _llseek(TheFile, 14, 0);
      _lread(TheFile, (LPSTR)&TestWin30Bitmap, sizeof(TestWin30Bitmap));
      if ( TestWin30Bitmap == 40 )
         {
         // Load hour-glass cursor.
         hCursor = SetCursor(hCursorWait);
         
         /* if loaded ok then invalidate to display */
         
         if ( OpenDIB(TheFile) )
            {
            InvalidateRect(MainHWindow, NULL, TRUE);
            }
         
         /* else error */
         
         else
            {
            strcpy(ErrorMsg, "Unable to create Windows 3.0 bitmap");
            }
         
         // Reload arrow cursor.
         SetCursor(hCursor);
         }
      
      /* not a bitmap */
      
      else
         {
         strcpy(ErrorMsg, "Not a Windows 3.0 bitmap");
         }
      _lclose(TheFile);
      }
   
   /* else file not there */
   
   else
      {
      strcpy(ErrorMsg, "Cannot open bitmap file");
      }
   
   /* if no message the we are ok else display error message */
   
   if ( ErrorMsg[0] == '\0' )
      {
      retval= TRUE;
      }
   else
      {
      MessageBox(HWindow, ErrorMsg, "Error", MB_OK);
      retval= FALSE;
      }
   
   return retval;
   }

/* __ahIncr, ordinal 114, is a 'magic' function. Defining this
function causes Windows to patch the value into the passed
reference.  This makes it a type of global variable. To use
the value of AHIncr, use FP_OFF(AHIncr). */

   extern "C" {
   void FAR PASCAL  __ahIncr();
   }

/* Copys the bitmap bit data from the file into memory. Since
copying cannot cross a segment (64K) boundary, we are forced
to do segment arithmetic to compute the next segment.  Created
a LongType type to simplify the process. */

void TMyWindow::GetBitmapData(int TheFile, HANDLE BitsHandle,long BitsByteSize)
   {
   long Count;
   long Start, ToAddr, Bits;
   
   Start = 0L;
   Bits = (long)GlobalLock(BitsHandle);
   Count = BitsByteSize - Start;
   while ( Count > 0 )
      {
      ToAddr = MAKELONG(LOWORD(Start),
      HIWORD(Bits) + (HIWORD(Start) * FP_OFF(__ahIncr)));
      if ( Count > 0x4000 )
      Count = 0x4000;
      _lread(TheFile, (LPSTR)ToAddr, (WORD)Count);
      Start = Start + Count;
      Count = BitsByteSize - Start;
      }
   GlobalUnlock(BitsHandle);
   }

/* Copys the bitmap bit data from the memory into file. Since
copying cannot cross a segment (64K) boundary, we are forced
to do segment arithmetic to compute the next segment.  Created
a LongType type to simplify the process. */

void TMyWindow::PutBitmapData(int TheFile, HANDLE BitsHandle,long BitsByteSize)
   {
   long Count;
   long Start, ToAddr, Bits;
   
   Start = 0L;
   Bits = (long)GlobalLock(BitsHandle);
   Count = BitsByteSize - Start;
   
   while ( Count > 0 )
      {
      ToAddr = MAKELONG(LOWORD(Start),
      HIWORD(Bits) + (HIWORD(Start) * FP_OFF(__ahIncr)));
      if ( Count > 0x4000 )
      Count = 0x4000;
      _lwrite(TheFile, (LPSTR)ToAddr, (WORD)Count);
      Start = Start + Count;
      Count = BitsByteSize - Start;
      }
   
   GlobalUnlock(BitsHandle);
   }

void TMyWindow::WMSize(RTMessage Msg)
   { 
   RECT RRR;
   int Xr;
   int Yr;
   NUMBER XRatio,YRatio;
   
   /* pass message down */
   
   TWindow::WMSize(Msg);
   
   /*
   Adjust scroller range so that thumb at each extreme corresponds
   to edge of extreme image.
   */
   
   GetClientRect(HWindow,&RRR);
   
   Xr = (BitMapWidth*the_zoom)-RRR.right;
   Yr = (BitMapHeight*the_zoom)-RRR.bottom;
   
   if (Xr < 0) Xr = 0;
   if (Yr < 0) Yr = 0;
   
   if (Scroller->XRange <= 0)
      {
      XRatio = 0.5;
      }
   else
      {
      XRatio = (NUMBER)Scroller->XPos/(NUMBER)Scroller->XRange;
      }
   
   if (Scroller->YRange <= 0)
      {
      YRatio = 0.5;
      }
   else
      {
      YRatio = (NUMBER)Scroller->YPos/(NUMBER)Scroller->YRange;
      }
   
   Scroller->SetRange(Xr,Yr);
   Scroller->ScrollTo(XRatio*Xr,YRatio*Yr);
   
   //   Scroller->SetPageSize();
   
   }

void TMyWindow::CMBitmapNew(RTMessage Msg)
   { 
   HBRUSH TempBrush;
   HDC TempDC;
   
   /* basically all that is done here is to reset things */
   
   TempBrush = CreateBrushIndirect(&ScreenBrush);
   TempDC = GetDC(MainHWindow);
   
   //memory
   
   MemDC = CreateCompatibleDC(TempDC);
   SelectObject(MemDC, MemoryBitMap);
   
   FillRect(MemDC, &FullRect, TempBrush);
   
   SetBkColor(MemDC, scolor);
   SetBkMode(MemDC, TRANSPARENT);
   
   DeleteDC(MemDC);
   
   ReleaseDC(MainHWindow, TempDC);
   DeleteObject(TempBrush);
   
   //screen
   
   InvalidateRect(HWindow, NULL, TRUE);
   
   IsNewBitmap = TRUE;
   }

void TMyWindow::CMBitmapOpen(RTMessage Msg)
   { 
   
   /* if user found a file then try to load it  */
   
   if ( GetApplication()->ExecDialog(new TFileDialog(this, SD_FILEOPEN,strcpy(BitmapName, "*.BMP"))) == IDOK )
      {
      IsNewBitmap = FALSE;
      LoadBitmapFile(BitmapName);
      }
   }

void TMyWindow::CMBitmapSave(RTMessage Msg)
   { 
   
   /* if new file then switch to save file as, else save */
   
   if ( IsNewBitmap )
   SaveBitmapAs();
   else SaveBitmap();
   }

void TMyWindow::SaveBitmapAs()
   { 
   
   /* if new then nulify File name */
   
   if ( IsNewBitmap ) strcpy(BitmapName, "");
   
   /* Get file name from user and then save the file */   
   
   if ( GetApplication()->ExecDialog(new TFileDialog(this, SD_FILESAVE,strcpy(BitmapName, "*.BMP"))) == IDOK )
      {
      IsNewBitmap = FALSE;
      SaveBitmap();
      }
   }

void TMyWindow::CMBitmapSaveAs(RTMessage Msg)
   { 
   SaveBitmapAs();
   }

void TMyWindow::SaveBitmap()
   { 
   DumpBitmapFile(BitmapName);
   }

void TMyWindow::CMFileNew(RTMessage Msg)
   { 
   NODE *arg;
   
   // if doing new and dirty giver user a chance to abort the new
   
   if ( IsDirty )
      {
      if (MessageBox(HWindow, "Continue with NEW?","You have not done a SAVE", MB_YESNO | MB_ICONQUESTION) == IDNO) return;
      }
   
   // else start with a clean plate
   
   IsNewFile = TRUE;
   IsDirty = FALSE;
   
   arg = lcontents();
   
   lerase(arg);
   }

void TMyWindow::CMFileOpen(RTMessage Msg)
   { 
   int i;
   
   /* if user found a file the try to load it  */
   
   if ( GetApplication()->ExecDialog(new TFileDialog(this, SD_FILEOPEN,strcpy(FileName, "*.*"))) == IDOK )
      {
      IsNewFile = FALSE;
      halt_flag++;
      if (halt_flag < 1) halt_flag = 1;
      fileload(FileName);
      
      // use dummy loop so that original code with "Breaks" does the right thing
      
      for (i=0;i<1;i++)
         {
            if (stopping_flag == THROWING) {
               if (compare_node(throw_node, Error, TRUE) == 0) {
               err_print();
               } else if (compare_node(throw_node, System, TRUE) == 0)
            break;
               else if (compare_node(throw_node, Toplevel, TRUE) != 0) {
               err_logo(NO_CATCH_TAG, throw_node);
               err_print();
               }
            stopping_flag = RUN;
            }
            if (stopping_flag == STOP || stopping_flag == OUTPUT) {
            print_node(stdout, make_static_strnode(
            "You must be in a procedure to use OUTPUT or STOP.\n"));
            stopping_flag = RUN;
            }
         }
      
      halt_flag--;
      if (halt_flag < 0) halt_flag = 0;
      }
   }

void TMyWindow::CMFileSave(RTMessage Msg)
   { 
   
   /* if new file the switch to save file as, else save */
   
   if ( IsNewFile )
   SaveFileAs();
   else SaveFile();
   }

void TMyWindow::SaveFileAs()
   { 
   
   /* if new the nulify File name */
   
   if ( IsNewFile ) strcpy(FileName, "");
   
   /* Get file name from user and then save the file */   
   
   if ( GetApplication()->ExecDialog(new TFileDialog(this, SD_FILESAVE,strcpy(FileName, "*.*"))) == IDOK )
      {
      IsNewFile = FALSE;
      SaveFile();
      }
   }

void TMyWindow::CMFileSaveAs(RTMessage Msg)
   { 
   SaveFileAs();
   }

void TMyWindow::SaveFile()
   { 
   filesave(FileName);
   }

void TMyWindow::CMBitmapPrinterArea(RTMessage Msg)
   { 
   
   /* copy real to dynamic */
   
   TPrinterAreaXLow  = PrinterAreaXLow;
   TPrinterAreaXHigh = PrinterAreaXHigh;
   TPrinterAreaYLow  = PrinterAreaYLow;
   TPrinterAreaYHigh = PrinterAreaYHigh;
   TCustomFlag       = CustomFlag;
   
   /* if user does not cancel then copy dynamic to real */
   
   PrinterAreaWindow = new TMyPrinterAreaWindow(this, "PrinterArea");
   
   if ( GetApplication()->ExecDialog(PrinterAreaWindow) == IDOK )
      {
      PrinterAreaXLow  = TPrinterAreaXLow;
      PrinterAreaXHigh = TPrinterAreaXHigh;
      PrinterAreaYLow  = TPrinterAreaYLow;
      PrinterAreaYHigh = TPrinterAreaYHigh;
      CustomFlag       = TCustomFlag;
      }
   }

void TMyWindow::CMFileEdit(RTMessage Msg)
   { 
   NODE *arg;
   
   // create dialog for which procedure to edit
   
   FileEditWindow = new TMyFileEditWindow(this, "DIALOGEDIT");
   
   FileEditWindow->FileEditAll = 0;
   
   // now do it
   
   if ( GetApplication()->ExecDialog(FileEditWindow) == IDOK )
      {
      
      // if user clicked ALL get all procedures
      
      if (FileEditWindow->FileEditAll == 1)
         {
         arg = lprocedures();
         }
      
      // else find what user selected
      
      else
         {
         arg = cons(make_strnode(SelectedText, NULL, strlen(SelectedText), STRING, strnzcpy),NIL);
         }
      
      // if something edit it
      
      if (arg != NIL) ledit(arg);
      
      }
   }

void TMyWindow::CMFileErase(RTMessage Msg)
   { 
   NODE *arg;
   
   // create dialog for which procedure to erase
   
   FileEditWindow = new TMyFileEditWindow(this, "DIALOGERASE");
   
   FileEditWindow->FileEditAll = 0;
   
   // now do it
   
   if ( GetApplication()->ExecDialog(FileEditWindow) == IDOK )
      {
      
      // if user clicked ALL get all procedures
      
      if (FileEditWindow->FileEditAll == 1)
         {
         arg = lprocedures();
         
         IsNewFile = TRUE;
         IsDirty = FALSE;
         }
      
      // else find what user selected
      
      else
         {
         arg = cons(make_strnode(SelectedText, NULL, strlen(SelectedText), STRING, strnzcpy),NIL);
         }
      
      // if something erase it
      
      if (arg != NIL) lerase(arg);
      
      }
   }

void TMyWindow::MyPopupEdit(char *FileName, NODE *args)
   { 
   char TempFileName[32];
   char *cp;
   char szWinLocStr[WININISIZ];
   char dfWinLocStr[WININISIZ];
   
   int x;
   int y;
   int w;
   int h;
   
   PTModule pm;
   TWindowAttr aw;
   
   /* if called with NULL filename then prompt user */
   
   if ( FileName == NULL )
      {
      GetApplication()->ExecDialog(new TFileDialog(this, SD_FILEOPEN,_fstrcpy(TempFileName, "*.*")));
      EditWindow = new TMyFileWindow(this, "Editor", TempFileName, args);
      }
   
   /* else use given arg */
   
   else
      {
      EditWindow = new TMyFileWindow(this, "Editor", FileName, args);
      }
   
   /* Do win.ini stuff. Build default coords */
   
   x = (int)(MaxWidth*0.25);
   y = (int)(MaxHeight*0.25);
   w = (int)(MaxWidth*0.75);
   h = (int)(MaxHeight*ScreenSz*0.75);
   
   /* convert */
   
   sprintf(dfWinLocStr, "%d,%d,%d,%d", x, y, w, h);
   
   // Get last location and size of Edit Window from WIN.INI file.
   
   GetPrivateProfileString(
   "LOGO",
   "Editor",
   dfWinLocStr,
   szWinLocStr,
   sizeof(szWinLocStr),
   "LOGO.INI");
   
   // Decode location and size of window from profile string.
   
   cp = szWinLocStr;
   x = (int) strtol(cp, &cp, 10);
   cp++;
   y = (int) strtol(cp, &cp, 10);
   cp++;
   w = (int) strtol(cp, &cp, 10);
   cp++;
   h = (int) strtol(cp, &cp, 10);
   
   checkwindow(&x, &y, &w, &h);
   
   /* now set them */   
   
   EditWindow->Attr.Style |= WS_POPUPWINDOW | WS_CAPTION | WS_THICKFRAME | WS_MINIMIZEBOX | WS_MAXIMIZEBOX;
   EditWindow->Attr.X = x;
   EditWindow->Attr.Y = y;
   EditWindow->Attr.W = w;
   EditWindow->Attr.H = h;
   
   /* flag for how to handle focus */
   
   if (args != NULL) JustDidEdit = 1;
   
   aw = EditWindow->Editor->Attr;
   delete EditWindow->Editor;
   EditWindow->hEditHeap = GlobalAlloc(GMEM_ZEROINIT, 0xFFFF);
   pm = new TModule("", (HMODULE)EditWindow->hEditHeap, "");
   EditWindow->Editor = new TEdit( EditWindow, aw.Id, "", aw.X, aw.Y, aw.W, aw.H, -1, TRUE, pm);
   
   EditWindow->Editor->Attr.Style |= ES_NOHIDESEL;

   /* let user edit */
   
   GetApplication()->MakeWindow(EditWindow);
   
   if (args != NULL) 
      {
      
      /* retitle without filename */
      
      SetWindowText(EditWindow->HWindow, "Editor");
      
      // if an error occured "force" a change so that we still in
      // "dirty" state
      
      if (error_happen)
         {
         error_happen = 0;
         EditWindow->Editor->Insert(" ");
         EditWindow->Editor->DeleteSubText(0,1);
         }
      
      /* keep global pointer for hacking around */
      
      EdtHWindow = EditWindow->HWindow;
      }
   }

int TMyWindow::MyPopupInput(char *str,char *pmt)
   { 
   
   // get user input
   
   if (GetApplication()->ExecDialog(new TInputDialog(this, pmt,"Input:",str,MAX_BUFFER_SIZE)) == IDOK)
      {
      return(1);
      }
   else
      {
      return(0);
      }
   }

void TMyWindow::SetupWindow()
   { 
   
   TWindow::SetupWindow();
   
   MainHWindow = HWindow;
   
   /* adjust scrollers */
   
   GetClientRect(HWindow,&RR);
   Scroller->SetRange(BitMapWidth-RR.right,BitMapHeight-RR.bottom);
   Scroller->ScrollTo((BitMapWidth/2)-(0.5*RR.right),(BitMapHeight/2)-(0.5*RR.bottom));
   
   /* save size */
   
   MaxX = BitMapWidth;
   MaxY = BitMapHeight;
   
   /* it's show time for our little friend */
   
   ibmturt(0);
   term_init();
   
   /* pop up commander */
   
   MyPopupCommander();
   }

void TMyWindow::MyPopupCommander()
   { 
   
   /* init commander window */
   
   char      *cp;
   char       szWinLocStr[WININISIZ];
   char       dfWinLocStr[WININISIZ];
   int        x, y, w, h;
   
   /* create resourced window */
   
   CommandWindow = new TMyCommandWindow(this, "DIALOGCOMMAND");
   GetApplication()->MakeWindow(CommandWindow);
   
   CmdHWindow = ((TMyCommandWindow *)((TMyWindow *)MainWindowx)->CommandWindow)->HWindow;
   
   EditboxWindow = new TMyEditboxWindow(CommandWindow, ID_EDITINPUT, 0);
   GetApplication()->MakeWindow(EditboxWindow);
   
   ListboxWindow = new TMyListboxWindow(CommandWindow, ID_LISTBOX);
   GetApplication()->MakeWindow(ListboxWindow);
   
   /* get handle to each child window for resize purposes */
   
   ListHWindow    = GetDlgItem(CmdHWindow,ID_LISTBOX);
   EditHWindow    = GetDlgItem(CmdHWindow,ID_EDITINPUT);
   ExecuteHWindow = GetDlgItem(CmdHWindow,ID_EXECUTE);
   HaltHWindow    = GetDlgItem(CmdHWindow,ID_HALT);
   TraceHWindow   = GetDlgItem(CmdHWindow,ID_TRACE);
   PauseHWindow   = GetDlgItem(CmdHWindow,ID_PAUSE);
   StatusHWindow  = GetDlgItem(CmdHWindow,ID_STATUS);
   YieldHWindow   = GetDlgItem(CmdHWindow,ID_YIELD);
   ResetHWindow   = GetDlgItem(CmdHWindow,ID_RESET);
   
   /* build default coords */
   
   x = ((TMyWindow *)MainWindowx)->Attr.X;
   y = ((TMyWindow *)MainWindowx)->Attr.Y+((TMyWindow *)MainWindowx)->Attr.H;
   w = ((TMyWindow *)MainWindowx)->Attr.W;
   h = MaxHeight*CommandSz;// 47; //((TMyWindow *)MainWindowx)->Attr.H*0.25;
   
   /* convert */
   
   sprintf(dfWinLocStr, "%d,%d,%d,%d", x, y, w, h);
   szWinLocStr[0] = '\0';
   
   // Get last location and size of command window from WIN.INI file.
   
   GetPrivateProfileString(
   "LOGO",
   "Commander",
   dfWinLocStr,
   szWinLocStr,
   sizeof(szWinLocStr),
   "LOGO.INI");
   
   // Decode location and size of window from profile string.
   
   cp = szWinLocStr;
   x = (int) strtol(cp, &cp, 10);
   cp++;
   y = (int) strtol(cp, &cp, 10);
   cp++;
   w = (int) strtol(cp, &cp, 10);
   cp++;
   h = (int) strtol(cp, &cp, 10);
   
   checkwindow(&x, &y, &w, &h);
   
   /* set it */
   
   SetWindowPos(CmdHWindow, NULL, x, y, w, h, 0);
   ShowWindow(CmdHWindow, SW_SHOW);
   
   Command_OK = 1;
   
   }

void TMyWindow::MyPopupStatusKill()
   { 
   RECT  wrect;
   int   w, h;
   char  szWinLocStr[WININISIZ];
   
   status_flag = 0;
   
   // Get location and size of our window on the screen so we can
   // come back up in the same spot next time we are invoked.
   
   GetWindowRect(StatHWindow, (LPRECT) &wrect);
   w = wrect.right - wrect.left;
   h = wrect.bottom - wrect.top;
   
   // Make a string with our window location and size.
   sprintf(szWinLocStr, "%d,%d,%d,%d", wrect.left, wrect.top, w, h);
   
   // Save in WIN.INI file.
   WritePrivateProfileString(
   "LOGO",
   "Status",
   szWinLocStr,
   "LOGO.INI");
   
   /* now kill it */
   
   delete StatusWindow;
   ((TMyCommandWindow *)((TMyWindow *)MainWindowx)->CommandWindow)->
   SendDlgItemMsg(ID_STATUS, WM_SETTEXT, 0, (DWORD)"Status");
   }

void TMyWindow::MyPopupStatus()
   { 
   
   /* popup status window */
   
   char      *cp;
   char       szWinLocStr[WININISIZ];
   char       dfWinLocStr[WININISIZ];
   int        x, y, w, h;
   
   /* flag so that updates are sent */
   
   status_flag = 1;
   
   /* pop it up */
   
   StatusWindow = new TMyStatusWindow(this, "DIALOGSTATUS");
   
   /* update button */
   
   ((TMyCommandWindow *)((TMyWindow *)MainWindowx)->CommandWindow)->
   SendDlgItemMsg(ID_STATUS, WM_SETTEXT, 0, (DWORD)"NoStatus");
   
   GetApplication()->MakeWindow(StatusWindow);
   
   /* save a handle */
   
   StatHWindow = StatusWindow->HWindow;
   
   /* build default coords */
   
   x = (int)(0);
   y = (int)(0);
   w = (int)(0);
   h = (int)(0);
   
   /* convert */
   
   sprintf(dfWinLocStr, "%d,%d,%d,%d", x, y, w, h);
   
   // Get last location and size of status window from WIN.INI file.
   
   GetPrivateProfileString(
   "LOGO",
   "Status",
   dfWinLocStr,
   szWinLocStr,
   sizeof(szWinLocStr),
   "LOGO.INI");
   
   // Decode location and size of window from profile string.
   
   cp = szWinLocStr;
   x = (int) strtol(cp, &cp, 10);
   cp++;
   y = (int) strtol(cp, &cp, 10);
   cp++;
   w = (int) strtol(cp, &cp, 10);
   cp++;
   h = (int) strtol(cp, &cp, 10);
   
   checkwindow(&x, &y, &w, &h);
   
   /* now set position */
   
   SetWindowPos(StatHWindow, NULL, x, y, 0, 0, SWP_NOSIZE);
   ShowWindow(StatHWindow, SW_SHOW);
   
   /* update all fields */
   
   update_status_turtleposition();
   update_status_pencolor();
   update_status_floodcolor();
   update_status_screencolor();
   update_status_paletteuse();
   update_status_penwidth();
   update_status_turtleheading();
   update_status_penstyle();
   update_status_pencontact();
   update_status_turtlevisability();
   update_status_fontsize();
   update_status_fontwieght();
   update_status_fontname();
   update_status_evals();
   update_status_memory();
   }

void TMyWindow::CMControlHalt(RTMessage Msg)
   { 
   lhalt();
   }

void TMyWindow::CMControlExecute(RTMessage Msg)
   { 
   HWND EditH;
   HWND TempH;
   
   EditH = FindWindow(NULL, "Editor");
   TempH = GetActiveWindow();
   
   // if Main is active find alternate
   
   if (TempH == MainHWindow)
      {
      
      // if commander up then focud to input box
      
      if (!IsIconic(CmdHWindow))
         {
         SetFocus(EditHWindow);
         } 
      
      // else if a available editor go there
      
      else if (EditH != NULL)
         {
         if (!IsIconic(EditH))
            {
            SetFocus(EditH);
            }
         }
      }
   
   // else if active is commander find alternate
   
   else if (TempH == CmdHWindow)
      {
      
      // if a available editor maybe go there
      
      if (EditH != NULL)
         {
         
         // if really available then go there
         
         if (!IsIconic(EditH))
            {
            SetFocus(EditH);
            }
         
         // else go to main
         
         else
            {
            SetFocus(MainHWindow);
            }
         }
      
      // else go to main
      
      else
         {
         SetFocus(MainHWindow);
         }
      }
   
   // else go to main
   
   else
      {
      SetFocus(MainHWindow);
      }
   }

void TMyWindow::CMSetFont(RTMessage Msg)
   { 
   
   static CHOOSEFONT CF;
   
   // clear the struct
   
   memset(&CF,0,sizeof(CF));
   
   // fill it with the right stuff
   
   CF.lStructSize    = sizeof(CF);
   CF.hwndOwner      = MainHWindow;
   CF.Flags          = CF_SCREENFONTS | CF_INITTOLOGFONTSTRUCT;
   CF.nFontType      = SCREEN_FONTTYPE;
   CF.lpLogFont      = &FontRec;
   CF.hInstance      = 0;
   
   // FontRec is not trashed in case of cancel
   
   ChooseFont(&CF);
   
   // show changes
   
   if (status_flag)
      {
      update_status_fontwieght();
      update_status_fontsize();
      update_status_fontname();
      }
   
   }

void TMyWindow::CMSetPenColor(RTMessage Msg)
   { 
   
   COLORREF TheColor;
   
   TheColor = pcolor;
   
   // if OK then make change
   
   if ( GetApplication()->ExecDialog(new TColorDialog(this, TheColor, "Pen Color")) == IDOK )
      {
      thepencolor(GetRValue(TheColor),GetGValue(TheColor),GetBValue(TheColor));
      save_color_pen();
      }
   
   }

void TMyWindow::CMSetFloodColor(RTMessage Msg)
   { 
   
   COLORREF TheColor;
   
   TheColor = fcolor;
   
   // if OK then make changes
   
   if ( GetApplication()->ExecDialog(new TColorDialog(this, TheColor, "Flood Color")) == IDOK )
      {
      thefloodcolor(GetRValue(TheColor),GetGValue(TheColor),GetBValue(TheColor));
      save_color_flood();
      }
   
   }

void TMyWindow::CMSetScreenColor(RTMessage Msg)
   { 
   
   COLORREF TheColor;
   
   TheColor = scolor;
   
   // if OK then make changes
   
   if ( GetApplication()->ExecDialog(new TColorDialog(this, TheColor, "Screen Color")) == IDOK )
      {
      thescreencolor(GetRValue(TheColor),GetGValue(TheColor),GetBValue(TheColor));
      save_color_screen();
      }
   
   }

void TMyWindow::CMHelp(RTMessage Msg)
   { 
   WinHelp(MainHWindow,szHelpFileName,HELP_INDEX,0L);
   }

void TMyWindow::CMHelpMCI(RTMessage Msg)
   { 
   WinHelp(MainHWindow,MCIHelpFileName,HELP_INDEX,0L);
   }

void TMyWindow::CMHelpHelp(RTMessage Msg)
   { 
   WinHelp(MainHWindow,"WINHELP.HLP",HELP_INDEX,0L);
   }

void TMyWindow::CMHelpAbout(RTMessage Msg)
   { 
   
   lpProcAbout = (DLGPROC)MakeProcInstance((FARPROC)About, ModulehInstance);
   DialogBox(ModulehInstance, "AboutBox", MainHWindow, lpProcAbout);
   FreeProcInstance((FARPROC)lpProcAbout);
   }

// Execute File:Print command

void TMyWindow::CMBitmapPrint(RTMessage Msg)
   {
   PTRulerOut Printout = 0;
   
   if ( Printer )
      {
      
      Printout = new TRulerOut("Logo Picture");
      if ( Printout )
         {
         // turned back on in 3.5
#ifdef ISWIN31
         Printout->SetBanding( TRUE ); // fails in 3.0?
#endif
         Printout->SetBanding( FALSE );
         Printer->Print(this, Printout);
         delete Printout;
         }
      }
   }

// Execute File:Printer-setup command

void TMyWindow::CMBitmapPrinterSetup(RTMessage Msg)
   {
   if ( Printer )
   Printer->Setup(this);
   }

void TMyWindow::DefWndProc( RTMessage msg )
   {
   RECT  wrect;
   char  szWinLocStr[WININISIZ];
   
   int   w, h;
   
   // if shutdown then get sizes for logo.ini
   
   if (msg.Message == WM_DESTROY)
      {
      
      // don't save sizes if iconed
      
      if (!IsIconic(MainHWindow))
         {
         // Get location and size of our window on the screen so we can
         // come back up in the same spot next time we are invoked.
         
         GetWindowRect(MainHWindow, (LPRECT) &wrect);
         w = wrect.right - wrect.left;
         h = wrect.bottom - wrect.top;
         
         // Make a string with our window location and size.
         sprintf(szWinLocStr, "%d,%d,%d,%d", wrect.left, wrect.top, w, h);
         
         // Save in WIN.INI file.
         WritePrivateProfileString(
         "LOGO",
         "Screen",
         szWinLocStr,
         "LOGO.INI");
         }
      }
   
   TWindow::DefWndProc( msg );
   }

void TMyWindow::WMLButtonDown(RTMessage msg)
   {
   callthing *callevent;
   
   // if user turned on mouse the queue up event
   
   if (mouse_on == 1)
      {
      callevent = new callthing;
      
      callevent->func = mouse_lbuttondown;
      callevent->arg1 = msg.LP.Lo;
      callevent->arg2 = msg.LP.Hi;
      callevent->kind = 1;
      
      calllists.insert(callevent,1);
      checkqueue();
      //      PostMessage(MainHWindow, WM_CHECKQUEUE, 0, 0);
      }
   }

void TMyWindow::WMLButtonUp(RTMessage msg)
   {
   callthing *callevent;
   
   // if user turned on mouse the queue up event
   
   if (mouse_on == 1)
      {
      callevent = new callthing;
      
      callevent->func = mouse_lbuttonup;
      callevent->arg1 = msg.LP.Lo;
      callevent->arg2 = msg.LP.Hi;
      callevent->kind = 1;
      
      calllists.insert(callevent,1);
      checkqueue();
      //      PostMessage(MainHWindow, WM_CHECKQUEUE, 0, 0);
      }
   
   }

void TMyWindow::WMRButtonDown(RTMessage msg)
   {
   callthing *callevent;
   
   // if user turned on mouse the queue up event
   
   if (mouse_on == 1)
      {
      callevent = new callthing;
      
      callevent->func = mouse_rbuttondown;
      callevent->arg1 = msg.LP.Lo;
      callevent->arg2 = msg.LP.Hi;
      callevent->kind = 1;
      
      calllists.insert(callevent,1);
      checkqueue();
      //      PostMessage(MainHWindow, WM_CHECKQUEUE, 0, 0);
      }
   
   }

void TMyWindow::WMRButtonUp(RTMessage msg)
   {
   callthing *callevent;
   
   // if user turned on mouse the queue up event
   
   if (mouse_on == 1)
      {
      callevent = new callthing;
      
      callevent->func = mouse_rbuttonup;
      callevent->arg1 = msg.LP.Lo;
      callevent->arg2 = msg.LP.Hi;
      callevent->kind = 1;
      
      calllists.insert(callevent,1);
      checkqueue();
      //      PostMessage(MainHWindow, WM_CHECKQUEUE, 0, 0);
      }
   
   }

void TMyWindow::WMMouseMove(RTMessage msg)
   {
   callthing *callevent;
   
   // if user turned on mouse the queue up event
   
   if (mouse_on == 1)
      {
      callevent = new callthing;
      
      callevent->func = mouse_mousemove;
      callevent->arg1 = msg.LP.Lo;
      callevent->arg2 = msg.LP.Hi;
      callevent->kind = 1;
      
      calllists.insert(callevent,1);
      checkqueue();
      //      PostMessage(MainHWindow, WM_CHECKQUEUE, 0, 0);
      }
   }

void TMyWindow::WMCheckQueue(RTMessage msg)
   {
   checkqueue();
   }

#ifdef ISWIN31
void TMyWindow::MMMCINotify(RTMessage msg)
   {
   // if user fired up a callback mci event the queue it up here
   
   callthing *callevent;
   
   callevent = new callthing;
   
   callevent->func = mci_callback;
   callevent->kind = 4;
   
   calllists.insert(callevent,4);
   
   PostMessage(MainHWindow, WM_CHECKQUEUE, 0, 0);
   }
#endif

void TMyWindow::WMTIMER(RTMessage msg)
   {
   // if user fired up a callback mci event the queue it up here
   
   callthing *callevent;
   
   callevent = new callthing;
   
   // the ID can only be 1-31 and select appropriate callback code
   
   callevent->func = timer_callback[msg.WParam];
   if (msg.WParam > 16)
      {
      callevent->kind = 3;
      calllists.insert(callevent,3);
      }
   else
      {
      callevent->kind = 4;
      calllists.insert(callevent,4);
      }
   
   PostMessage(MainHWindow, WM_CHECKQUEUE, 0, 0);
   }

void checkwindow(int *x,int *y, int *w, int *h)
   {
   
   // sanity check window coordinates
   
   if (*x < 0) *x = 0;
   if (*y < 0) *y = 0;
   if (*w > MaxWidth) *w = MaxWidth;
   if (*h > MaxHeight) *h = MaxHeight;
   if ((*x+*w) > MaxWidth) *x = *x - (*x+*w-MaxWidth);
   if ((*y+*h) > MaxHeight) *y = *y - (*y+*h-MaxHeight);
   }
