#include "allwind.h"

extern HBITMAP DIBToBitmap (HANDLE hDIB, HPALETTE hPal);
extern HANDLE BitmapToDIB (HBITMAP hBitmap, HPALETTE hPal);

char *tempfont;
int found;
int printflag;
long bitmode = SRCCOPY;

NODE *lbitsave(NODE *arg)
   {
   char textbuf[MAX_BUFFER_SIZE];
   
   /* same as BITMAP-SAVE but gets file name from logo command */
   
   cnv_strnode_string(textbuf,arg);
   
   ((TMyWindow *)MainWindowx)->DumpBitmapFile(textbuf);
   
   return(UNBOUND);
   }

NODE *lbitload(NODE *arg)
   {
   char textbuf[MAX_BUFFER_SIZE];
   
   /* same as BITMAP-LOAD except callable from logo command */
   
   cnv_strnode_string(textbuf,arg);
   
   ((TMyWindow *)MainWindowx)->LoadBitmapFile(textbuf);
   
   return(UNBOUND);
   }

// function that returns the RGB vector of the pixel the turtle is on top of

NODE *lpixel()
   {
   HDC MemDC;
   HDC ScreenDC;
   COLORREF the_color;
   
   ScreenDC = GetDC(MainHWindow);
   
   // memory
   
   MemDC = CreateCompatibleDC(ScreenDC);
   OldBitmap = (HBITMAP)SelectObject(MemDC, MemoryBitMap);
   
   if (EnablePalette)
      {
      OldPalette = SelectPalette(MemDC, ThePalette, FALSE);
      RealizePalette(MemDC);
      }
   
   the_color = GetPixel(MemDC,turtle_x+xoffset,-turtle_y+yoffset);
   
   if (EnablePalette) SelectPalette(MemDC, OldPalette, FALSE);
   
   DeleteDC(MemDC);
   ReleaseDC(MainHWindow, ScreenDC);
   
   return(
   cons(make_intnode((FIXNUM)GetRValue(the_color)),
   cons(make_intnode((FIXNUM)GetGValue(the_color)),
   cons(make_intnode((FIXNUM)GetBValue(the_color)),
   NIL
   ))));
   }

void logofill()
   {
   HDC ScreenDC;
   HDC MemDC;
   HBRUSH JunkBrush;
   
   ScreenDC = GetDC(MainHWindow);
   
   JunkBrush = CreateBrushIndirect(&FloodBrush);
   
   // memory
   
   MemDC = CreateCompatibleDC(ScreenDC);
   OldBitmap = (HBITMAP)SelectObject(MemDC, MemoryBitMap);
   
   if (EnablePalette)
      {
      OldPalette = SelectPalette(MemDC, ThePalette, FALSE);
      RealizePalette(MemDC);
      }
   
   SetTextColor(MemDC,pcolor);
   
   OldBrush = (HBRUSH)SelectObject(MemDC, JunkBrush);
   
   FloodFill(MemDC,turtle_x+xoffset,-turtle_y+yoffset,pcolor);
   
   if (EnablePalette) SelectPalette(MemDC, OldPalette, FALSE);
   SelectObject(MemDC, OldBrush);
   SelectObject(MemDC, OldBitmap);
   
   DeleteDC(MemDC);
   
   //screen
   
   if (zoom_flag)
      {
      SetMapMode(ScreenDC, MM_ANISOTROPIC);
      SetWindowOrg(ScreenDC, 0, 0);
      SetWindowExt(ScreenDC, BitMapWidth, BitMapHeight);
      SetViewportOrg(ScreenDC, 0, 0);
      SetViewportExt(ScreenDC, (int)(BitMapWidth*the_zoom), (int)(BitMapHeight*the_zoom));
      }
   
   //   SetCapture(MainHWindow);
   
   SetTextColor(ScreenDC,pcolor);
   
   if (EnablePalette)
      {
      OldPalette = SelectPalette(ScreenDC, ThePalette, FALSE);
      RealizePalette(ScreenDC);
      }
   
   OldBrush = (HBRUSH)SelectObject(ScreenDC, JunkBrush);
   
   FloodFill(ScreenDC,
   +turtle_x-((TMyWindow *)MainWindowx)->Scroller->XPos/the_zoom+xoffset,
   -turtle_y-((TMyWindow *)MainWindowx)->Scroller->YPos/the_zoom+yoffset,
   pcolor);
   
   SelectObject(ScreenDC, OldBrush);
   if (EnablePalette) SelectPalette(ScreenDC, OldPalette, FALSE);
   
   DeleteObject(JunkBrush);
   //   ReleaseCapture();
   ReleaseDC(MainHWindow, ScreenDC);
   
   }

NODE *lpencolor()
   {
   return(
   cons(make_intnode((FIXNUM)dpenr),
   cons(make_intnode((FIXNUM)dpeng),
   cons(make_intnode((FIXNUM)dpenb),
   NIL
   ))));
   }

// funtion to set the pen color while updating palette if need be

void thepencolor(int r, int g, int b) /*routine*/
   {
   
   dpenr = r;
   dpeng = g;
   dpenb = b;
   
   if (EnablePalette)
      {
      pcolor = LoadColor((int)dpenr,(int)dpeng,(int)dpenb);
      }
   else
      {
      pcolor = RGB(dpenr,dpeng,dpenb);
      }   
   
   NormalPen.lopnStyle   = PS_INSIDEFRAME;
   NormalPen.lopnWidth.x = width;
   NormalPen.lopnColor   = pcolor;
   }

// function to return flood color as a RGB list

NODE *lfloodcolor()
   {
   return(
   cons(make_intnode((FIXNUM)dfldr),
   cons(make_intnode((FIXNUM)dfldg),
   cons(make_intnode((FIXNUM)dfldb),
   NIL
   ))));
   }

// funtion to set the flood color while updating palette if need be

void thefloodcolor(int r, int g, int b) /*routine*/
   {
   
   dfldr = r;
   dfldg = g;
   dfldb = b;
   
   if (EnablePalette)
      {
      fcolor = LoadColor((int)dfldr,(int)dfldg,(int)dfldb);
      }
   else
      {
      fcolor = RGB(dfldr,dfldg,dfldb);
      }
   
   FloodBrush.lbStyle = BS_SOLID;
   FloodBrush.lbColor = fcolor;
   FloodBrush.lbHatch = HS_VERTICAL;
   }

// function to return screen color as a RGB list

NODE *lscreencolor()
   {
   return(
   cons(make_intnode((FIXNUM)dscnr),
   cons(make_intnode((FIXNUM)dscng),
   cons(make_intnode((FIXNUM)dscnb),
   NIL
   ))));
   }

// funtion to set the screen color while updating palette if need be

void thescreencolor(int r, int g, int b) /*routine*/
   {
   HDC ScreenDC;
   HDC MemDC;
   
   HBRUSH TempBrush;
   
   dscnr = r;
   dscng = g;
   dscnb = b;
   
   if (EnablePalette)
      {
      scolor = LoadColor((int)dscnr,(int)dscng,(int)dscnb);
      }
   else
      {
      scolor = RGB(dscnr,dscng,dscnb);
      }
   
   ScreenBrush.lbStyle = BS_SOLID;
   ScreenBrush.lbColor = scolor;
   ScreenBrush.lbHatch = HS_VERTICAL;
   
   // When the screen changes we change the erase pen which basically
   // writes the screen color
   
   ErasePen.lopnStyle   = PS_INSIDEFRAME;
   ErasePen.lopnWidth.x = width;
   ErasePen.lopnColor   = scolor;
   
   TempBrush = CreateBrushIndirect(&ScreenBrush);
   
   ScreenDC = GetDC(MainHWindow);
   
   // memory
   
   MemDC = CreateCompatibleDC(ScreenDC);
   OldBitmap = (HBITMAP)SelectObject(MemDC, MemoryBitMap);
   
   if (EnablePalette)
      {
      OldPalette = SelectPalette(MemDC, ThePalette, FALSE);
      RealizePalette(MemDC);
      }
   
   FillRect(MemDC, &FullRect, TempBrush);
   
   if (EnablePalette) SelectPalette(MemDC, OldPalette, FALSE);
   
   SelectObject(MemDC, OldBitmap);
   DeleteDC(MemDC);
   
   // screen
   
   if (zoom_flag)
      {
      SetMapMode(ScreenDC, MM_ANISOTROPIC);
      SetWindowOrg(ScreenDC, 0, 0);
      SetWindowExt(ScreenDC, BitMapWidth, BitMapHeight);
      SetViewportOrg(ScreenDC, 0, 0);
      SetViewportExt(ScreenDC, (int)(BitMapWidth*the_zoom), (int)(BitMapHeight*the_zoom));
      }
   
   if (EnablePalette)
      {
      OldPalette = SelectPalette(ScreenDC, ThePalette, FALSE);
      RealizePalette(ScreenDC);
      }
   
   FillRect(ScreenDC, &TempRect, TempBrush);
   
   SetBkColor(ScreenDC, scolor);
   SetBkMode(ScreenDC, TRANSPARENT);
   
   if (EnablePalette) SelectPalette(ScreenDC, OldPalette, FALSE);
   
   ReleaseDC(MainHWindow, ScreenDC);
   DeleteObject(TempBrush);
   
   InvalidateRect(MainHWindow, NULL, TRUE);
   }

int get_ibm_pen_width()
   {
   int w;
   
   w = width;
   
   return (w);
   }

//int get_ibm_pen_height()
   //{
   //  int w;
   //
   //  w = width;
   //
   //  return (w);
   //}

void set_ibm_pen_width(int w)
   {
   width = w;
   
   // we erase with the same pen width as we write
   
   NormalPen.lopnStyle   = PS_INSIDEFRAME;
   NormalPen.lopnWidth.x = width;
   NormalPen.lopnColor   = pcolor;
   
   ErasePen.lopnStyle   = PS_INSIDEFRAME;
   ErasePen.lopnWidth.x = width;
   ErasePen.lopnColor   = scolor;
   }

NODE *lclearpalette(void) /*routine*/
   {
   
   // kill the palette and recreate it with just black and white
   
   if (NOT_THROWING)
      {
      if (EnablePalette)
         {
         DeleteObject(ThePalette);
         
         MyLogPalette->palNumEntries = 2;
         
         if (status_flag) update_status_paletteuse();
         
         ThePalette = CreatePalette(MyLogPalette);
         
         InvalidateRect(MainHWindow, NULL, TRUE);
         }
      }
   
   return(UNBOUND);
   }

NODE *lstatus(void) /*routine*/
   {
   
   // if status not running then run it
   
   if (!status_flag)
      {
      ((TMyWindow *)MainWindowx)->MyPopupStatus();
      JustDidEdit = 1;
      }
   return(UNBOUND);
   }

NODE *lnostatus(void) /*routine*/
   {
   
   // if running then kill it
   
   if (status_flag)
      {
      ((TMyWindow *)MainWindowx)->MyPopupStatusKill();
      }
   return(UNBOUND);
   }

// The real work of zooming is done in Paint this just adjusts the scroller
// to something reasonable so that what was basically in the center of the
// screen still is. It also readjusts the ranges on the scrollers.

NODE *lzoom(NODE *arg) /*routine*/
   {
   NUMBER temp_zoom;
   NUMBER XRatio;
   NUMBER YRatio;
   
   int Xr;
   int Yr;
   
   RECT MainRect;
   
   NODE *val;
   
   // get arg
   
   val = numeric_arg(arg);
   
   if (nodetype(val) == INT) temp_zoom = (NUMBER)getint(val);
   else temp_zoom = getfloat(val);
   
   // only if different do something
   
   if (the_zoom != temp_zoom)
      {
      
      the_zoom = temp_zoom;
      
      GetClientRect(MainHWindow,&MainRect);
      
      // calculate new scroller ranges
      
      Xr = (BitMapWidth*the_zoom)-MainRect.right;
      Yr = (BitMapHeight*the_zoom)-MainRect.bottom;
      
      if (Xr < 0) Xr = 0;
      if (Yr < 0) Yr = 0;
      
      // find out where we are (percentage of pos/range for x and y)
      
      if (((TMyWindow *)MainWindowx)->Scroller->XRange <= 0)
         {
         XRatio = 0.5;
         }
      else
         {
         XRatio = (NUMBER)((TMyWindow *)MainWindowx)->Scroller->XPos/(NUMBER)((TMyWindow *)MainWindowx)->Scroller->XRange;
         }
      
      if (((TMyWindow *)MainWindowx)->Scroller->YRange <= 0)
         {
         YRatio = 0.5;
         }
      else
         {
         YRatio = (NUMBER)((TMyWindow *)MainWindowx)->Scroller->YPos/(NUMBER)((TMyWindow *)MainWindowx)->Scroller->YRange;
         }
      
      // set the new ranges
      
      ((TMyWindow *)MainWindowx)->Scroller->SetRange(Xr,Yr);
      
      // Position to the same percentage down the scroll bars as before
      
      ((TMyWindow *)MainWindowx)->Scroller->ScrollTo(XRatio*Xr,YRatio*Yr);
      
      // hide turtle while we do this
      
      if (turtle_shown) ibmturt(0);
      
      // if returning to 1:1 turn TrackMode on
      
      if (zoom_flag)
         {
         zoom_flag = 0;
         
         ((TMyWindow *)MainWindowx)->Scroller->TrackMode = TRUE;
         }
      
      // if leaving 1:1 turn TrackMode off (paint is too slow)
      
      if (temp_zoom != 1.0)
         {
         zoom_flag = 1;
         
         ((TMyWindow *)MainWindowx)->Scroller->TrackMode = FALSE;
         }
      
      if (turtle_shown) ibmturt(0);
      
      // paint
      
      InvalidateRect(MainHWindow, NULL, TRUE);
      
      }
   
   return (UNBOUND);
   }

NODE *lbitblock(NODE *arg) /*routine*/
   {
   HDC ScreenDC;
   HDC MemDC;
   HBRUSH TempBrush;
   RECT TempRect;
   int CutWidth;
   int CutHeight;   
   
   // get args
   
   CutWidth  = getint(pos_int_arg(arg));
   CutHeight = getint(pos_int_arg(cdr(arg)));
   
   if (NOT_THROWING)
      {
      
      // only if a surface was specified continue or UAEs big time
      
      if ((CutWidth != 0) && (CutHeight != 0))
         {
         
         TempBrush = CreateBrushIndirect(&FloodBrush);
         
         ScreenDC = GetDC(MainHWindow);
         
         // memory
         
         MemDC = CreateCompatibleDC(ScreenDC);
         OldBitmap = (HBITMAP)SelectObject(MemDC, MemoryBitMap);
         
         if (EnablePalette)
            {
            OldPalette2 = SelectPalette(ScreenDC, ThePalette, FALSE);
            RealizePalette(ScreenDC);
            
            OldPalette = SelectPalette(MemDC, ThePalette, FALSE);
            RealizePalette(MemDC);
            }
         
         SetRect(&TempRect,
         +turtle_x+xoffset,
         -turtle_y+yoffset-CutHeight,
         +turtle_x+xoffset+CutWidth,
         -turtle_y+yoffset);
         
         FillRect(MemDC, &TempRect, TempBrush);
         
         SelectObject(MemDC, OldBitmap);
         if (EnablePalette) SelectPalette(MemDC, OldPalette, FALSE);
         DeleteDC(MemDC);
         
         //screen
         
         if (turtle_shown) ibmturt(0);
         
         if (zoom_flag)
            {
            SetMapMode(ScreenDC, MM_ANISOTROPIC);
            SetWindowOrg(ScreenDC, 0, 0);
            SetWindowExt(ScreenDC, BitMapWidth, BitMapHeight);
            SetViewportOrg(ScreenDC, 0, 0);
            SetViewportExt(ScreenDC, (int)(BitMapWidth*the_zoom), (int)(BitMapHeight*the_zoom));
            }
         
         //         SetCapture(MainHWindow);
         
         SetRect(&TempRect,
         +turtle_x-((TMyWindow *)MainWindowx)->Scroller->XPos/the_zoom+xoffset,
         -turtle_y-((TMyWindow *)MainWindowx)->Scroller->YPos/the_zoom+yoffset-CutHeight,
         +turtle_x-((TMyWindow *)MainWindowx)->Scroller->XPos/the_zoom+xoffset+CutWidth,
         -turtle_y-((TMyWindow *)MainWindowx)->Scroller->YPos/the_zoom+yoffset);
         
         FillRect(ScreenDC, &TempRect, TempBrush);
         
         //         ReleaseCapture();
         if (EnablePalette) SelectPalette(ScreenDC, OldPalette2, FALSE);
         ReleaseDC(MainHWindow, ScreenDC);
         
         DeleteObject(TempBrush);
         
         if (turtle_shown) ibmturt(0);
         
         }
      
      }
   return(UNBOUND);
   }

NODE *lbitmode(void) /*routine*/
   {
   int temp;
   
   // return the logo "code" for the bit mode
   
   switch (bitmode)
      {
      case SRCCOPY: temp = 1; break;
      case SRCPAINT: temp = 2; break;
      case SRCAND: temp = 3; break;
      case SRCINVERT: temp = 4; break;
      case SRCERASE: temp = 5; break;
      case NOTSRCCOPY: temp = 6; break;
      case NOTSRCERASE: temp = 7; break;
      case MERGEPAINT: temp = 8; break;
      case DSTINVERT: temp = 9; break;
      }
   
   return(make_intnode((FIXNUM)temp));
   }

NODE *lsetbitmode(NODE *arg) /*routine*/
   {
   
   // convert from logo "code" to Windows constants
   
   switch (int_arg(arg))
      {
      case 1: bitmode = SRCCOPY; break;
      case 2: bitmode = SRCPAINT; break;
      case 3: bitmode = SRCAND; break;
      case 4: bitmode = SRCINVERT; break;
      case 5: bitmode = SRCERASE; break;
      case 6: bitmode = NOTSRCCOPY; break;
      case 7: bitmode = NOTSRCERASE; break;
      case 8: bitmode = MERGEPAINT; break;
      case 9: bitmode = DSTINVERT; break;
      default: MessageBox(MainHWindow, "Illegal Bitmode", "Error", MB_OK | MB_ICONEXCLAMATION);
      }
   
   return(UNBOUND);
   }

NODE *lbitindex(void) /*routine*/
   {
   // return the current bitmap index
   
   return(make_intnode((FIXNUM)CutIndex));
   }

NODE *lsetbitindex(NODE *arg) /*routine*/
   {
   int i;
   
   // set the current bitmap index if within range
   
   i = getint(pos_int_arg(arg));
   
   if (i < MaxBitCuts)
      {
      CutIndex = i;
      }
   else
      {
      MessageBox(MainHWindow, "BitMap Index out of range", "Error", MB_OK | MB_ICONEXCLAMATION);
      }
   
   return(UNBOUND);
   }

NODE *lbitcut(NODE *arg) /*routine*/
   {
   HDC ScreenDC;
   HDC MemDC;
   HDC TempMemDC;
   
   HBRUSH TempBrush;
   
   RECT TempRect;
   
   int TempWidth;
   int TempHeight;
   int havebitmap;
   
   havebitmap = 0;
   
   TempWidth  = getint(pos_int_arg(arg));
   TempHeight = getint(pos_int_arg(cdr(arg)));
   
   if (NOT_THROWING)
      {
      
      // if we had a old cut get rid of it, we won't go in for clipboard
      
      if (CutBmp[CutIndex].CutFlag)
         {
         
         // if same size reuse the bitmap
         
         if ((TempWidth == CutBmp[CutIndex].CutWidth) && (TempHeight == CutBmp[CutIndex].CutHeight))
            {
            havebitmap = 1;
            }
         
         // else get rid of it and make a new one later
         
         else
            {
            DeleteObject(CutBmp[CutIndex].CutMemoryBitMap);
            }
         CutBmp[CutIndex].CutFlag = 0;
         }
      
      CutBmp[CutIndex].CutWidth = TempWidth;
      CutBmp[CutIndex].CutHeight = TempHeight;
      
      // only if we have a surface continue
      
      if ((CutBmp[CutIndex].CutWidth != 0) && (CutBmp[CutIndex].CutHeight != 0))
         {
         
         // flag it so we will delete it
         
         CutBmp[CutIndex].CutFlag = 1;
         
         ScreenDC = GetDC(MainHWindow);
         
         MemDC = CreateCompatibleDC(ScreenDC);
         OldBitmap = (HBITMAP)SelectObject(MemDC, MemoryBitMap);
         
         if (!havebitmap) CutBmp[CutIndex].CutMemoryBitMap = CreateCompatibleBitmap(ScreenDC, (int)(CutBmp[CutIndex].CutWidth), (int)(CutBmp[CutIndex].CutHeight));
         if (!CutBmp[CutIndex].CutMemoryBitMap) MessageBox(MainHWindow, "Cut failed, Possibly not enough Memory", "Error", MB_OK | MB_ICONEXCLAMATION);
         
         TempMemDC = CreateCompatibleDC(ScreenDC);
         OldBitmap2 = (HBITMAP)SelectObject(TempMemDC, CutBmp[CutIndex].CutMemoryBitMap);
         
         BitBlt(TempMemDC, 0, 0, (int)(CutBmp[CutIndex].CutWidth), (int)(CutBmp[CutIndex].CutHeight), MemDC, 
         +turtle_x+xoffset,
         -turtle_y+yoffset-CutBmp[CutIndex].CutHeight, SRCCOPY);
         
         SelectObject(TempMemDC, OldBitmap2);
         DeleteDC(TempMemDC);
         
         // memory
         
         SetRect(&TempRect,
         +turtle_x+xoffset,
         -turtle_y+yoffset-CutBmp[CutIndex].CutHeight,
         +turtle_x+xoffset+CutBmp[CutIndex].CutWidth,
         -turtle_y+yoffset);
         
         TempBrush = CreateBrushIndirect(&ScreenBrush);
         
         FillRect(MemDC, &TempRect, TempBrush);
         
         SelectObject(MemDC, OldBitmap);
         DeleteDC(MemDC);
         
         //screen
         
         if (turtle_shown) ibmturt(0);
         
         if (zoom_flag)
            {
            SetMapMode(ScreenDC, MM_ANISOTROPIC);
            SetWindowOrg(ScreenDC, 0, 0);
            SetWindowExt(ScreenDC, BitMapWidth, BitMapHeight);
            SetViewportOrg(ScreenDC, 0, 0);
            SetViewportExt(ScreenDC, (int)(BitMapWidth*the_zoom), (int)(BitMapHeight*the_zoom));
            }
         
         //         SetCapture(MainHWindow);
         
         SetRect(&TempRect,
         +turtle_x-((TMyWindow *)MainWindowx)->Scroller->XPos/the_zoom+xoffset,
         -turtle_y-((TMyWindow *)MainWindowx)->Scroller->YPos/the_zoom+yoffset-CutBmp[CutIndex].CutHeight,
         +turtle_x-((TMyWindow *)MainWindowx)->Scroller->XPos/the_zoom+xoffset+CutBmp[CutIndex].CutWidth,
         -turtle_y-((TMyWindow *)MainWindowx)->Scroller->YPos/the_zoom+yoffset);
         
         FillRect(ScreenDC, &TempRect, TempBrush);
         
         //         ReleaseCapture();
         ReleaseDC(MainHWindow, ScreenDC);
         
         DeleteObject(TempBrush);
         
         if (turtle_shown) ibmturt(0);
         
         // if CutIndex == 0 then do Clipboard 
         
         if (CutIndex == 0)
            {
            
            // Open, dump what's in there and give him the Bitmap
            
            OpenClipboard(MainHWindow);
            EmptyClipboard();
            SetClipboardData(CF_BITMAP, CutBmp[CutIndex].CutMemoryBitMap);
            
            // If we have a palette given him a DIB and a palette too
            
            if (EnablePalette)
               {
               SetClipboardData(CF_DIB, BitmapToDIB(CutBmp[CutIndex].CutMemoryBitMap,ThePalette));
               SetClipboardData(CF_PALETTE, CreatePalette(MyLogPalette));
               }
            
            // else give hime a DIB using system palette
            
            else
               {
               SetClipboardData(CF_DIB, BitmapToDIB(CutBmp[CutIndex].CutMemoryBitMap,NULL));
               }
            CloseClipboard();
            
            // Never mung with bitmaps that belong to ClipBoard
            
            CutBmp[CutIndex].CutFlag = 0;
            }
         
         }
      
      }
   return(UNBOUND);
   }

NODE *lbitcopy(NODE *arg) /*routine*/
   {
   HDC ScreenDC;
   HDC MemDC;
   HDC TempMemDC;
   HBRUSH TempBrush;
   RECT TempRect;
   int TempWidth;
   int TempHeight;
   int havebitmap;
   
   havebitmap = 0;
   
   TempWidth  = getint(pos_int_arg(arg));
   TempHeight = getint(pos_int_arg(cdr(arg)));
   
   if (NOT_THROWING)
      {
      
      // if we had a old cut get rid of it, we won't go in for clipboard
      
      if (CutBmp[CutIndex].CutFlag)
         {
         
         // if same size reuse the bitmap
         
         if ((TempWidth == CutBmp[CutIndex].CutWidth) && (TempHeight == CutBmp[CutIndex].CutHeight))
            {
            havebitmap = 1;
            }
         
         // else get rid of it and make a new one later
         
         else
            {
            DeleteObject(CutBmp[CutIndex].CutMemoryBitMap);
            }
         CutBmp[CutIndex].CutFlag = 0;
         }
      
      CutBmp[CutIndex].CutWidth = TempWidth;
      CutBmp[CutIndex].CutHeight = TempHeight;
      
      // only if we have a surface continue
      
      if ((CutBmp[CutIndex].CutWidth != 0) && (CutBmp[CutIndex].CutHeight != 0))
         {
         
         // flag it so we will delete it
         
         CutBmp[CutIndex].CutFlag = 1;
         
         ScreenDC = GetDC(MainHWindow);
         
         MemDC = CreateCompatibleDC(ScreenDC);
         OldBitmap = (HBITMAP)SelectObject(MemDC, MemoryBitMap);
         
         if (!havebitmap) CutBmp[CutIndex].CutMemoryBitMap = CreateCompatibleBitmap(ScreenDC, (int)(CutBmp[CutIndex].CutWidth), (int)(CutBmp[CutIndex].CutHeight));
         if (!CutBmp[CutIndex].CutMemoryBitMap) MessageBox(MainHWindow, "Cut failed, Possibly not enough Memory", "Error", MB_OK | MB_ICONEXCLAMATION);
         
         TempMemDC = CreateCompatibleDC(ScreenDC);
         OldBitmap2 = (HBITMAP)SelectObject(TempMemDC, CutBmp[CutIndex].CutMemoryBitMap);
         
         BitBlt(TempMemDC, 0, 0, (int)(CutBmp[CutIndex].CutWidth), (int)(CutBmp[CutIndex].CutHeight), MemDC, 
         +turtle_x+xoffset,
         -turtle_y+yoffset-CutBmp[CutIndex].CutHeight, SRCCOPY);
         
         SelectObject(TempMemDC, OldBitmap2);
         DeleteDC(TempMemDC);
         
         SelectObject(MemDC, OldBitmap);
         DeleteDC(MemDC);         
         
         ReleaseDC(MainHWindow, ScreenDC);
         
         // if CutIndex == 0 then do Clipboard 
         
         if (CutIndex == 0)
            {
            
            // Open, dump what's in there and give him the Bitmap
            
            OpenClipboard(MainHWindow);
            EmptyClipboard();
            SetClipboardData(CF_BITMAP, CutBmp[CutIndex].CutMemoryBitMap);
            
            // If we have a palette given him a DIB and a palette too
            
            if (EnablePalette)
               {
               SetClipboardData(CF_DIB, BitmapToDIB(CutBmp[CutIndex].CutMemoryBitMap,ThePalette));
               SetClipboardData(CF_PALETTE, CreatePalette(MyLogPalette));
               }
            
            // else give hime a DIB using system palette
            
            else
               {
               SetClipboardData(CF_DIB, BitmapToDIB(CutBmp[CutIndex].CutMemoryBitMap,NULL));
               }
            CloseClipboard();
            
            // Never mung with bitmaps that belong to ClipBoard
            
            CutBmp[CutIndex].CutFlag = 0;
            }
         }
      }
   return(UNBOUND);
   }

NODE *lbitfit(NODE *arg) /*routine*/
   {
   HDC      ScreenDC;
   HDC      MemDC;
   HDC      TempMemDC;
   
   NUMBER   FitHeight;
   NUMBER   FitWidth;
   
   HBITMAP  TempMemoryBitMap;
   
   BITMAP temp;
   HANDLE TempDIB;
   HPALETTE TempPal;
   
   FitWidth  = getint(pos_int_arg(arg));
   FitHeight = getint(pos_int_arg(cdr(arg)));
   
   if (NOT_THROWING)
      {
      
      // If ClipBoard check with ClipBoard only
      
      if (CutIndex == 0)
         {
         OpenClipboard(MainHWindow);
         
         // Try a DIB first
         
         TempDIB = (HBITMAP) GetClipboardData(CF_DIB);
         
         // If Success try for a palette too
         
         if (TempDIB != NULL)
            {
            TempPal = (HPALETTE) GetClipboardData(CF_PALETTE);
            
            // we have everything we need
            
            CloseClipboard();
            
            // we work in bmps here
            
            CutBmp[CutIndex].CutMemoryBitMap = DIBToBitmap (TempDIB, TempPal);
            
            // Fill our logical palette with the Palette from the clipboard
            
            if (EnablePalette && (TempPal != NULL))
               {
               GetPaletteEntries(TempPal, 0, 255, &(MyLogPalette->palPalEntry[0]));
               
               // now rebuild palette
               
               DeleteObject(ThePalette);
               ThePalette = CreatePalette(MyLogPalette);
               if (status_flag) update_status_paletteuse();
               }
            
            // Let code know below that we have something
            
            CutBmp[CutIndex].CutFlag = 1;
            
            // note we do not have to delete bitmap here because we
            // going to immediately give it back to clipboard.
            }
         
         // else try for a bitmap
         
         else
            {
            
            CutBmp[CutIndex].CutMemoryBitMap = (HBITMAP) GetClipboardData(CF_BITMAP);
            
            // where done whether they have it or not
            
            CloseClipboard();
            
            // flag that we have one if it exists, no need to delete the
            // bitmap here because clipboard still owns it.
            
            if (CutBmp[CutIndex].CutMemoryBitMap != NULL)
               {
               CutBmp[CutIndex].CutFlag = 1;
               }
            else
               {
               CutBmp[CutIndex].CutFlag = 0;
               }
            }
         
         // if we have something fetch its size
         
         if (CutBmp[CutIndex].CutFlag)
            {
            GetObject(CutBmp[CutIndex].CutMemoryBitMap, sizeof (BITMAP), (LPSTR)&temp);
            CutBmp[CutIndex].CutWidth = temp.bmWidth;
            CutBmp[CutIndex].CutHeight = temp.bmHeight;
            }
         }
      
      // only if we have a surface to fit to and from continue
      
      if ((FitWidth != 0) && (FitHeight != 0) && CutBmp[CutIndex].CutFlag)
         {
         
         ScreenDC = GetDC(MainHWindow);
         
         MemDC = CreateCompatibleDC(ScreenDC);
         OldBitmap = (HBITMAP)SelectObject(MemDC, CutBmp[CutIndex].CutMemoryBitMap);
         
         if (EnablePalette)
            {
            OldPalette2 = SelectPalette(ScreenDC, ThePalette, FALSE);
            RealizePalette(ScreenDC);
            
            OldPalette = SelectPalette(MemDC, ThePalette, FALSE);
            RealizePalette(MemDC);
            }
         
         TempMemoryBitMap = CreateCompatibleBitmap(ScreenDC, (int)(FitWidth), (int)(FitHeight));
         if (!TempMemoryBitMap) MessageBox(MainHWindow, "Fit failed, Possibly not enough Memory", "Error", MB_OK | MB_ICONEXCLAMATION);
         
         TempMemDC = CreateCompatibleDC(ScreenDC);
         OldBitmap2 = (HBITMAP)SelectObject(TempMemDC, TempMemoryBitMap);
         
         if (EnablePalette) SelectPalette(ScreenDC, OldPalette2, FALSE);
         ReleaseDC(MainHWindow,ScreenDC);
         
         if (EnablePalette)
            {
            OldPalette2 = SelectPalette(TempMemDC, ThePalette, FALSE);
            RealizePalette(TempMemDC);
            }
         
         SetStretchBltMode(TempMemDC,COLORONCOLOR);
         
         // Load hour-glass cursor.
         hCursor = SetCursor(hCursorWait);
         
         StretchBlt(TempMemDC,
         0,
         0,
         FitWidth,
         FitHeight,
         MemDC,
         0,
         0,
         CutBmp[CutIndex].CutWidth,
         CutBmp[CutIndex].CutHeight,
         SRCCOPY);
         
         // Reload arrow cursor.
         SetCursor(hCursor);
         
         if (EnablePalette)
            {
            SelectPalette(MemDC, OldPalette, FALSE);
            SelectPalette(TempMemDC, OldPalette2, FALSE);
            }
         
         SelectObject(TempMemDC, OldBitmap2);
         DeleteDC(TempMemDC);
         
         SelectObject(MemDC, OldBitmap);
         DeleteDC(MemDC);
         
         DeleteObject(CutBmp[CutIndex].CutMemoryBitMap);
         CutBmp[CutIndex].CutMemoryBitMap = TempMemoryBitMap;
         
         CutBmp[CutIndex].CutWidth  = FitWidth;
         CutBmp[CutIndex].CutHeight = FitHeight;
         
         if (CutIndex == 0)
            {
            OpenClipboard(MainHWindow);
            EmptyClipboard();
            SetClipboardData(CF_BITMAP, CutBmp[CutIndex].CutMemoryBitMap);
            if (EnablePalette)
               {
               SetClipboardData(CF_DIB, BitmapToDIB(CutBmp[CutIndex].CutMemoryBitMap,ThePalette));
               SetClipboardData(CF_PALETTE, CreatePalette(MyLogPalette));
               }
            else
               {
               SetClipboardData(CF_DIB, BitmapToDIB(CutBmp[CutIndex].CutMemoryBitMap,NULL));
               }
            CloseClipboard();
            CutBmp[CutIndex].CutFlag = 0;
            }
         }
      }
   return(UNBOUND);
   }

NODE *lbitpaste(void) /*routine*/
   {
   HDC ScreenDC;
   HDC MemDC;
   HDC TempMemDC;
   
   RECT TempRect;
   
   BITMAP temp;
   
   HANDLE TempDIB;
   
   HPALETTE TempPal;
   
   int DeleteBitMapWhenDone;
   
   if (NOT_THROWING)
      {
      
      DeleteBitMapWhenDone = 0;
      
      // If ClipBoard check with ClipBoard only
      
      if (CutIndex == 0)
         {
         
         OpenClipboard(MainHWindow);
         
         // Try a DIB first
         
         TempDIB = (HBITMAP) GetClipboardData(CF_DIB);
         
         // If Success try for a palette too
         
         if (TempDIB != NULL)
            {
            TempPal = (HPALETTE) GetClipboardData(CF_PALETTE);
            
            // we have everything we need
            
            CloseClipboard();
            
            // we work in bmps here
            
            CutBmp[CutIndex].CutMemoryBitMap = DIBToBitmap(TempDIB, TempPal);
            
            // Fill our logical palette with the Palette from the clipboard
            
            if (EnablePalette && (TempPal != NULL))
               {
               GetPaletteEntries(TempPal, 0, 255, &(MyLogPalette->palPalEntry[0]));
               
               // now rebuild palette
               
               DeleteObject(ThePalette);
               ThePalette = CreatePalette(MyLogPalette);
               if (status_flag) update_status_paletteuse();
               }
            
            // Let code know below that we have something
            
            CutBmp[CutIndex].CutFlag = 1;
            
            // We created a BitMap from the DIB that we only need for the
            // purpose of this "paste", next paste could be something new.
            // so get rid of it once we have pasted it here.
            
            DeleteBitMapWhenDone = 1;
            }
         
         // else try for a bitmap
         
         else
            {
            CutBmp[CutIndex].CutMemoryBitMap = (HBITMAP) GetClipboardData(CF_BITMAP);
            
            // where done whether they have it or not
            
            CloseClipboard();
            
            // flag that we have one if it exists, no need to delete the
            // bitmap here because clipboard still owns it.
            
            if (CutBmp[CutIndex].CutMemoryBitMap != NULL)
               {
               CutBmp[CutIndex].CutFlag = 1;
               }
            else
               {
               CutBmp[CutIndex].CutFlag = 0;
               }
            }
         
         // if we have something fetch its size
         
         if (CutBmp[CutIndex].CutFlag)
            {
            GetObject(CutBmp[CutIndex].CutMemoryBitMap, sizeof (BITMAP), (LPSTR)&temp);
            CutBmp[CutIndex].CutWidth = temp.bmWidth;
            CutBmp[CutIndex].CutHeight = temp.bmHeight;
            }
         }
      
      // only if we have something to paste
      
      if (CutBmp[CutIndex].CutFlag)
         {
         
         // if clipboard then never leave Cut Flag true
         
         if (CutIndex == 0) CutBmp[CutIndex].CutFlag = 0;
         
         ScreenDC = GetDC(MainHWindow);
         
         TempMemDC = CreateCompatibleDC(ScreenDC);
         OldBitmap2 = (HBITMAP)SelectObject(TempMemDC, CutBmp[CutIndex].CutMemoryBitMap);
         
         //memory
         
         MemDC = CreateCompatibleDC(ScreenDC);
         OldBitmap = (HBITMAP)SelectObject(MemDC, MemoryBitMap);
         
         BitBlt(MemDC,
         +turtle_x+xoffset,
         -turtle_y+yoffset-CutBmp[CutIndex].CutHeight,
         (int)(CutBmp[CutIndex].CutWidth),
         (int)(CutBmp[CutIndex].CutHeight),
         TempMemDC, 0, 0, bitmode);
         
         SelectObject(MemDC, OldBitmap);
         DeleteDC(MemDC);
         
         //screen
         
         if (turtle_shown) ibmturt(0);
         
         if (zoom_flag)
            {
            SetMapMode(ScreenDC, MM_ANISOTROPIC);
            SetWindowOrg(ScreenDC, 0, 0);
            SetWindowExt(ScreenDC, BitMapWidth, BitMapHeight);
            SetViewportOrg(ScreenDC, 0, 0);
            SetViewportExt(ScreenDC, (int)(BitMapWidth*the_zoom), (int)(BitMapHeight*the_zoom));
            }
         
         //         SetCapture(MainHWindow);
         
         //         SetRect(&TempRect,
         //         +turtle_x-((TMyWindow *)MainWindowx)->Scroller->XPos/the_zoom+xoffset,
         //         -turtle_y-((TMyWindow *)MainWindowx)->Scroller->YPos/the_zoom+yoffset-CutBmp[CutIndex].CutHeight,
         //         +turtle_x-((TMyWindow *)MainWindowx)->Scroller->XPos/the_zoom+xoffset+CutBmp[CutIndex].CutWidth,
         //         -turtle_y-((TMyWindow *)MainWindowx)->Scroller->YPos/the_zoom+yoffset);
         
         BitBlt(ScreenDC,
         +turtle_x-((TMyWindow *)MainWindowx)->Scroller->XPos/the_zoom+xoffset,
         -turtle_y-((TMyWindow *)MainWindowx)->Scroller->YPos/the_zoom+yoffset-CutBmp[CutIndex].CutHeight,
         (int)(CutBmp[CutIndex].CutWidth),
         (int)(CutBmp[CutIndex].CutHeight),
         TempMemDC, 0, 0, bitmode);
         
         //         ReleaseCapture();
         ReleaseDC(MainHWindow, ScreenDC);
         
         if (turtle_shown) ibmturt(0);
         
         SelectObject(TempMemDC, OldBitmap2);
         DeleteDC(TempMemDC);
         
         // Clipboard owns what we paste in not what we converted
         
         if (DeleteBitMapWhenDone) DeleteObject(CutBmp[CutIndex].CutMemoryBitMap);
         }
      else
         {
         MessageBox(MainHWindow, "Nothing to Paste", "Error", MB_OK | MB_ICONEXCLAMATION);
         }
      }
   return(UNBOUND);
   }

NODE *lscrollx(NODE *arg) /*routine*/
   {
   int delta;
   
   // get args and scroll the scroller
   
   delta = getint(numeric_arg(arg));
   
   ((TMyWindow *)MainWindowx)->Scroller->ScrollTo(
   ((TMyWindow *)MainWindowx)->Scroller->XPos+delta,
   ((TMyWindow *)MainWindowx)->Scroller->YPos);
   
   return(UNBOUND);
   }

NODE *lscrolly(NODE *arg) /*routine*/
   {
   int delta;
   
   // get args and scroll the scroller
   
   delta = getint(numeric_arg(arg));
   
   ((TMyWindow *)MainWindowx)->Scroller->ScrollTo(
   ((TMyWindow *)MainWindowx)->Scroller->XPos,
   ((TMyWindow *)MainWindowx)->Scroller->YPos+delta);
   
   return(UNBOUND);
   }

NODE *lsetfocus(NODE *arg) /*routine*/
   {
   char textbuf[MAX_BUFFER_SIZE];
   
   HWND EditH;
   
   cnv_strnode_string(textbuf,arg);
   
   // get handle to Window with arg as Caption   
   
   EditH = FindWindow(NULL, textbuf);
   
   // Now set focus to it, if it exists
   
   if (EditH != NULL)
      {
      SetFocus(EditH);
      }
   
   JustDidEdit = 1;
   
   return(UNBOUND);
   }

NODE *lgetfocus(void) /*routine*/
   {
   NODE *arg, *val = UNBOUND;
   char textbuf[MAX_BUFFER_SIZE];
   
   int i;
   
   HWND TempH;
   
   //??
   
   for (i=0;i<MAX_BUFFER_SIZE;i++) textbuf[i] = '\0';
   
   // Get handle to active window
   
   TempH = GetActiveWindow();
   
   // It better exist, get it's caption
   
   if (TempH != NULL)
      {
      GetWindowText(TempH, textbuf, MAX_BUFFER_SIZE);
      }
   
   JustDidEdit = 1;
   
   // Return caption as a list
   
   arg = make_strnode(textbuf, NULL, strlen(textbuf), STRING, strnzcpy);
   val = parser(arg, FALSE);
   return(val);
   
   }

NODE *licon(NODE *arg) /*routine*/
   {
   char textbuf[MAX_BUFFER_SIZE];
   
   HWND EditH;
   
   cnv_strnode_string(textbuf,arg);
   
   // get handle to Window with arg as Caption   
   
   EditH = FindWindow(NULL, textbuf);
   
   // if it exists icon it.
   
   if (EditH != NULL)
      {
      CloseWindow(EditH);
      }
   
   JustDidEdit = 1;
   
   return(UNBOUND);
   }

NODE *lunicon(NODE *arg) /*routine*/
   {
   char textbuf[MAX_BUFFER_SIZE];
   
   HWND EditH;
   
   cnv_strnode_string(textbuf,arg);
   
   // get handle to Window with arg as Caption   
   
   EditH = FindWindow(NULL, textbuf);
   
   // if it exists unicon it.
   
   if (EditH != NULL)
      {
      OpenIcon(EditH);
      }
   
   JustDidEdit = 1;
   
   return(UNBOUND);
   }

void ibm_clear_screen(void) /*routine*/
   {
   HDC TempDC;
   HDC MemDC;
   
   HBRUSH TempBrush;
   
   TempBrush = CreateBrushIndirect(&ScreenBrush);
   TempDC = GetDC(MainHWindow);
   
   // screen
   
   if (zoom_flag)
      {
      SetMapMode(TempDC, MM_ANISOTROPIC);
      SetWindowOrg(TempDC, 0, 0);
      SetWindowExt(TempDC, BitMapWidth, BitMapHeight);
      SetViewportOrg(TempDC, 0, 0);
      SetViewportExt(TempDC, (int)(BitMapWidth*the_zoom), (int)(BitMapHeight*the_zoom));
      }
   
   FillRect(TempDC, &TempRect, TempBrush);
   SetBkColor(TempDC, scolor);
   SetBkMode(TempDC, TRANSPARENT);
   
   // memory
   
   MemDC = CreateCompatibleDC(TempDC);
   OldBitmap = (HBITMAP)SelectObject(MemDC, MemoryBitMap);
   
   FillRect(MemDC, &FullRect, TempBrush);
   
   SetBkColor(MemDC, scolor);
   SetBkMode(MemDC, TRANSPARENT);
   
   SelectObject(MemDC, OldBitmap);
   DeleteDC(MemDC);
   
   ReleaseDC(MainHWindow, TempDC);
   DeleteObject(TempBrush);
   }

void option_helper(short *var, NODE *arg)
   {
   NODE *val;
   
   val = integer_arg(arg);
   if (NOT_THROWING)
   *var = (short)getint(val);
   }

int FAR PASCAL _export EnumerateFont( LPLOGFONT LogFont, LPTEXTMETRIC, short, LPSTR)
   {
   
   // if printflag just print the enumerated font
   
   if (printflag == 1)
      {
      printfx("[%s]\n",LogFont->lfFaceName);
      }
   
   // else chcek for a match
   
   else
      {
      if (stricmp(tempfont,LogFont->lfFaceName) == 0)
         {
         
         // take a copy, flag one was found and return
         
         memcpy(&FontRec,LogFont,sizeof(FontRec));
         found = 1;
         return 0;
         }
      }
   
   NumFonts++;
   
   if (NumFonts > MaxNumFonts)
      {
      return 0;  /* Don't send any more information */
      }
   else
      {
      return 1; /* Send more information if available */
      }
   
   };

/* Collect all of the system fonts */

void GetFontInfo()
   {
   HDC TheDC;
   
   OLDFONTENUMPROC EnumProc;
   
   TheDC = GetDC(GetFocus());
   NumFonts = 0;
   
   /* Create an instance of the call back function.  This allows
   our program to refer to an exported function.  Otherwise the
   Data segment will not be correct. */
   
   EnumProc = (OLDFONTENUMPROC)MakeProcInstance((FARPROC) EnumerateFont, GetApplicationObject()->hInstance);
   
   /* Gather information about all fonts that are allowable in our window (DC) */
   
   EnumFonts(TheDC, NULL, EnumProc, NULL);
   
   /* Free the instance of our call back function */
   
   FreeProcInstance((FARPROC)EnumProc);
   ReleaseDC(GetFocus(), TheDC);
   
   };

void setfont(char *s)
   {
   found = 0;
   printflag = 0;
   
   // set global font to compare to (FontRec will get filled if found)
   
   tempfont=s;
   
   GetFontInfo();
   
   // if not found enumerate again with printing enabled
   
   if (!found)
      {
      printfx("Sorry, %s Font does not exist, choose one of the following:\n\n",s);
      printflag = 1;
      GetFontInfo();
      }
   
   }

void do_help(char *arg)
   { 
   
   /* if arg NULL then jump to index else try to lookup key */
   
   if (arg == NULL) WinHelp(MainHWindow,szHelpFileName,HELP_INDEX,0L);
   else WinHelp(MainHWindow,szHelpFileName,HELP_KEY,(DWORD)arg);
   JustDidEdit = 1;
   }

NODE *lhelp(NODE *arg)
   {
   char textbuf[MAX_BUFFER_SIZE];
   
   // if arg then pass to do_help
   
   if (arg != NIL)
      {
      cnv_strnode_string(textbuf,arg);
      
      do_help(textbuf);
      }
   
   // else just pop up help
   
   else
      {
      do_help(NULL);
      }
   
   return (UNBOUND);
   }

NODE *lwinhelp(NODE *arg)
   {
   char textbuf[MAX_BUFFER_SIZE];
   char textbuf2[MAX_BUFFER_SIZE];
   
   cnv_strnode_string(textbuf,arg);
   
   // if 2nd arg then pass to winhelp
   
   if (cdr(arg) != NIL)
      {
      cnv_strnode_string(textbuf2,cdr(arg));
      WinHelp(MainHWindow,textbuf,HELP_KEY,(DWORD)textbuf2);
      }
   
   // else just give help on file (arg 1)
   
   else
      {   
      WinHelp(MainHWindow,textbuf,HELP_INDEX,0L);
      }
   
   return (UNBOUND);
   }

NODE *lsettextfont(NODE *arg)
   {
   NODE *args;
   char textbuf[MAX_BUFFER_SIZE];
   
   args = car(arg);
   
   if (is_list(args))
      {
      cnv_strnode_string(textbuf,args);
      
      // Get the FontRec filled with a match to textbuff
      
      setfont(textbuf);
      
      // now fill in the rest of the fields if given
      
      if (cdr(args) != NIL)
      FontRec.lfHeight         = int_arg(args=cdr(args));
      if (cdr(args) != NIL)
      FontRec.lfWeight         = getint(pos_int_arg(args=cdr(args)));
      if (cdr(args) != NIL)
      FontRec.lfItalic         = getint(pos_int_arg(args=cdr(args)));
      if (cdr(args) != NIL)
      FontRec.lfUnderline      = getint(pos_int_arg(args=cdr(args)));
      if (cdr(args) != NIL)
      FontRec.lfStrikeOut      = getint(pos_int_arg(args=cdr(args)));
      
      // update status window
      
      if (status_flag)
         {
         update_status_fontwieght();
         update_status_fontsize();
         update_status_fontname();
         }
      }
   
   return(UNBOUND);
   }

NODE *ltextfont(void)
   {
   NODE *targ, *val = UNBOUND;
   
   // put the Font name in a list
   
   targ = make_strnode(FontRec.lfFaceName, NULL, strlen(FontRec.lfFaceName), STRING, strnzcpy);
   val = parser(targ, FALSE);
   
   // now return the whole thing as a list
   
   return(
   cons(val,
   cons(make_intnode((FIXNUM)FontRec.lfHeight),
   cons(make_intnode((FIXNUM)FontRec.lfWeight),
   cons(make_intnode((FIXNUM)FontRec.lfItalic),
   cons(make_intnode((FIXNUM)FontRec.lfUnderline),
   cons(make_intnode((FIXNUM)FontRec.lfStrikeOut),
   NIL
   )))))));
   
   }

NODE *lmachine(void)
   {
   NODE *targ, *val = UNBOUND;
   
   // build list with system specific information
   
   return(
   cons(make_intnode((FIXNUM)1),
#ifdef ISWIN31
   cons(make_intnode((FIXNUM)31),
#else
   cons(make_intnode((FIXNUM)30),
#endif
   cons(make_intnode((FIXNUM)BitMapWidth),
   cons(make_intnode((FIXNUM)BitMapHeight),
   cons(make_intnode((FIXNUM)EnablePalette),
   NIL
   ))))));
   
   }

void label(char *s)
   {
   HDC ScreenDC;
   HDC MemDC;
   
   HFONT TempFont;
   
   ScreenDC = GetDC(MainHWindow);
   
   FontRec.lfEscapement = (360.0-(turtle_heading-90.0))*10;
   TempFont = CreateFontIndirect(&FontRec);
   
   // memory
   
   MemDC = CreateCompatibleDC(ScreenDC);
   OldBitmap = (HBITMAP)SelectObject(MemDC, MemoryBitMap);
   
   if (EnablePalette)
      {
      OldPalette = SelectPalette(MemDC, ThePalette, FALSE);
      RealizePalette(MemDC);
      }
   
   SetBkColor(MemDC, scolor);
   SetBkMode(MemDC, TRANSPARENT);
   SetTextColor(MemDC,pcolor);
   
   OldFont = (HFONT)SelectObject(MemDC,TempFont);
   
   TextOut(MemDC,
   +turtle_x+xoffset,
   -turtle_y+yoffset,
   s,strlen(s));
   
   if (EnablePalette) SelectPalette(MemDC, OldPalette, FALSE);
   SelectObject(MemDC, OldFont);
   SelectObject(MemDC, OldBitmap);
   DeleteDC(MemDC);
   
   //screen
   
   if (zoom_flag)
      {
      SetMapMode(ScreenDC, MM_ANISOTROPIC);
      SetWindowOrg(ScreenDC, 0, 0);
      SetWindowExt(ScreenDC, BitMapWidth, BitMapHeight);
      SetViewportOrg(ScreenDC, 0, 0);
      SetViewportExt(ScreenDC, (int)(BitMapWidth*the_zoom), (int)(BitMapHeight*the_zoom));
      }
   
   //   SetCapture(MainHWindow);
   
   if (EnablePalette)
      {
      OldPalette = SelectPalette(ScreenDC, ThePalette, FALSE);
      RealizePalette(ScreenDC);
      }
   
   SetBkColor(ScreenDC, scolor);
   SetBkMode(ScreenDC, TRANSPARENT);
   SetTextColor(ScreenDC,pcolor);
   
   OldFont = (HFONT)SelectObject(ScreenDC,TempFont);
   
   TextOut(ScreenDC,
   +turtle_x-((TMyWindow *)MainWindowx)->Scroller->XPos/the_zoom+xoffset,
   -turtle_y-((TMyWindow *)MainWindowx)->Scroller->YPos/the_zoom+yoffset,
   s,strlen(s));
   
   SelectObject(ScreenDC, OldFont);
   if (EnablePalette) SelectPalette(ScreenDC, OldPalette, FALSE);
   
   DeleteObject(TempFont);
   
   //   ReleaseCapture();
   ReleaseDC(MainHWindow, ScreenDC);
   
   }

void exit_program(void)
   { 
   if (halt_flag != 0) Time_To_Halt = 1;
   Time_To_Exit = 1;
   }

NODE *lpeek(NODE *arg) /*routine*/
   {
   int seg;
   int off;
   int dat;   
   
   seg = getint(pos_int_arg(arg));
   off = getint(pos_int_arg(cdr(arg)));
   
   if (seg == 1) dat = peek(seg,off);
   //   if (seg == 2) dat = lpeek(seg,off);
#undef peek
   if (seg == 2) dat = peek(seg,off);
   //   if (seg == 4) dat = lpeek(seg,off);
   
   return(make_intnode((FIXNUM)dat));
   }

NODE *lpoke(NODE *arg) /*routine*/
   {
   int seg;
   int off;
   int dat;   
   
   seg = getint(pos_int_arg(arg));
   off = getint(pos_int_arg(arg=cdr(arg)));
   dat = getint(pos_int_arg(cdr(arg)));
   
   poke(seg,off,dat);
   
   return(UNBOUND);
   }
