#include "allwind.h"

TMyPrinterAreaWindow::TMyPrinterAreaWindow(PTWindowsObject AParent, LPSTR ATitle)
: TDialog(AParent, ATitle)
   {
   }

TMyPrinterAreaWindow::~TMyPrinterAreaWindow()
   {
   }

/* These next 4 routines fetch the active area dimensions */

void TMyPrinterAreaWindow::DoXLow(RTMessage Msg)
   { 
   if (TCustomFlag)
      {
      SelectedText[0] = '\0';
      SendDlgItemMsg(ID_XLOW, WM_GETTEXT, MAX_BUFFER_SIZE, (DWORD)SelectedText);
      sscanf(SelectedText,"%d",&TPrinterAreaXLow);
      }
   }

void TMyPrinterAreaWindow::DoXHigh(RTMessage Msg)
   { 
   if (TCustomFlag)
      {
      SelectedText[0] = '\0';
      SendDlgItemMsg(ID_XHIGH, WM_GETTEXT, MAX_BUFFER_SIZE, (DWORD)SelectedText);
      sscanf(SelectedText,"%d",&TPrinterAreaXHigh);
      }
   }

void TMyPrinterAreaWindow::DoYLow(RTMessage Msg)
   { 
   if (TCustomFlag)
      {
      SelectedText[0] = '\0';
      SendDlgItemMsg(ID_YLOW, WM_GETTEXT, MAX_BUFFER_SIZE, (DWORD)SelectedText);
      sscanf(SelectedText,"%d",&TPrinterAreaYLow);
      }
   }

void TMyPrinterAreaWindow::DoYHigh(RTMessage Msg)
   { 
   if (TCustomFlag)
      {
      SelectedText[0] = '\0';
      SendDlgItemMsg(ID_YHIGH, WM_GETTEXT, MAX_BUFFER_SIZE, (DWORD)SelectedText);
      sscanf(SelectedText,"%d",&TPrinterAreaYHigh);
      }
   }

void TMyPrinterAreaWindow::WMInitDialog(RTMessage Msg)
   { 
   
   /* if active area display active parameters */
   
   if (TCustomFlag)
      {
      sprintf(YABuffer,"%d",TPrinterAreaXLow);
      SendDlgItemMsg(ID_XLOW, WM_SETTEXT, 0, (DWORD)YABuffer);
      
      sprintf(YABuffer,"%d",TPrinterAreaXHigh);
      SendDlgItemMsg(ID_XHIGH, WM_SETTEXT, 0, (DWORD)YABuffer);
      
      sprintf(YABuffer,"%d",TPrinterAreaYLow);
      SendDlgItemMsg(ID_YLOW, WM_SETTEXT, 0, (DWORD)YABuffer);
      
      sprintf(YABuffer,"%d",TPrinterAreaYHigh);
      SendDlgItemMsg(ID_YHIGH, WM_SETTEXT, 0, (DWORD)YABuffer);
      
      SendDlgItemMsg(ID_CUSTOMIMAGE, BM_SETCHECK, 1, 0);
      }
   
   /* else display N/A */
   
   else
      {
      strcpy(YABuffer, "N/A");
      
      SendDlgItemMsg(ID_XLOW, WM_SETTEXT, 0, (DWORD)YABuffer);        
      SendDlgItemMsg(ID_XHIGH, WM_SETTEXT, 0, (DWORD)YABuffer);        
      SendDlgItemMsg(ID_YLOW, WM_SETTEXT, 0, (DWORD)YABuffer);        
      SendDlgItemMsg(ID_YHIGH, WM_SETTEXT, 0, (DWORD)YABuffer);
      
      SendDlgItemMsg(ID_FULLIMAGE, BM_SETCHECK, 1, 0);
      }
   
   TDialog::DefWndProc(Msg);
   }

void TMyPrinterAreaWindow::DoFullImage(RTMessage Msg)
   { 
   
   /* hack to init things */
   
   strcpy(YABuffer, "N/A");
   
   SendDlgItemMsg(ID_XLOW, WM_SETTEXT, 0, (DWORD)YABuffer);     
   SendDlgItemMsg(ID_XHIGH, WM_SETTEXT, 0, (DWORD)YABuffer);     
   SendDlgItemMsg(ID_YLOW, WM_SETTEXT, 0, (DWORD)YABuffer);     
   SendDlgItemMsg(ID_YHIGH, WM_SETTEXT, 0, (DWORD)YABuffer);
   
   TPrinterAreaXLow  = -BitMapWidth/2;
   TPrinterAreaXHigh = +BitMapWidth/2;
   TPrinterAreaYLow  = -BitMapHeight/2;
   TPrinterAreaYHigh = +BitMapHeight/2;
   
   SendDlgItemMsg(ID_FULLIMAGE, BM_SETCHECK, 1, 0);
   TCustomFlag = 0;
   
   TDialog::DefWndProc(Msg);
   }

void TMyPrinterAreaWindow::DoCustomImage(RTMessage Msg)
   { 
   
   /* if user clicks on custom display current area */
   
   sprintf(YABuffer,"%d",TPrinterAreaXLow);
   SendDlgItemMsg(ID_XLOW, WM_SETTEXT, 0, (DWORD)YABuffer);
   
   sprintf(YABuffer,"%d",TPrinterAreaXHigh);
   SendDlgItemMsg(ID_XHIGH, WM_SETTEXT, 0, (DWORD)YABuffer);
   
   sprintf(YABuffer,"%d",TPrinterAreaYLow);
   SendDlgItemMsg(ID_YLOW, WM_SETTEXT, 0, (DWORD)YABuffer);
   
   sprintf(YABuffer,"%d",TPrinterAreaYHigh);
   SendDlgItemMsg(ID_YHIGH, WM_SETTEXT, 0, (DWORD)YABuffer);
   
   SendDlgItemMsg(ID_CUSTOMIMAGE, BM_SETCHECK, 1, 0);
   TCustomFlag = 1;
   
   TDialog::DefWndProc(Msg);
   }

NODE *lsetactivearea(NODE *arg)
   {
   NODE *args;
   
   args = car(arg);
   
   // better be a list
   
   if (is_list(args))
      {
      
      // apply all args that are given
      
      if (args != NIL)
      PrinterAreaXLow = int_arg(args);
      if (cdr(args) != NIL)
      PrinterAreaYLow = int_arg(args=cdr(args));
      if (cdr(args) != NIL)
      PrinterAreaXHigh = int_arg(args=cdr(args));
      if (cdr(args) != NIL)
      PrinterAreaYHigh = int_arg(args=cdr(args));
      
      // if user specs all 0's then disable custom
      
      if (
      (PrinterAreaXLow == 0) &&
      (PrinterAreaYLow == 0) &&
      (PrinterAreaXHigh == 0) &&
      (PrinterAreaYHigh == 0)) CustomFlag = 0; else CustomFlag = 1;
      }
   
   return(UNBOUND);
   }

NODE *lactivearea(void)
   {
   NODE *targ, *val = UNBOUND;
   
   // if custom return settings
   
   if (CustomFlag)
      {
      return(
      cons(make_intnode((FIXNUM)PrinterAreaXLow),
      cons(make_intnode((FIXNUM)PrinterAreaYLow),
      cons(make_intnode((FIXNUM)PrinterAreaXHigh),
      cons(make_intnode((FIXNUM)PrinterAreaYHigh),
      NIL
      )))));
      }
   
   // else return all 0's as an indicator
   
   else
      {
      return(
      cons(make_intnode((FIXNUM)0),
      cons(make_intnode((FIXNUM)0),
      cons(make_intnode((FIXNUM)0),
      cons(make_intnode((FIXNUM)0),
      NIL
      )))));
      }
   
   }

