*--------------------------------------------------------------------------
* RFntDemo.PRG - Program to demonstrate the use of the functions
*                in the Clipper Library RFntLib
*
* Used functions :
*
*	R_DefFnt  ()  - Install default ROM font (EGA or VGA)
*	R_EGAFnt  ()  - Install one of the INTERNAL (built-in) EGA fonts
*	R_EGAName ()  - Retrieve the name of an INTERNAL (built-in) EGA font
*	R_FntFile ()  - Load an EXTERNAL EGA or VGA font from a disk file
*	R_FntName ()  - Retrieve the name of the current font
*	R_FntNr   ()  - Retrieve the number of the current font
*       R_IsEGAFl ()  - Determine if an EGA card is present
*       R_IsVGAFl ()  - Determine if an VGA card is present
*       R_MaxFnt  ()  - Determine the number of INTERNAL (built-in) fonts
*	R_VGAFnt  ()  - Install one of the INTERNAL (built-in) VGA fonts
*	R_VGAName ()  - Retrieve the name of an INTERNAL (built-in) VGA font
*
* This demo has been written for Clipper version 5.xx
*
* Compile    :	CLIPPER RFNTDEMO -N
*
* Link       :	RTLINK   file RFNTDEMO lib RFNTLIB    - or -
*		BLINKER  file RFNTDEMO lib RFNTLIB    - or -
*		EXOSPACE file RFNTDEMO lib RFNTEXO exo pack int10
*
* Syntax     :  RFNTDEMO
*--------------------------------------------------------------------------
* Date       :  02/01/94
*--------------------------------------------------------------------------
* Author     :  Ing. R.P.B. van Gelder
*               Binnenwiertzstraat 27
*               5615 HG  EINDHOVEN
*	        THE NETHERLANDS
*
* E-Mail     :  Internet: RCROLF@urc.tue.nl
*               BitNet  : RCROLF@heitue5
*--------------------------------------------------------------------------
* (c) 1994  Rolf van Gelder, All rights reserved
*--------------------------------------------------------------------------

*--------------------------------------------------------------------------
* STANDARD CLIPPER HEADER FILES
*--------------------------------------------------------------------------
#include "Inkey.ch"
#include "Directry.ch"

*--------------------------------------------------------------------------
* INCLUDE THE RFNTLIB HEADER FILE
*--------------------------------------------------------------------------
#include "RFNTLIB.CH"

*--------------------------------------------------------------------------
* CONSTANTS
*--------------------------------------------------------------------------
#define	CRLF	CHR(13)+CHR(10)

*--------------------------------------------------------------------------
* STATIC VARIABLES
*--------------------------------------------------------------------------
*-- Flag which indicates where the PC has an EGA or VGA card
STATIC	lIsVGA

*-- Initialize error text array using the header file (RFntLib.CH)
STATIC	aErrMsg := FL_ERRMSG

*--------------------------------------------------------------------------
* STATIC CODEBLOCKS
*--------------------------------------------------------------------------

*-- "Hit any key" message
STATIC	bHitKey := { || DevPos (MaxRow()-1,32), DevOut('Hit any key ....'),;
                        InKey (0) }

*-- Header line (with clear screen)
STATIC	bHeader := { || Scroll (), ;
                        DispMsg ( 0, 'RFntDemo: Demo program for ' + ;
                        'RFntLib v1.0                (C) 1994  ' + ;
                        'Rolf van Gelder', 'W+/BG' ) }

*--------------------------------------------------------------------------
*
*                          M A I N   P R O G R A M
*
*--------------------------------------------------------------------------
FUNCTION RFntDemo

*-- Array with menu choices
LOCAL	aMenu    := { ;
   'Load an INTERNAL screen font .... R_VGAFnt(), R_EGAFnt()', ;
   'Load an EXTERNAL screen font ............... R_FntFile()', ;
   'Install the DEFAULT ROM font ................ R_DefFnt()', ;
   'Display the NAME   of the current font ..... R_FntName()', ;
   'Display the NUMBER of the current font ....... R_FntNr()', ;
   'Display the current CHARACTER SET', ;
   'Symbols & Icons in the RSymbol1 & RSymbol2 fonts', ;
   'End of Demo' }

LOCAL	nChoice  := 1			&& Menu choice made

LOCAL	cOldCol				&& Screen color

LOCAL	nIntFont			&& Number of internal font
LOCAL	nFonts				&& Number of internal fonts
LOCAL	nCnt				&& Counter

LOCAL	aIntFnts := {}			&& Internal font names

LOCAL	nRetCode			&& Return code

*-- Set Color to Bright While on Blue
SetColor ( 'W+/B' )

*-- Determine if an EGA card is present
IF !R_IsEGAFl ()

   *-- No EGA nor VGA
   Alert ( 'I am sorry ... EGA adapter or better required !' )
   
   RETURN nil
   
ENDIF

*-- Determine if an VGA card is present and save it to a static var
lIsVGA := R_IsVGAFl ()

*-- Determine the number of INTERNAL (built-in) fonts
nFonts := R_MaxFnt ()

*-- Create an array containing the names of the INTERNAL fonts
FOR nCnt := 1 TO nFonts

   IF lIsVGA
      *-- Add the name of an INTERNAL VGA font
      AAdd ( aIntFnts, R_VGAName ( nCnt ) )

   ELSE
      *-- Add the name of an INTERNAL EGA font
      AAdd ( aIntFnts, R_EGAName ( nCnt ) )

   ENDIF

NEXT

*--------------------------------------------------------------------------
*                            M A I N   L O O P
*--------------------------------------------------------------------------
DO WHILE .t.

   *-- Display header lines
   Eval ( bHeader )

   *-- Display footer font name
   DispMsg ( 24, '<Current font: ' + Trim ( R_FntName () ) + '>', 'W+/BG' )

   DevPos ( 3, 31 )
   DevOut ( '-+- MAIN  MENU -+-' )

   *-- Draw box
   Scroll  ( 5, 10, 14, 69 )
   DispBox ( 5, 10, 14, 69, 1 )

   *-- Display main menu and get a choice
   nChoice := AChoice ( 6, 12, 13, 67, aMenu, , , nChoice )

   IF LastKey () = K_ESC .or. nChoice = Len ( aMenu )
      *-- Canceled
      EXIT
   ENDIF
   
   DO CASE
   CASE nChoice = 1
      *-- INTERNAL FONT

      cOldCol := SetColor ( 'W+/RB' )

      DispMsg ( 24, 'CHOOSE THE INTERNAL FONT FILE TO LOAD (Esc=Cancel)' )

      *-- Choose a font file
      DispBox ( 7, 22, 7 + R_MaxFnt () + 1, 57, 1 )

      nIntFont := AChoice ( 8, 23, 8 + R_MaxFnt() - 1, 56, aIntFnts )

      SetColor ( cOldCol )

      IF LastKey () = K_RETURN

         nRetCode := R_VGAFnt ( nIntFont )

         IF nRetCode != FL_OKAY
            *-- Display error message, using pre-defined array
            Alert ( aErrMsg [nRetCode] )
         ENDIF

      ENDIF

   CASE nChoice = 2
      *-- LOAD AN EXTERNAL FONT FROM DISK

      LoadExtFnt ()
      
   CASE nChoice = 3
      *-- INSTALL DEFAULT ROM FONT (EGA OR VGA)

      R_DefFnt ()
      
   CASE nChoice = 4
      *-- GET CURRENT FONT NAME

      Alert ( 'The NAME of the current font = ' + R_FntName () )

   CASE nChoice = 5
      *-- GET THE NUMBER OF THE CURRENT FONT

      Alert ( 'The NUMBER of the current font = ' + ;
         LTrim ( Str ( R_FntNr () ) ) )

   CASE nChoice = 6
      *-- SHOW CHARACTER SET

      ShowSet ()

   CASE nChoice = 7
      *-- SYMBOL/ICON DEMO

      SymbolDemo ()

   ENDCASE
   
ENDDO

*-- INSTALL DEFAULT ROM FONT (EGA OR VGA)
R_DefFnt ()

*-- Clear screen
Scroll ()

RETURN nil


*--------------------------------------------------------------------------
*
*                    LOAD AN EXTERNAL FONT FROM DISK
*
*--------------------------------------------------------------------------
STATIC FUNCTION LoadExtFnt

LOCAL	aDirectory := {}		&& Directory array
LOCAL	aFileList  := {}		&& File list array
LOCAL	nFiles				&& Number of font file in directory
LOCAL	nChoice				&& Choice
LOCAL	nCnt				&& Counter
LOCAL	cFntFile			&& Name of chosen font file
LOCAL	cOldCol				&& Screen color
LOCAL	nRetCode			&& Return code R_FntFile

*-- Get the complete directory to aDirectory
aDirectory := Directory ( '*.*' )

*-- Number of files in the current directory
nFiles     := Len ( aDirectory )

IF nFiles < 1

   Alert ( 'No files found in current directory ...' )

   RETURN nil

ENDIF

*-- Compose a file list
FOR nCnt := 1 TO nFiles

   *-- Select the suitable font files
   IF ( aDirectory [nCnt,F_SIZE] = FL_VGAFONTSIZE .and. lIsVGA ) .or. ;
      ( aDirectory [nCnt,F_SIZE] = FL_EGAFONTSIZE .and. !lIsVGA )

      *-- Probably a font file : Add file to directory list

      AAdd ( aFileList, PadR ( aDirectory [nCnt,F_NAME], 12 ) + ' ' + ;
         Str ( aDirectory [nCnt,F_SIZE], 7 ) )

   ENDIF
   
NEXT

*-- Number of possible font files
nFiles := Len ( aFileList )

IF nFiles < 1

   Alert ( 'No suitable font files found in current directory ...' )

   RETURN nil

ENDIF

cOldCol := SetColor ( 'W+/RB' )

DispMsg ( 24, 'CHOOSE THE EXTERNAL FONT TO LOAD (Esc=Cancel)' )

*-- Choose a font file
DispBox ( 8, 29, 20, 50 )
nChoice := AChoice ( 9,30,19,49, ASort ( aFileList ) )

SetColor ( cOldCol )

IF nChoice > 0
   *-- Choice made

   *-- Isolate the name of the choosen file
   cFntFile := Trim ( Left ( aFileList [ nChoice ], 12 ) )

   *-- Load an EXTERNAL EGA or VGA font from a disk file
   nRetCode := R_FntFile ( cFntFile )

   IF nRetCode != FL_OKAY
      *-- Display error message, using pre-defined array
      Alert ( aErrMsg [nRetCode] )
   ENDIF

ENDIF

RETURN nil


*--------------------------------------------------------------------------
*
*                     SHOW CURRENT CHARACTER SET
*
*--------------------------------------------------------------------------
STATIC FUNCTION ShowSet

LOCAL	nRow				&& Row count
LOCAL	nChar				&& Character count

Eval ( bHeader )

FOR nRow := 1 TO 8

   FOR nChar := 1 TO 32

      DevPos ( 5 + ( nRow - 1 ) * 2 , 8 + ( nChar - 1 ) * 2 )
      DevOut ( Chr ( 32 * ( nRow - 1 ) + nChar - 1 ) )

   NEXT

NEXT

*-- Hit any key ...
Eval ( bHitKey )

RETURN nil


*--------------------------------------------------------------------------
*
*           SYMBOLS & ICONS IN THE RSYMBOL1 & RSYMBOL2 FONTS
*
*--------------------------------------------------------------------------
STATIC FUNCTION SymbolDemo

*-- Install the RSymbol2 font
IF lIsVGA
   R_VGAFnt ( 2 )
ELSE
   R_EGAFnt ( 2 )
ENDIF

Eval ( bHeader )

DispMsg ( 2, ;
   FL_BigRightArr + ;
   ' SYMBOLS & ICONS IN THE RSYMBOL1 & RSYMBOL2 FONTS ' + ;
   FL_BigLeftArr )

DispMsg ( 4, FL_Copywrite + ' 1994  Rolf van Gelder, Eindhoven   ' + ;
   FL_Phone + ' +31-40-438852 ' )

DispMsg ( 6, 'This is an icon for a document or file : ' + ;
   FL_Document + ' (FL_Document)' )

DispMsg ( 8, 'This is an icon for a executable program : ' + ;
   FL_EXE + ' (FL_EXE)' )

DispMsg ( 10, 'This is an icon for a directory : ' + ;
   FL_Directory + ' (FL_Directory)' )

DispMsg ( 12, 'This is an icon for a disk drive : ' + ;
   FL_DiskDrv + ' (FL_DiskDrv)' )

DispMsg ( 14, 'This is an icon for a floppy disk : ' + ;
   FL_Floppy + ' (FL_Floppy)' )

DispMsg ( 16, 'This is a hourglass : ' + FL_Hourglass + ' (FL_Hourglass)' )

DispMsg ( 18, 'Keys : ' + FL_Return + ' ' + FL_F1 + ' ' + FL_F2 + ' ' + ;
   FL_F3 + ' ' + FL_F4 + ' ' + FL_F4 + ' ' + FL_F5 + ' ' + FL_F6 + ' ' +  ;
   FL_F7 + ' ' + FL_F8 + ' ' + FL_F9 + ' ' + FL_F10 )

DispMsg ( 20, 'Arrows : ' + FL_LeftArr1 + ' ' + FL_RightArr1 + ' ' + ;
   FL_LeftArr2 + ' ' + FL_RightArr2 )

*-- Hit any key ...
Eval ( bHitKey )

*-- Install default ROM font
R_DefFnt ()

RETURN nil


*--------------------------------------------------------------------------
*
*                    CENTER A MESSAGE ON LINE <NROW>
*
*--------------------------------------------------------------------------
STATIC FUNCTION DispMsg ( nRow, cText, cColor )

LOCAL	cCol := SetColor ( cColor )

*-- Clear line
Scroll ( nRow, 0, nRow, MaxCol () )

*-- Center text
DevPos ( nRow, ( MaxCol() - Len ( cText ) ) / 2 )
DevOut ( cText )

SetColor ( cCol )

RETURN nil
*
*: EOF: RFNTDEMO.PRG