INCLUDE EXTENDA.INC

;-------------------------------------------------------;
; Function: CURDRV                                      ;
; Author:   Grant Nesheim                               ;
; Copyright (c) 1988 Nantucket Corp.                    ;
;                                                       ;
; Purpose:  To return the letter of the currently       ;
;           selected default drive. If a DOS error      ;
;           occurs during execution, CURDRV returns     ;
;           a null string.                              ;
;-------------------------------------------------------;

CODESEG CURDRV
DATASEG

CLpublic <CURDRV>

; Initialize data storage and constants
;	DBUFF = one character string to store the drive
;		letter or zero in.
;	DRIVE = address of DBUFF.

CLstatic <string DBUFF " ", cptr DRIVE DBUFF> 

CLfunc char CURDRV
CLcode

     ; Call DOS interrupt 21h function number 19h to
     ; get the current drive number.  On exit of the 
     ; interrupt al contains the number 0-25 and the
     ; carry flag will be set if an error occurs or
     ; cleared if no errors.

     DOSREQ  19h
     JNC     NOERR
	
     ; The carry flag was set.  Move a zero, null,
     ; into the return string.
	 
     MOV  DBUFF, 0
     JMP  CDRET

NOERR:
     ; Add 65 to the al register to get a drive letter
     ; and move it into the return string.
	
     ADD	al,65
     MOV	DBUFF, al

CDRET:
     ; Return the result string
	
     CLret DRIVE  

          END

