* CLIPMEM.PRG
* 
* Date:   February 1987
* Author: David Morgan
* Notes:  Simulates Clipper Autumn '86 memory allocation
*          groundrules explained in Nantucket News, Autumn
*          1986, p. 4.
*         Requires DOS 3.x or greater for assembly routines
* 
* Input:  configuration information about machine environment
*          as follows --
*
*         tot_conv = amount of conventional memory installed (K)
*         tot_exp  = amount of expanded memory installed
*         dos_size = size of DOS as loaded at runtime
*         load_module = size of your application's load module
*         CLIPPER  = copy of the runtime CLIPPER environment
*                    string
*
* Output: memory allocation/distribution information as follows
*
*         X         = amt of mem excluded
*         mem_vars  = amt of mem devoted to storing memvars
*         run_space = amt of mem for RUNning/perhaps indexing
*         pool      = amt of memory devoted to free pool
*         exp_space = amt of expanded mem. devoted to indexing
*                     if zero, indexing shares run_space
*                     otherwise run_space is for exclusive use
*                     by RUN commands
*

PARAMETERS tot_conv,tot_exp,dos_size,load_module
param_count = PCOUNT()
CLEAR
CLIPPER=UPPER(GETE('CLIPPER')+' ')
numerals = '1234567890'
params = 'VREX'
error = .F.
DO CASE
 CASE param_count=0	&& get parameters from this machine
  tot_conv = MEM_AMT()  
  tot_conv = 16 * iif(tot_conv<0,65536+tot_conv,tot_conv) / 1024
  tot_conv = (INT(tot_conv+.5))
  tot_exp = 16*EM_AMT()
  dos_size = 16*DOS_SIZ()/1024
  dos_size = (INT(dos_size+.5))
  load_module = 0
  @ 6,0
  TEXT
  CLIPMEM will read remaining memory configuration parameters
   from this machine.


  Alternative calling syntax you may use to specify parameters
   yourself, reflecting any machine:

  CLIPMEM tot_conv tot_exp dos_size load_module
  ENDTEXT
  @ 4,0 SAY 'What is the load module size? ' GET load_module;
   RANGE 100,600
  READ
 CASE param_count=4	&& take parameters from command line
  tot_conv=VAL(tot_conv)
  tot_exp=VAL(tot_exp)
  dos_size=VAL(dos_size)
  load_module =VAL(load_module)
 OTHERWISE
  DO TERMINATE
ENDCASE

* range checking
DO CASE
 CASE tot_conv<256 .OR. tot_conv>640
  error = .T.
 CASE tot_exp<0 .OR. tot_exp>8192
  error = .T.
 CASE dos_size<20 .OR. dos_size>200
  error = .T.
 CASE load_module<100 .OR. load_module>600
  error = .T.
ENDCASE
IF error
 DO TERMINATE
ENDIF

* analyze CLIPPER string
p2 = 1
DO WHILE p2 <= 4
 curr_par = SUBSTR(params, p2, 1)
 error = .F.
 IF AT('&curr_par',CLIPPER)>0
  p1 = AT('&curr_par',CLIPPER)+1
  no_chars = 0
  DO WHILE SUBSTR(CLIPPER,P1,1)$numerals
   no_chars = no_chars + 1
   p1 = p1 + 1
  ENDDO
  error = IIF(no_chars=0, .T., .F.)
  IF .NOT.error
   &curr_par = VAL(SUBSTR(CLIPPER,p1-no_chars,no_chars))
  ELSE
   CLEAR
   ? 'Error in CLIPPER string format. Calculation canceled.'
   CANCEL
  ENDIF
 ELSE
  &curr_par=0
 ENDIF
 p2 = p2 + 1
ENDDO :p2<=4

* follow the groundrules to calculate each memory category
left_over = tot_conv - dos_size - load_module
excluded = X
left_over = left_over - excluded
pool=24
left_over = left_over - pool
mem_vars = IIF(V>0,V,IIF( .2*left_over > 44 , 44, .2*left_over))
left_over = left_over - mem_vars
run_space = IIF(R > 0 ,  R, left_over/3 )
run_space = IIF(tot_exp=0.AND.run_space < 16, 16, run_space)
left_over = left_over - run_space
pool = pool + left_over

IF AT('E',CLIPPER) > 0			   && 'E' param present
 IF E=0
  exp_space = 0
 ELSE
  exp_space = E			           && E specified, but
* can't exceed 1MB:
  exp_space = IIF(exp_space>1024, 1024, exp_space)
* or EMM total:
  exp_space = IIF(exp_space>tot_exp, tot_exp, exp_space)
* need 16K at least:
  exp_space = IIF(exp_space<16, 0, exp_space)
 ENDIF
ELSE					        && no 'E' param
 exp_space = IIF(tot_exp>1024, 1024, tot_exp)   && gets all EMM
 exp_space = IIF(exp_space<16, 0, exp_space)    && up to 1MB
ENDIF

IF mem_vars<=0.OR.pool<=0
 DO TERMINATE
ENDIF
* print results
CLEAR
? "Approximate Memory Distribution for Clipper Autumn '86"
?
? 'Configuration:'
? ' Installed conventional memory:  '+STR(tot_conv)
? ' Installed expanded memory:      '+STR(tot_exp)
? ' DOS memory consumption:         '+STR(dos_size)
? ' Application memory consumption: '+STR(load_module)
? ' CLIPPER environment string:     '
IF ' '=CLIPPER
 ?? 'NONE'
ELSE
 ?? CLIPPER
ENDIF
?
? 'Conventional Memory:'
? SUBSTR(' DOS'+SPACE(20),1,20)+STR(dos_size)
? SUBSTR(' Application module'+SPACE(20),1,20)+STR(load_module)
? SUBSTR(' Excluded'+SPACE(20),1,20)+STR(X)
? SUBSTR(' Memory variables'+SPACE(20),1,20);
   +STR(INT(mem_vars+.5))
IF exp_space > 0
 ? SUBSTR(' RUN'+SPACE(20),1,20)+STR(INT(run_space+.5))
ELSE
 ? SUBSTR(' RUN+Indexing'+SPACE(20),1,20)+STR(INT(run_space+.5))
ENDIF
? SUBSTR(' Free pool'+SPACE(20),1,20)+STR(INT(pool+.5))
?
? 'Expanded Memory:'
? SUBSTR(' Indexing'+SPACE(20),1,20)+STR(exp_space)
?
? '>>> All values approximate <<<'
@ 22,0
QUIT


PROCEDURE TERMINATE
CLEAR
?? CHR(7)
TEXT
 Error occurred.  Calling syntax is either:

   CLIPMEM tot_conv tot_exp dos_size load_module    (no commas)

                    or
   CLIPMEM

You must supply either 4 or 0 command line parameters. If you do not
supply them they are read internally from the current machine or 
you are prompted for them. The current CLIPPER string is read from memory.
Requires DOS 3.x or greater. Calculated values must be positive.

Significance of parameters:                              Allowed Range

tot_conv = amount of conventional memory installed (K)     256 -  640
tot_exp  = amount of expanded memory installed               0 - 8192
dos_size = size of DOS as loaded at runtime                 20 -  200
load_module = size of your application's load module       100 -  600
CLIPPER  = copy of the runtime CLIPPER environment string
ENDTEXT
@ 22,0
QUIT
RETURN
