	Title	"SEND text"  Copyright (C) 1985 Howard Rumsey 72426,3722 and Barry Simon
	page	132,66

Comment *
	SEND acts like a combination of ECHO and PROMPT.  ECHO can be used
	to transmit messages to arbitrary files or devices.  It has several
	disadvantages.  You can't ECHO an escape (ESC) so you can't transmit
	ANSI control sequences to your screen.  ECHO also insists on sending
	a CarriageReturn LineFeed sequence at the end of it's transmission.
	The PROMPT command (DOS2.0 or higher) suffers from none of these 
	defects but it's output can not be redirected.  Also, PROMPT is 
	disabled when "ECHO is off".  SEND combines the best features of both.
	For example the command:
	                 send $e[[J$d$_$t
	clears the screen (if you have installed ANSI.SYS), displays the date
	on one line and the time om the next.

	  SEND has one additional feature.  It allows you to send arbitrary
	control characters.  The standard "^" notation is used.  The line
	                 send ^g^[[J
	will ring the bell (^g and ^G are the ASCII BELL) and clear 
	the screen (^[ is ASCII ESC).  The ^ and $ may be freely mixed in
	the command line.  As usual $ can be used to "escape" itself and ^.
	Thus $$ and $^ simply become $ and ^ with no special meaning.
*


CR	equ	0dh
LF	equ	0ah
BS	equ	08h
ESC	equ	1bh
TAB	equ	09h

cseg	segment
	assume	cs:cseg, ds:cseg

	org	100h
start:	jmp	send

days	db	'Sun',0,'Mon',0,'Tue',0,'Wed',0,'Thu',0,'Fri',0,'Sat',0
d10	dw	10
d100	dw	100

send:
	mov	di,81h		; start of command line
	mov	bl,[di-1]	; number of characters on command line
	mov	bh,0
	mov	byte ptr [bx+81h],0	; 0 byte indicates end of line
					; this over rides the DOS 'CR'

skipspace:			; skip leading "white spaces"
	call	gch
	jz	exit1
	cmp	al,' '
	jz	skipspace
	cmp	al,TAB
	jz	skipspace
	jmp	s0

exit1:	int	20h		; exit on EOF

send1:
	call	gch
	jz	exit1
s0:
	cmp	al,'^'
	jnz	s2
	call	gch
	jnz	s1
	mov	al,'^'		; send hanging '^'
done:	call    pch
	int	20h
s1:
	and	al,1fh		; keep the five low order bits
s3:	call	pch
	jmp	send1
s2:
	cmp	al,'$'
	jnz	s3
	call	dodollar
	jmp	send1

dodollar:
	call	gch
	jnz	s4
	mov	al,'$'		; send hanging '$' and exit
	jmp	done

s4:
	cmp	al,'t'
	jnz	t0
	mov	ah,2ch		; Time
	int	21h
	mov	al,ch
	call	p2
	mov	al,':'
	call	pch
	mov	al,cl
	call	p02
	mov	al,':'
	call	pch
	mov	al,dh
	call	p02
	mov	al,'.'
	call	pch
	mov	al,dl
	call	p02
	ret
t0:
	cmp	al,'d'
	jnz	d0
	mov	ah,2ah		; Date
	int	21h
	mov	ah,0
	mov	si,offset days
	add	ax,ax
	add	ax,ax
	add	si,ax		; days[4*day]
	call	pstr
	mov	al,' '
	call	pch
	mov	al,dh
	call	p2
	mov	al,'-'
	call	pch
	mov	al,dl
	call	p02
	mov	al,'-'
	call	pch
	mov	ax,cx
	call	ppnum
	ret
d0:
	cmp	al,'p'
	jnz	p0
	call	path		; Path
	ret
p0:
	cmp	al,'P'
	jnz	pp0
	call	path		; $P avoids "paths" like C:\\
	cmp	al,0
	jz	pp1
	mov	al,'\'
	call	pch
pp1:	ret
pp0:
	cmp	al,'v'
	jnz	v0
	mov	ah,30h		; "Version"
	int	21h
	push	ax
	mov	ah,0
	call	ppnum
	mov	al,'.'
	call	pch
	pop	ax
	mov	al,ah
	mov	ah,0
	call	ppnum
	ret
v0:
	cmp	al,'n'
	jnz	n0		
	call	drive		; Drive
	ret
n0:
	cmp	al,'g'
	jnz	g0
	mov	al,'>'
	call	pch
	ret
g0:
	cmp	al,'l'
	jnz	l0
	mov	al,'<'
	call	pch
	ret
l0:
	cmp	al,'b'
	jnz	b0
	mov	al,'|'
	call	pch
	ret
b0:
	cmp	al,'q'
	jnz	q0
	mov	al,'='
	call	pch
	ret
q0:
	cmp	al,'h'
	jnz	h0
	mov	al,BS
	call	pch
	ret
h0:
	cmp	al,'e'
	jnz	e0
	mov	al,ESC
	call	pch
	ret
e0:
	cmp	al,'_'
	jnz	_0
	mov	al,CR
	call	pch
	mov	al,LF
	call	pch
	ret
_0:
	cmp	al,'M'
	jnz	M00
	mov	ah,2ah		; Date
	int	21h
	mov	al,dh		; print two digit month as 'mm'
	call	p02
	ret
M00:
	cmp	al,'D'
	jnz	D00
	mov	ah,2ah		; Date
	int	21h
	mov	al,dl		; print two digit day as 'dd'
	call	p02
	ret
D00:
	cmp	al,'Y'
	jnz	Y00
	mov	ah,2ah		; Date
	int	21h
	mov	ax,cx		; print year as 'yy'
	mov	dx,0
	div	d100
	mov	ax,dx		; remainder
	call	p02
	ret
Y00:
	cmp	al,'T'
	jnz	T00
	mov	ah,2ch		; Time
	int	21h
	mov	al,ch		; print time as 'hhmm'
	call	p02
	mov	al,cl
	call	p02
	ret
T00:
	call	pch		; default is send char
	ret

path:
	call	drive
	mov	al,':'
	call	pch
	mov	al,'\'
	call	pch
	mov	ah,47h		; Path
	mov	dl,0		; default drive
	sub	sp,65		; room for path name
	mov	si,sp
	int	21h
	call	pstr
	mov	al,[si]
	add	sp,65
	ret

drive:
	mov	ah,19h		; default drive
	int	21h
	add	al,'A'		; A=0, B=1,...
	call	pch
	ret

gch:
	mov	al,[di]
	or	al,al
	jz	gch1
 	inc	di
gch1:	ret

pch:
	push	ax
	push	dx
	mov	dl,al
	mov	ah,02h
	int	21h
	pop	dx
	pop	ax
	ret

pstr:
	push	si
pstr1:	mov	al,[si]
	cmp	al,0
	jz	pstr2
	call	pch
	inc	si
	jmp	pstr1
pstr2:	pop	si
	ret

ppnum:				; print unsigned number
	cmp	ax,0
	jnz	pn0
	call	pdigit
	ret
pn0:
	cmp	ax,d10
	jae	pn1

pdigit:
	push	ax
	add	al,'0'
	call	pch
	pop	ax
	ret			
pn1:
	push	dx
	mov	dx,0
	div	d10
	push	dx		;remainder
	call	pn0
	pop	ax
	call	pdigit
	pop	dx
	ret

p02:				; %02d
	mov	bl,'0'
	jmp	p022		; %2d
p2:
	mov	bl,' '
p022:
	mov	ah,0
	div	byte ptr d10
	cmp	al,0
	jg	p21
	mov	al,bl
	call	pch
	jmp	p22
p21:	call	pdigit
p22:	mov	al,ah
	call	pdigit
	ret

cseg	ends
	end	start
