PROGRAM Triangles;
{Demo illustrating the *FAST* FillTriangle procedure}

USES
  VGATools, VGABasic, Crt;

VAR
  x1, y1, x2, y2, x3, y3 : Word;

BEGIN
  IF NOT VGAFound THEN BEGIN {Check for VGA}
    WriteLn ('This program requires a VGA board !');
    Exit;
  END;

  Randomize;
  IF NOT InitSVGA640x400 (vmAutoDetect) THEN BEGIN {Init SVGA}
    InitGraphics;                   {If SVGA fails, init 320x560}
    SetYResolution (Mode560);
  ENd;

  REPEAT
    x1 := Random (MaxX+1);    {Get some random points}
    y1 := Random (MaxY+1);
    x2 := Random (MaxX+1);
    y2 := Random (MaxY+1);
    x3 := Random (MaxX+1);
    y3 := Random (MaxY+1);
    CurColor := Random (256); {and a random color}

    FillTriangle (x1, y1, x2, y2, x3, y3); {draw a triangle}

    CurColor := 15;        {draw a white edge}
    Line (x1, y1, x2, y2);
    Line (x1, y1, x3, y3);
    Line (x2, y2, x3, y3);

    Delay (100);           {wait a bit}
  UNTIL KeyPressed;
  ReadKey;
  DoneGraphics;
END.