PROGRAM SVGAUserMode;

USES
  VGATools, VGABasic, VGAColors, Timer, Crt;

FUNCTION ITOA (V : Word) : STRING;

VAR Temp : STRING;

BEGIN
  Str (V, Temp);
  ITOA := Temp;
END;


VAR
  Pal : vgapalette;
  I : Byte;

BEGIN
  Randomize;

  IF NOT VGAFound THEN BEGIN  {Check for VGA}
    WriteLn ('This program requires a register-compatible VGA board !');
    Halt (1);
  END;

  {Check for 512k}
  Write ('Does your VGA board have 512k or more (Y/N)? ');
  VGAHas512k := UpCase (ReadKey) = 'Y';

  IF InitSvga640x400 (vmAutoDetect) THEN BEGIN {Init SVGA}
    Pal [0][RGBRed]   := 0;     {Make border blue and color 1 black}
    Pal [0][RGBGreen] := 0;
    Pal [0][RGBBlue]  := 63;
    Pal [1][RGBRed]   := 0;
    Pal [1][RGBGreen] := 0;
    Pal [1][RGBBlue]  := 0;

    SetPalette (Pal, 0, 1);

    SetWriteMask ($F);          {Fill screen with color 1}
    FillChar (Mem[$A000:1], 65535, 1);
    Mem[$A000:0] := 1;

    InitTimer;
    WHILE NOT KeyPressed DO BEGIN
      TimerTicks := 0;

      {Set a random mode}
      SetUserMode (Random (640-556+1)+556, Random (400-10+1)+10);

      {And display its characteristics}
      FOR I := 0 TO MaxY DIV 8 DO BEGIN
        PrintStr (0, I*8, 'This is mode '+ITOA(MaxX+1)+'x'+ITOA(MaxY+1)+
        ' with '+ITOA (MaxPage+1)+' page(s), text line '+ITOA (I)+'.  ', 15, 1);
      END;

      {Let screen sort itself out}
      VSync;

      {Wait a bit}
      REPEAT UNTIL TimerTicks > 1000;
    END;
    DoneTimer;
    ReadKey;
    DoneGraphics;

  END ELSE BEGIN

    WriteLn ('Sorry, no SVGA support for this board.');
  END;
END.
