PROGRAM SVGAPages;
{Demo illustrating the two-page SuperVGA mode}

USES
  VGATools, VGAGlobals, VGAColors, VGABasic, VGATload, Crt;

VAR
  Pal : VGAPalette;
  I : Word;

BEGIN
  IF NOT VGAFound THEN BEGIN
    WriteLn ('This program requires a VGA-board !');
    Exit;
  END;
  WriteLn ('THIS PROGRAM DEMONSTRATES VGATOOLS'' 2-PAGE 640x400x256 SVGA MODE');
  WriteLn (' A REGISTER-COMPATIBLE VGA-BOARD WITH AT LEAST 512k IS REQUIRED ');
  WriteLn ('  PRESS Y TO CONTINUE THIS PROGRAM OR ANY OTHER KEY TO CANCEL.  ');
  IF UpCase (ReadKey) = 'Y' THEN BEGIN
    VGAHas512k := True;
    IF InitSVGA640x400 (vmAutoDetect)
     AND (LoadGif ('SVGAPAGE.GIF', 600, Pal) = 0) THEN BEGIN
      SetActivePage (1);
      SetPaletteNoNOise (Pal, 0, 255);
      PrintStr (8*8, 0,' This is a demo for two-page SuperVGA 640x400x256 graphics mode. ', 160, 96);
      FOR I := 0 TO 255 DO BEGIN
        CurColor := I;
        Bar ((I MOD 32)*20, (I DIV 32)*20+20, (I MOD 32)*20+15, (I DIV 32)*20+35);
      END;
      CopyPage (1, 0);
      SetActivePage (0);
      PrintStr (200, 340, '¿ Ŀ Ŀ ĿĿĿ Ŀ', 191, 127);
      PrintStr (200, 348, '  ĴĿ Ŀ ĴĿ  ', 191, 127);
      PrintStr (200, 356, '         ', 191, 127);
      SetActivePage (1);
      PrintStr (200, 340, '¿ Ŀ Ŀ ĿĿĿ   ', 128, 127);
      PrintStr (200, 348, '  ĴĿ Ŀ ĴĿ   ', 128, 127);
      PrintStr (200, 356, '           ', 128, 127);
      REPEAT
        ChangePage (CurPage XOR 1);
        Delay (500);
      UNTIL KeyPressed;
      ReadKey;
      DoneGraphics;
    END;
  END;
END.
