PROGRAM TestMouse;

USES
  VGATools, VGAColors, VGAMouse, VGABasic, Crt;

VAR
  Pal : VGAPalette;
  X, Y, LastX, LastY: Integer;
  Buttons, LastButtons : Byte;


BEGIN
  IF NOT MouseFound THEN BEGIN
    WriteLn ('Mouse not present !!!');
    Exit;
  END;
  IF NOT VGAFound THEN BEGIN
    WriteLn ('This program raquires a VGA card !!!');
    Exit;
  END;

  InitGraphics;

  SetUserMode (320, 400);                  {get into high resolution}
  SetMouseSensitivity (4096,4096);         {make the mouse less sensitive}

  GetPalette (Pal, 0, 255);
  MouseColor := FindColor (Pal, 63,63,63); {White mouse cursor}
  CurColor := FindColor (Pal, 0,0,63);     {Draw in blue}

  LastButtons := 0;

  MouseOn;
  WHILE NOT KeyPressed DO BEGIN
    GetMousePosition (X, Y);
    Buttons := MouseButtons;

    {Was left button pressed ?  ->  copy to undo screen}
    IF ((LastButtons AND mbLeftButton) = 0) AND ((Buttons AND mbLeftButton) <> 0) THEN BEGIN
      MouseOff;
      CopyPage (0, 1);
      MouseOn;
    END;

    {holding down left button and moving -> draw}
    IF ((Buttons AND LastButtons) AND mbLeftButton) <> 0 THEN BEGIN
      MouseOff;
      Line (LastX, LastY, X, Y);
      MouseOn;
    END;

    {Pressing right button -> undo}
    IF ((Buttons AND mbRightButton) <> 0) AND ((LastButtons AND mbRightButton) = 0) THEN BEGIN
      MouseOff;
      CopyPage (1, 0);
      MouseOn;
    END;

    LastButtons := Buttons;
    LastX := X;
    LastY := Y;
  END;
  MouseOff;
  DoneGraphics;
END.