PROGRAM UserMode;
{This program demonstrates the 'user modes' in VGATools.}

USES
  VGATools, VGAColors, VGABasic, Crt;

FUNCTION ITOA (V : Word) : STRING;

VAR Temp : STRING;

BEGIN
  Str (V, Temp);
  ITOA := Temp;
END;


CONST
  TestModes : ARRAY[1..11] OF Word =
   (60, 90, 120, 175, 180, 240, 300, 350, 360, 450, 560);


VAR
  Pal : VGAPalette;
  I : Word;
  J : Word;

BEGIN
  IF NOT VGAFound THEN BEGIN
    WriteLn ('This program requires a VGA-board');
    Exit;
  END;
  InitGraphics;

  {Make the border Blue}
  Pal[0][RGBBlue] := 63;
  SetPalette (Pal, 0, 0);

  FOR I := 1 TO 11 DO BEGIN
    {Fill entire screen with color 16 (= black)}
    SetWriteMask ($F);
    Mem[$A000:0] := 16;
    FillChar (Mem[$A000:1], 65535, 16);

    FOR J := 240 DIV 8 TO 320 DIV 8 DO BEGIN
      VSync;
      SetUserMode (J*8, TestModes[I]);
      PrintStr (0, (MaxY-7) DIV 2, 'THIS IS MODE '+ITOA(MaxX+1)+'x'+ITOA(MaxY+1)+'.', 15, 1);
      Delay(50);
    END;
    Delay (500);
    FOR J := 320 DIV 8 DOWNTO 240 DIV 8 DO BEGIN
      VSync;
      SetUserMode (J*8, TestModes[I]);
      PrintStr (0, (MaxY-7) DIV 2, 'THIS IS MODE '+ITOA(MaxX+1)+'x'+ITOA(MaxY+1)+'.', 15, 1);
      Delay(50);
    END;
  END;
  DoneGraphics;
END.