PROGRAM Splines;
{Demonstrates the use of DrawSpline}
{Demonstrates the use of the Timer unit for system-independent timing.}

USES
  VGATools, VGABasic, Crt, Timer;


VAR
  ASpline : ARRAY [1..20] OF RECORD
              X, Y : Word;
            END;
  Points : Byte;
  I : Byte;

  Count : LongInt;

BEGIN
  IF NOT VGAFound THEN BEGIN {Check for VGA}
    WriteLn ('This program requires a VGA board !');
    Exit;
  END;

  Randomize;
  IF NOT InitSVGA640x400 (vmAutoDetect) THEN BEGIN
    InitGraphics;
    SetYResolution (Mode400);
  END;

  Count := 0;
  TimerTicks := 0;
  REPEAT
    ClrCurPage;

    Points := Random (18)+2;            {Get some random points}
    FOR I := 1 TO Points DO BEGIN
      ASpline [I].X := Random (MaxX+1-30)+15;
      ASpline [I].Y := Random (MaxY+1-30)+15;
    END;

    CurColor := 9;

    InitTimer;
    DrawSpline (Points, ASpline, Boolean(Random (2))); {and draw the spline}
    DoneTimer;

    Inc (Count);

    CurColor := 15;
    FOR I := 1 TO Points DO BEGIN
      HLine (ASpline[I].X-2, ASpline[I].Y, ASpline[I].X+2);
      VLine (ASpline[I].X, ASpline[I].Y-2, ASpline[I].Y+2);
    END;

    Delay (200);           {wait a bit}
  UNTIL KeyPressed;
  ReadKey;
  DoneGraphics;
  WriteLn ('Average time : ', TimerTicks / Count :0:2, ' ms/spline.');
  ReadKey;
END.

END.