PROGRAM ScrMode;
{Demo illustrating the different screen modes, smooth scrolling and}
{palette control.}

USES
  Crt, VGATools, VGABasic, VGAGlobals, VGAColors;

CONST
  Steps = 15;

PROCEDURE DoDemo;

VAR
  I : Word;
  X, Y : Word;
  Pal : VGAPalette;

BEGIN
  {Draw a demo piccy}
  FOR Y := 0 TO MaxY DO BEGIN
    CurColor := 255-Round (Y / (MaxY+1) * 256);
      {Get a color}
    Line (0,Y,MaxX,MaxY-Y);
      {Draw a line}
  END;
  FOR X := 0 TO MaXX DO BEGIN
    CurColor := Round (X / (MaXX+1) * 256);
      {Get a color}
    Line (X,0,MaxX-X,MaxY);
      {Draw a line}
  END;

  {Get the palette}
  GetPalette (Pal, 0, 255);

  {Animate the palette}
  FOR I := 1 TO 64 DO BEGIN
    FOR X := 1 TO 8 DO SlidePalette (Pal, 0, 255, SlideRight);
    SetPaletteNoNoise (Pal, 0, 255);
  END;

  WHILE CurPage < MaxPage DO BEGIN
    {Copy the piccy}
    CopyPage (CurPage, CurPage+1);

    {And scroll to the next page}
    FOR I := 0 TO Steps DO BEGIN
      SetOrigin (CurPage * PageSize + (I * (MaxY+1) DIV Steps) * ((MaxX+1) DIV 4), 0);
    END;

    {Notify VGATools of the change}
    ChangePage (CurPage+1);

    {Animate the palette}
    FOR I := 1 TO 64 DO BEGIN
      FOR X := 1 TO 8 DO SlidePalette (Pal, 0, 255, SlideRight);
      SetPaletteNoNoise (Pal, 0, 255);
    END;
  END;

  {Back to the start...}
  ChangePage (0);
END;


VAR
  R : Resolution;

BEGIN
  IF NOT VGAFound THEN BEGIN
    WriteLn ('This program requires a VGA-board !');
    Exit;
  END;
  Write ('Do you have a VGA-board with at least 512k memory (Y/N) ? ');
  VGAHas512k := UpCase (ReadKey) = 'Y';
  InitGraphics;
  FOR R := Mode100 TO Mode560 DO BEGIN
    SetYResolution (R);
    DoDemo;
  END;
  IF InitSVGA640x400 (vmAutoDetect) THEN DoDemo;
  DoneGraphics;
END.