PROGRAM FloodFillTest;

USES
  VGATools, VGABasic, Crt;

VAR
  I : LongInt;

BEGIN
  IF NOT VGAFound THEN BEGIN
    WriteLn ('This program requires a register-compatible VGA-board !');
    Halt (1);
  END;

  IF NOT InitSVGA640x400 (vmAutoDetect) THEN BEGIN
    InitGraphics;
    SetYResolution (Mode480);
  END;

  Randomize;
  REPEAT
    ClrCurPage;

    {Draw some random lines}
    CurColor := LightGreen;
    FOR I := 1 TO 10 DO Line (Random (MaxX+1), Random (MaxY+1),
                              Random (MaxX+1), Random (MaxY+1));
    {And random pixels}
    FOR I := 1 TO LongInt (MaxX)*MaxY DIV 20 DO
      PutPixel (Random (MaxX+1), Random (MaxY+1), LightGreen);

    {Random FloodFill}
    CurColor := LightRed;
    FloodFill (Random (MaxX+1), Random (MaxY+1));

  UNTIL Readkey = #27;

  DoneGraphics;
END.