PROGRAM Polygons;

USES
  VGATools, VGABasic, Crt;


VAR
  APoly : ARRAY [1..10] OF RECORD
            X, Y : Word;
          END;
  Points : Byte;
  I : Byte;

BEGIN
  IF NOT VGAFound THEN BEGIN {Check for VGA}
    WriteLn ('This program requires a VGA board !');
    Exit;
  END;

  Randomize;
  InitGraphics;
  SetYResolution (Mode400);

  REPEAT
    Points := Random (8)+3;            {Get some random points}
    FOR I := 1 TO Points DO BEGIN
      APoly [I].X := Random (MaxX+1);
      APoly [I].Y := Random (MaxY+1);
    END;
    CurColor := Random (256);           {and a random color}

    FillPoly (Points, APoly);           {draw the poly}

    CurColor := 15;        {draw a white edge}
    FOR I := 1 TO Points-1 DO BEGIN
      Line (APoly[I].X, APoly[I].Y, APoly[I+1].X, APoly[I+1].Y);
    END;
    Line (Apoly [1].X, APoly[1].Y, APoly[Points].X, APoly[Points].Y);

    Delay (100);           {wait a bit}
  UNTIL KeyPressed;
  ReadKey;
  DoneGraphics;
END.
