PROGRAM FindDemo;
{Demo illustrating the use of FindColor for }
  { (1) anti-alias scaling method like Autodesk Animator Pro's SHRINK x2 }
  { (2) 'blue'-scaling }

{FINDDEMO.GIF was taken from King Quest VI (C) Sierra On-Line}

USES
  VGATools, VGATLoad, VGAColors, VGABasic, Crt, Timer;

VAR
 Pal : VGAPalette;
 PalBlue : VGAPalette;

 I : Byte;
 X, Y : Word;
 Temp : ARRAY[0..3] OF Byte;
 R, G, B : byte;


BEGIN
  IF NOT VGAFound THEN BEGIN
    WriteLn ('This program requires a VGA board.');
    Exit;
  END;

  InitGraphics;

  {Fade to black}
  FadeOut(0);

  {Load our picture}
  IF LoadGIF('FINDDEMO.GIF', 0, Pal) = imOK THEN BEGIN
    {and set its palette}
    SetPaletteNoNoise (Pal, 0, 255);

    {Scaling}
    FOR X := 0 TO 159 DO BEGIN
      FOR Y := 0 TO 50 DO BEGIN
        {Get the four pixels to be represented by one}
        Temp[0] := GetPixel (X*2, Y*2);
        Temp[1] := GetPixel (X*2+1, Y*2);
        Temp[2] := GetPixel (X*2, Y*2+1);
        Temp[3] := GetPixel (X*2+1, Y*2+1);

        {Calculate the sum of their RGB values}
        R := 0; B := 0; G := 0;
        FOR I := 0 TO 3 DO BEGIN
          R := R + Pal[Temp[I]][RGBRed];
          G := G + Pal[Temp[I]][RGBGreen];
          B := B + Pal[Temp[I]][RGBBlue];
        END;

        {Average this sum}
        R := R DIV 4;
        G := G DIV 4;
        B := B DIV 4;

        {Put nearest color on screen}
        PutPixel (X, Y+125, FindColor (Pal, R, G, B));

        {Put one pixel on screen}
        PutPixel (X+160, Y+125, Temp[0]);
      END;
    END;

    {Display some text}
    PrintStr (96, 105, 'ORIGINAL PICTURE', FindColor (Pal, 63, 63, 63), 0);
    PrintStr (0, 180, 'WITH FINDCOLOR', FindColor (Pal, 63, 63, 63), 0);
    PrintStr (160, 180, 'WITHOUT FINDCOLOR', FindColor (Pal, 63, 63, 63), 0);
    ReadKey;


    {Create a Blue-scale palette}
    FOR I := 0 TO 255 DO BEGIN
      PalBlue [I][RGBRed] := 0;
      PalBlue [I][RGBGreen] := 0;
      PalBlue [I][RGBBlue] := I SHR 2;
    END;

    {Change each color in Pal to it's nearest Blue equivalent}
    FOR I := 0 TO 255 DO BEGIN
      R := FindColor (PalBlue, Pal[I][RGBRed], Pal[I][RGBGreen], Pal[I][RGBBlue]);
      Pal [I] := PalBlue [R];
    END;
    FadeToPalette (Pal, 0, 255, 1000);
    ReadKey;
  END;

  DoneGraphics;

  WriteLn ('King''s Quest VI (C) Sierra On-Line, Inc.');
END.