PROGRAM BGIFloodFill;
{This program demonstrates Pascal's own FloodFill procedure.}
{It illustrates the errors made by the BGI when there are a lot of single}
{pixels on the screen.}

USES
  Crt, Graph;

FUNCTION DetectRout : Integer; FAR;

BEGIN
  DetectRout := 1;
END;


VAR
  I : LongInt;
  VD, VM : Integer;

BEGIN
  WriteLn ('This program requires a VESA-compatible VGA board. Some boards');
  WriteLn ('require a TSR to be loaded in order to be VESA-compatible. If');
  WriteLn ('your VESA driver is not loaded, press ESC to exit this program.');
  IF ReadKey = #27 THEN Exit;

  VD := InstallUserDriver ('SVGA256', @DetectRout);
  VM := 1;
  InitGraph (VD, VM, '');

  Randomize;
  REPEAT
    ClearDevice;
    {Draw some random lines}
    SetColor (LightGreen);
    FOR I := 1 TO 10 DO Line (Random (GetMaxX+1), Random (GetMaxY+1),
                              Random (GetMaxX+1), Random (GetMaxY+1));
    {And random pixels}
    FOR I := 1 TO LongInt (GetMaxX)*GetMaxY DIV 20 DO
      PutPixel (Random (GetMaxX+1), Random (GetMaxY+1), LightGreen);

    {Random FloodFill}
    SetFillStyle (SolidFill, LightRed);
    FloodFill (Random (GetMaxX+1), Random (GetMaxY+1), LightGreen);
  UNTIL ReadKey = #27;

  CloseGraph;
END.