/*
 this file was changed or created for the DOS32 library for DJGPP on 21.9.1996
 new created files are copyright 1996 by C.Lageman, see docs.doc for details
*/
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
#include <libc/stubs.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <dos32api.h>
#include <libc/dosio.h>

char *
getcwd(char *buf, size_t size)
{
  char *bp;
  _dos32_regs r;

  if (!size)
  {
    errno = EINVAL;
    return 0;
  }
  if (!buf)
  {
    buf = (char *)malloc(size);
    if (!buf)
    {
      errno = ENOMEM;
      return 0;
    }
  }

  /* make sure we don't overrun the TB */
  if (size > 0x2000U)
    size = 0x2000U;

  /* get the path into the transfer buffer at least */
  if(_USE_LFN)
  {
    r.eax = 0x7147;
    r.edx = 0;
    r.ds  = __dos32_dos_buffer_seg;
    r.esi = 0;
    __dos32_call_realmode_int(0x21, &r,0);
    if (r.flags & 1)
    {
      errno = __doserr_to_errno(r.eax);
      return 0;
    }
    if (strlen(__dos32_dos_buffer)+3 >= size)
    {
      errno = ERANGE;
      return 0;
    }
    strcpy(&buf[3],__dos32_dos_buffer);
  }
  else
  {
    bp=(char *)malloc(0x2000U);
    if (!bp) {
       errno = ENOMEM;
       return 0;
    }
    asm("movb $0x47,%%ah\n\
         movb $0,%%dl\n\
         int  $0x21\n\
         sbbl %%edx,%%edx"
        : "=a" (r.eax),"=d" (r.flags)
        : "S" (bp)
        : "eax","edx","esi","cc");
    if (r.flags)
    {
      errno = __doserr_to_errno(r.eax);
      free(bp);
      return 0;
    }
    if (strlen(bp)+3 >= size)
    {
      errno = ERANGE;
      free(bp);
      return 0;
    }
    strcpy(&buf[3],bp);
    free(bp);
  }

  /* switch FOO\BAR to foo/bar */
  for (bp = buf+3; *bp; bp++)
  {
    if (*bp == '\\')
      *bp = '/';
    if (*bp >= 'A' && *bp <= 'Z')
      *bp += 'a' - 'A';
  }

  buf[1] = ':';
  buf[2] = '/';
  /* get current drive */
  asm("mov $0x19,%%ah;int $0x21;addb $0x61,%%al;movb %%al,%b0"
      : "=qm" (buf[0])
      :
      : "eax");

  return buf;
}
