/*
 this file was changed or created for the DOS32 library for DJGPP on 21.9.1996
 new created files are copyright 1996 by C.Lageman, see docs.doc for details
*/
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
#include <libc/stubs.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <dos32api.h>
#include <dir.h>
#include <libc/dosio.h>


int
findfirst(const char *pathname, struct ffblk *ffblk, int attrib)
{
  _dos32_regs r;
  int pathlen;
  char dummy[256];

  if (pathname == 0 || ffblk == 0)
  {
    errno = EACCES;
    return -1;
  }

  pathlen = strlen(pathname) + 1;

  if(_USE_LFN) {

    /* si = 1 indicates DOS style dates, 0 means Win32 type dates.
       DOS style dates are broken in some Win95 betas, build for either.
       Release works with DOS date, it's faster, so use it. */
    #define USEDOSDATE 1
    #if USEDOSDATE == 1
      #define _Win32_to_DOS (long)
    #else
      extern long _Win32_to_DOS(long long WinTime);
    #endif
    _put_path(pathname);
    r.eax = 0x714e;
    r.ecx = attrib;
    r.edx = 0;
    r.ds  = __dos32_dos_buffer_seg;
    r.edi = pathlen;
    r.es  = r.ds;
    r.esi = USEDOSDATE;
    __dos32_call_realmode_int(0x21, &r, 0);
    if(!(r.flags & 1)) {
      struct ffblklfn ffblk32;
      /* Recover results */
      memcpy(&ffblk32,(char *)__dos32_dos_buffer+pathlen, sizeof(struct ffblklfn));

      ffblk->ff_attrib = (char)ffblk32.fd_attrib;
      *(long *)(&ffblk->ff_ftime) = _Win32_to_DOS(ffblk32.fd_mtime);
      ffblk->ff_fsize = ffblk32.fd_size;
      strcpy(ffblk->ff_name, ffblk32.fd_longname);
      strcpy(ffblk->lfn_magic, "LFN32");

      /* If no wildcards, close the handle */
      if(!strchr(pathname,'*') && !strchr(pathname,'?')) {
        asm("movw $0x71a1,%%ax\n\
             int  $0x21"
             :
             : "b" (r.eax)
             : "eax","ebx","cc");
        r.eax = 0;
      }
        
      ffblk->lfn_handle = r.eax & 0xffff;
      *(long *)(&ffblk->lfn_ctime) = _Win32_to_DOS(ffblk32.fd_ctime);
      *(long *)(&ffblk->lfn_atime) = _Win32_to_DOS(ffblk32.fd_atime);

      return 0;
    }
  } else {
    #define _sizeof_dos_ffblk 44
    _path_unix2dos(pathname,dummy,256);
    asm("movb $0x4e,%%ah\n\
         int  $0x21\n\
         sbbl %%ebx,%%ebx"
         : "=b" (r.flags), "=a" (r.eax)
         : "d" (&dummy), "c" (attrib)
         : "eax","ebx","ecx","edx","cc");
    if(!(r.flags)) {
      /* Recover results */
      memcpy( ffblk,__DOS32_DTA, _sizeof_dos_ffblk);
      return 0;
    }
  }
  errno = __doserr_to_errno(r.eax);
  return errno;
}
