/*
 this file was changed or created for the DOS32 library for DJGPP on 21.9.1996
 new created files are copyright 1996 by C.Lageman, see docs.doc for details
*/
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
#include <libc/stubs.h>
#include <crt0.h>
#include <string.h>
#include <libc/internal.h>
#include <stdlib.h>
#include <pc.h>
#include <libc/bss.h>
#include <dos32api.h>
#include <sys/segments.h>

/* Global variables */

int __bss_count = 1;

char **environ;
int  _crt0_startup_flags;    /* default to zero unless app overrides them */
int  _crt0_alloc_mem;        /* zero: alloc all mem */
char _crt0_alloc_dma;        /* alloc no dma buffers */

int __crt0_argc;
char **__crt0_argv;

/* Local variables */

char *__dos_argv0;

static void
setup_environment(void)
{
  char *cp=__env_address;
  int env_count=0;
  do {
    env_count++;
    while (*cp) cp++; /* skip to NUL */
    cp++; /* skip to next character */
  } while (*cp); /* repeat until two NULs */
  environ = (char **)malloc((env_count+1) * sizeof(char *));
  if (environ == 0)
    return;
  cp = __env_address;
  env_count = 0;
  do {
    /* putenv assumes each string is malloc'd */
    environ[env_count] = (char *)malloc(strlen(cp)+1);
    strcpy(environ[env_count], cp);
    env_count++;
    while (*cp) cp++; /* skip to NUL */
    cp++; /* skip to next character */
  } while (*cp); /* repeat until two NULs */
  environ[env_count] = 0;

}

extern void __main(void);
extern int  main(int, char **, char **);

void
__crt1_startup(void)
{
  char *pn;
  __bss_count ++;
  __crt0_argv = 0;
  setup_environment();
  __crt0_setup_arguments();
  pn = __crt0_argv ? __crt0_argv[0] : __dos_argv0;
  __crt0_load_environment_file(pn);
  __init_dos32_stuff();
  __main();
  exit(main(__crt0_argc, __crt0_argv, environ));
}

