/*
 this file was changed or created for the DOS32 library for DJGPP on 21.9.1996
 new created files are copyright 1996 by C.Lageman, see docs.doc for details
*/
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
#include <libc/stubs.h>
#include <io.h>
#include <stdio.h>
#include <errno.h>
#include <libc/dosio.h>
#include <dos32api.h>
 
int
remove(const char *fn)
{
  _dos32_regs r;
  unsigned attr;
  int directory_p;
  char used_func;
 
  /* Get the file attribute byte.  */
  attr = _chmod(fn, 0);
  directory_p = attr & 0x10;
 
  /* Now, make the file writable.  We must reset Vol, Dir, Sys and Hidden bits 
     in addition to the Read-Only bit, or else 214301 will fail.  */
  _chmod(fn, 1, attr & 0xffe0);

  /* Now delete it.  Note, _chmod leave dir name in tranfer buffer. */
  if (directory_p)
    used_func = 0x3a;      /* DOS Remove Directory function */
  else
    used_func = 0x41;      /* DOS Remove File function */
  if(_USE_LFN) {
    strcpy((char *)__dos32_dos_buffer,fn);
    r.eax  = 0x7100 | used_func;
    r.esi  = 0;         /* No Wildcards */
    r.edx  = 0;
    r.ds   = __dos32_dos_buffer_seg;
    __dos32_call_realmode_int(0x21, &r,0);
  }
  else {
    asm ("movb  %b2,%%ah\n\
          int   $0x21\n\
          sbbl  %%edx,%%edx"
         : "=d" (r.flags), "=a" (r.eax)
         : "g" (used_func), "d" (fn)
         : "eax","edx","cc");
  }
  if (r.flags & 1)
  {
    /* We failed.  Leave the things as we've found them.  */
    int e = __doserr_to_errno(r.eax);
 
    _chmod(fn, 1, attr & 0xffe7);
    errno = e;
    return -1;
  }
  return 0;
}
