/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
#include <libc/stubs.h>
#include <stdio.h>
#include <unistd.h>
#include <libc/file.h>
#include <fcntl.h>
#include <libc/dosio.h>

int
fseek(FILE *f, long offset, int ptrname)
{
  long c;
  long p = -1;			/* can't happen? */
  long adjust = 0;
  char *q, *qq;

  f->_flag &= ~_IOEOF;
  if (f->_flag&_IOREAD)
  {
    if (ptrname!=SEEK_END && f->_base &&
	!(f->_flag&_IONBF))
    {
      c = f->_cnt;
      p = offset;
      if (ptrname==SEEK_SET)
      {
	long curpos = lseek(fileno(f), 0L, 1);
	if (curpos == -1)
	  return -1;
	p += c - curpos;
      }
      else
	offset -= c;
      if(!(f->_flag&_IORW) && c>0 && p<=c
	 && p>=f->_base-f->_ptr)
      {
	if (__file_handle_modes[f->_file] & O_TEXT)
	{
	  q = &f->_ptr[f->_cnt];
	  qq = f->_ptr + (int)p;
	  while (--q >= qq)
	    if (*q == '\n')
	    {
	      adjust++; qq++;
	    }
	  p += adjust;
	}
	f->_ptr += (int)p;
	f->_cnt -= (int)p;
	return 0;
      }
    }
    if (f->_flag & _IORW)
    {
      f->_ptr = f->_base;
      f->_flag &= ~_IOREAD;
    }
    p = lseek(fileno(f), offset, ptrname);
    f->_cnt = 0;
  }
  else if (f->_flag & (_IOWRT|_IORW))
  {
    p = fflush(f);
    return lseek(fileno(f), offset, ptrname) == -1 || p == EOF ?
      -1 : 0;
  }
  return p==-1 ? -1 : 0;
}
