/*
 this file was changed or created for the DOS32 library for DJGPP on 21.9.1996
 new created files are copyright 1996 by C.Lageman, see docs.doc for details
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos32.h>
#include <dir.h>

/* lszz compression (c) by Haruhiko Okumura */
#include "lzsscomp.c"
#include "lzssdeco.c"

/* # define DEBUGSEARCH */

#define eprintf(msg) fprintf(stderr,msg)
#define vprintf if (verbose) printf
int verbose=0;

static void filefail(const char *msg,char *f)
{
    fprintf(stderr,msg,f);
    exit(1);
}

static void fail(const char *msg)
{
    eprintf(msg);
    exit(1);
}

#define onerror(a,b) if (a) fail(b)
#define BSZ  4096
#define EXE  1
#define DLL  2
#define OFF  0 /* switch off */
#define ON   1 /* switch on  */
#define SWAP 2 /* invert settings */
#define IGN  3 /* don't change */

/* boyer-moore search */
static long bm_search(FILE *afile,unsigned char *pattern,long startpos)
{
    unsigned char buffer[BSZ],*c,*c2;
    unsigned int len=strlen(pattern)-1,i,steps[256],data_in_buffer;
    long abspos=startpos;
#ifdef DEBUGSEARCH
    printf("pattern: %s length: %d ",pattern,len+1);
#endif
    if (len<0) return -1;
    if (fseek(afile,startpos,SEEK_SET)) fail("Seek error during search !\n");
    memset(steps,0,sizeof(steps));
    for(i=1,c=pattern;*c;c++,i++) steps[*c]=i;
    i=BSZ;
    c=buffer;
    while ((data_in_buffer=fread(c,1,i,afile))>0) {
      for(c=buffer+len;(c-buffer)<data_in_buffer;) {
        for(c2=c,i=len;*c2==pattern[i];i--,c2--)
                    if (!i) return abspos+c2-buffer; /* i==0 -> string found */
        if (steps[*c2]<++i) c+=i-steps[*c2];
        else c++;
      }
      memmove(buffer,&buffer[data_in_buffer-len],len);
      abspos+=data_in_buffer-len;
      i=BSZ-len;
      c=buffer+len;
    }
    return -1;
}

#ifndef DEBUGSEARCH

static char *file_type_names[]={"DOS32 executable","DOS32 dynamic link library"};
static char *flag_states[]={"OFF","ON"};
unsigned char small_stub[]={
#include "verysmll.h"
};

static void file_info(char *name,long startpos,long imagepos,
                      dos32_header file_header,char filetype)
{
#define fhdv file_header.dlink_version
   if (!verbose) {
     printf("\
                  file: %s\n\
                  type: %s\n",name,file_type_names[filetype-1]);
     if (startpos) printf("\
            stubloader: %ld bytes\n",startpos);
   }
   printf("\
          header start: %ld (0x%08lx)\n\
           image start: %ld (0x%08lx)\n\
         dlink version: %d.%d\n\
 minimum DOS32 version: %d.%d\n\
             exe size : %ld (0x%08lx), after linking, without stub \n\
       length of image: %ld (0x%08lx)\n\
entries in fixup table: %ld\n\
        initial memory: %ld (0x%08lx)\n\
           initial esp: %08lx\n\
           initial eip: %08lx\n\
             show logo: %s\n\
           compression: %s\n",
imagepos,imagepos,
file_header.exe_start+imagepos,file_header.exe_start+imagepos,
((fhdv >> 8) & 0xf)+((fhdv >> 12)*10),
(fhdv & 0xf)+(((fhdv >> 4) & 0xf)*10),
((file_header.minimum_dos32_version >> 8) & 0xf)+
((file_header.minimum_dos32_version >> 12)*10),
(file_header.minimum_dos32_version & 0xf)+
(((file_header.minimum_dos32_version >> 4) & 0xf)*10),
file_header.exe_length,file_header.exe_length,
file_header.image_length,file_header.image_length,
file_header.fixup_entries,
file_header.initial_memory,file_header.initial_memory,
file_header.start_esp,
file_header.start_eip,
flag_states[(file_header.exe_flags >> 1) & 1],
flag_states[file_header.exe_flags & 1]);
}

static char switch_it(long *l,char aswitch,char bitshift)
{
    switch (aswitch) {
         case ON:{
                    if (!((*l >> bitshift) & 1)) *l|=1 << bitshift;
                    else return 0;
                    break;
                  }
         case OFF:{
                    if ((*l >> bitshift) & 1) *l&=0xffffffffU - (1 << bitshift);
                    else return 0;
                    break;
                  }
        case SWAP:{
                    *l ^= 1 << bitshift;
                    break;
                  }
          default: return 0;
    }
    return 1;
}

static void process_file(char *name,char *stub,char compress,char logo,
                         char forcetype)
{
    FILE *afile,*nfile;
    unsigned long exe_magic=0;
    long startpos=0,imagepos,realread,headerpos;
    char filetype=EXE,switched_compression,*tempname="--XXXXXX",buffer[BSZ];
    dos32_header file_header;
    
    vprintf("proceeding file %s\n",name);
    if ((afile=fopen(name,"rb+"))==0) filefail("Can't open %s !",name);
    if ((fread(&exe_magic,1,2,afile)!=2)) filefail("Error reading %s !",name);

    /*
    we skip any exe-stub loader - it might contain a "Adam" or "DLL " string
    */
    if ((exe_magic==0x4d5a) || (exe_magic==0x5a4d)) {
      if ((fread(&exe_magic,1,4,afile)!=4)) filefail("Error reading %s !",name);
      if ((startpos=exe_magic & 0xffffU)!=0) startpos-=512;
      startpos+= (exe_magic & 0xffff0000U) >> 7;
      vprintf("stubloader %ld bytes\n",startpos);
    }

    /* search the dll/executable */
    /* The bm search for an executable is not very useful - DOS32 demands that
       the header starts right after the stub loader.
       We do it anyway; it won't harm us and handles also very strange
       configurations. (though it can cause errors)
       I must admit that the text-based search for the header is not very
       secure - it might produce wrong results if the image contains
       a "DLL " or "Adam" string. Feel free to implement a better method. */
    if (forcetype!=DLL) imagepos=bm_search(afile,dos32_header_id_char,startpos);
    if ((forcetype==DLL) || ((forcetype!=EXE) && (imagepos<0))) {
      if ((imagepos=bm_search(afile,dos32_dll_id_char,startpos))<0)
        filefail("%s is of an unknown file type !\n",name);
      filetype=DLL;
    }
    else if ((forcetype==EXE) && (imagepos<0))
        filefail("%s is of an unknown file type !\n",name);
    vprintf("%s found at %08lx\n",file_type_names[filetype-1],imagepos);
    if ((filetype==DLL) && (compress!=IGN)) fail("Sorry, you can't compress DLLs.\n");

    /* now read the DOS32 header */
    if (fseek(afile,imagepos,SEEK_SET)) filefail("Error seeking in %s !",name);
    if (fread(&file_header,1,dos32_header_size,afile)!=dos32_header_size)
                                        filefail("Error reading %s !",name);

    /* no changes ? then just dump out the settings */
    if ((!stub) && (compress==IGN) && (logo==IGN))
               file_info(name,startpos,imagepos,file_header,filetype);
    else
    {  /* we have to do some changes */
       switched_compression=switch_it(&file_header.exe_flags,compress,0);
       if ((!stub) && (!switched_compression))
       { /* only change the logo */
         if (switch_it(&file_header.exe_flags,logo,1))
         { /* changed - write new header */
           vprintf("switched logo - changed only the header\n");
           if (fseek(afile,imagepos,SEEK_SET)) filefail("Error seeking in %s !",name);
           if (fwrite(&file_header,1,dos32_header_size,afile)!=dos32_header_size)
                                        filefail("Error writing %s !",name);
         } /* header change */
       } /* logo only */
       else
       { /* we have to do some major changes (stub or compression) */
          /* ugh, this means writing the whole file */
            switch_it(&file_header.exe_flags,logo,1);
            mktemp(tempname);
            nfile=fopen(tempname,"wb+");
            if (!nfile) filefail("Can't create temp %s !",tempname);
            if (stub && (filetype !=DLL))
            { /* write a new stub */
               vprintf("writing new stub: ");
               if (strcmp(stub,"SMALL")==0)
               { /* internal */
                  vprintf("small internal stub\n");
                  if (fwrite(small_stub,1,sizeof(small_stub),nfile)!=
                      sizeof(small_stub)) filefail("Error writing %s !\n",tempname);
               } /* internal */
               else
               { /* other stub */
                 if (!*stub) stub=searchpath("dos32.exe");
                 if (stub==NULL) fail("dos32.exe not found !\n");
                 strcpy(buffer,stub);
                 vprintf("%s\n",buffer);
                 {
                    FILE *stubfile=fopen(buffer,"rb");
                    if (!stubfile) filefail("stub %s not found !\n",buffer);
                    while ((realread=fread(buffer,1,BSZ,stubfile)))
                    {
                      if (fwrite(buffer,1,realread,nfile)!=realread)
                        filefail("Error writing %s !\n",tempname);
                    }
                    fclose(stubfile);
                 }
               } /* other stub */
            } /* new stub */
            else
            {  /* set startpos so that stub is copied automatically */
               startpos=0;
            }

            if (fseek(afile,startpos,SEEK_SET)) filefail("Error seeking in %s !\n",name);

            imagepos-=startpos;
            while (imagepos)
            { /* copy stuff before header */
               if (imagepos>BSZ) realread=fread(buffer,1,BSZ,afile);
               else realread=fread(buffer,1,imagepos,afile);
               if (fwrite(buffer,1,realread,nfile)!=realread) filefail("Error writing %s !\n",tempname);
               imagepos-=realread;
            }

            /* skip header */
            headerpos=ftell(nfile);
            if (fseek(nfile,dos32_header_size,SEEK_CUR)) filefail("Error seeking in %s !\n",tempname);
            if (fread(buffer,1,dos32_header_size,afile)!=dos32_header_size)
                                 filefail("Error reading %s !\n",name);

            if (switched_compression)
            { /* compress / decompress */
                long new_image_size=0;
                if (file_header.exe_flags & 1)
                { /* compress */
                  vprintf("compressing...\n");
                  Encode(afile,nfile,&new_image_size,file_header.image_length);
                }
                else
                { /* decompress */
                  vprintf("decompressing...\n");
                  Decode(afile,nfile,&new_image_size,file_header.image_length);
                }
                file_header.exe_length += new_image_size-file_header.image_length;
                file_header.image_length = new_image_size;
            }

            while ((realread=fread(buffer,1,BSZ,afile)))
            { /* copy rest of file */
               if ((fwrite(buffer,1,realread,nfile)!=realread)) filefail("Error writing %s !\n",tempname);
            }

            vprintf("writing header\n");
            if (fseek(nfile,headerpos,SEEK_SET)) filefail("Error seeking in %s !\n",tempname);
            if (fwrite(&file_header,1,dos32_header_size,nfile)!=dos32_header_size)
                     filefail("Error writing %s !\n",tempname);

            fclose(nfile);
            fclose(afile);
            if (remove(name)) filefail("Error deleting old %s !\n",name);
            if (rename(tempname,name))
            {
                fprintf(stderr,"Error renaming %s to %s !\n",tempname,name);
                exit(1);
            }
            return;
       }
    }
    fclose(afile);
}

static char switch_value(char *a)
{
    switch (*(a+2)) {
          case '-': return OFF;
          case '+': return ON;
    }
    return SWAP;
}

int main (int argc,char **argv)
{
   char compress=IGN,logo=IGN,*stubname=0,forcetype=IGN;
   if (argc<2) {
     eprintf("EditD32 1.00 - changes stettings of DOS32 executables and DLLs\n\
(c) 1275-1996 by rasputin\n\
usage: editd32 [-v] [-l[+-]] [-c[+-]] [-t[de]] [-s[NAME]] files\n\
-v     - verbose mode on\n\
-l[+-] - show logo on/off (if no +/- supplied, the actual switched is switched)\n\
-c[+-] - compression on/off (if no +/- supplied,the actual setting is switched)\n\
-t[de] - sets the file type (d =DLL, e= executable), usefull for editing a DLL\n\
         in an executable
-s[NAME] - supply a new stub (if -s only then dos32.exe is used, -sSMALL causes\n\
           use of internal minimum stub)\n\
files  - any DOS32 executable (stubbed or not stubbed) or DLL\n\n\
On DLLs the -s argument is ignored.\n\
If a files contains several DLLs or an executable and DLLs then the (first)\n\
executable or the first DLL is changed.\n\
Any data BEFORE an executable is considered to be a stub loader.\n\
If the are no switches supplied then information about the executable / DLL is\n\
shown.\n\
IMPORTANT: THE ORDER OF THE ARGUMENTS DOES MATTER, SWITCHES TAKE ONLY EFFEKT\n\
           ON THE ARGUMENTS AFTER THEM !\n");
     return 0;
   }
   for (;argc>1;argc--,argv++) {
        if (*argv[1]=='-') {
          switch (*(argv[1]+1)) {
               case 'v':{ verbose=1; break; }
               case 's':{ stubname=argv[1]+2; break;}
               case 'l':{ logo=switch_value(argv[1]); break; }
               case 'c':{ compress=switch_value(argv[1]); break; }
               case 't':{ if (*(argv[1]+2)=='d') {forcetype=DLL; break;}
                          else if (*(argv[1]+2)=='e') {forcetype=EXE; break;} }
               default: fail("wrong argument !\n");
          }
        }
        else process_file(argv[1],stubname,compress,logo,forcetype);
   }
   return 0;
}

#else
void main(int argc,char **argv)
{
    if (argc==3) {FILE *f=fopen(argv[1],"rb");
                  printf("[%s] ",argv[1]);
                  if (f) {printf("result: %ld\n",bm_search(f,argv[2],0));
                  fclose(f);} }
}
#endif
