
//  WinFSR 2.1	by Fran Finnegan  (CompuServe: 76244,145)
//  Copyright (c) 1991-92 Finnegan O'Malley & Company Inc.
//		All Rights Reserved.
//  First Published in PC Magazine, November 12, 1991.

#define NOCOMM
#include <windows.h>

#include "winfsr.h"

typedef DWORD (FAR PASCAL *GETHEAPSPACES)(HANDLE hModule);

extern int	 PASCAL WinMain(HANDLE, HANDLE, LPSTR, int);
extern long  FAR PASCAL WndProc(HWND, WORD, WORD, DWORD);
extern int   FAR PASCAL DlgProc(HWND, WORD, WORD, DWORD);
extern int   FAR PASCAL DlgIcon(HWND, WORD, WORD, DWORD);

#define FALSE		0
#define TRUE		1

#define ID_TIMER	1

static	GETHEAPSPACES	GetHeapSpaces;												    char *_="\x28\x63\x29 \x31\x39\x39\x31 \x46\x69\x6E\x6E\x65\x67\x61\x6E \x4F\x27\x4D\x61\x6C\x6C\x65\x79\x2E";
static	WNDCLASS	mWc;
static	HWND		mhWnd, mhDlgMain, mhDlgOptions;
static	WORD		mwWarn = 20;	//  %
static	int		miIcon = 1;	//  plain
static	char		mszClassName [] = "WINFSR",
			mszWindowName[64] = "System Resources",
			mszWinIniIcon[] = "Icon",
			mszWinIniName[] = "Name",
			mszWinIniWarn[] = "%";

////////////////////////////////////////////////////////////////////////

extern int	 PASCAL WinMain(HANDLE ahInst, HANDLE ahPrevInst,
				LPSTR alpsCmdLine, int aiCmdShow)
{
auto	FARPROC 	aFpDlgProc;
auto	MSG		aMsg;

static	char		sszGetHeapSpaces[] = "GETHEAPSPACES";

			alpsCmdLine;  aiCmdShow;

//  retrieve GetHeapSpaces's address in the kernel
if ((GetHeapSpaces = (GETHEAPSPACES)GetProcAddress(
	GetModuleHandle("KERNEL"), sszGetHeapSpaces)) == NULL)
    {
    MessageBox(0, "Function not found!", sszGetHeapSpaces, 0);
    return FALSE;
    }

//  show any previous instance's dialog
if (ahPrevInst)
    {
    mhWnd = FindWindow(mszClassName, NULL);
    PostMessage(mhWnd, WM_QUERYOPEN, 0, 0L);
    return FALSE;
    }

//  get WIN.INI info
miIcon = GetProfileInt(mszClassName, mszWinIniIcon, miIcon);
GetProfileString(mszClassName, mszWinIniName, mszWindowName,
	mszWindowName, sizeof(mszWindowName));
mwWarn = GetProfileInt(mszClassName, mszWinIniWarn, mwWarn);

//  register the window class
mWc.lpfnWndProc   = WndProc;
mWc.hInstance	  = ahInst;
mWc.hIcon	  = LoadIcon(ahInst, mszClassName);
mWc.lpszClassName = mszClassName;
RegisterClass(&mWc);

//  create and show the window as an icon
mhWnd = CreateWindow(mszClassName, mszWindowName,
	WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, 0,
	CW_USEDEFAULT, CW_USEDEFAULT, 0, 0, ahInst, NULL);
ShowWindow(mhWnd, SW_SHOWMINIMIZED);

//  create and show the dialog
aFpDlgProc = MakeProcInstance(DlgProc, ahInst);
CreateDialog(ahInst, "DIALOG", mhWnd, aFpDlgProc);

//  update the icon and dialog every second
SetTimer(mhWnd, ID_TIMER, 1000, NULL);

while (GetMessage(&aMsg, 0, WM_NULL, WM_NULL))
    if (!(mhDlgMain && IsDialogMessage(mhDlgMain, &aMsg)))
	{
	TranslateMessage(&aMsg);
	DispatchMessage(&aMsg);
	}

FreeProcInstance(aFpDlgProc);
return FALSE;
}

////////////////////////////////////////////////////////////////////////

extern long  FAR PASCAL WndProc(HWND ahWnd, WORD awMsg,
				WORD awParam, DWORD alParam)
{
auto	DWORD		adwKernel, adwGDI, adwUser;
auto	WORD		awPctKernel, awPctGDI, awPctUser,
			awPctFSR;
auto	HDC		ahDc;
auto	int		aiSmCyIcon;
auto	PAINTSTRUCT	aPs;
auto	char		aszText[256];

static	DWORD		sdwKernel = 1L;
static	HANDLE		shModuleGDI, shModuleUser;
static	WORD		swPctKernel, swPctGDI, swPctUser,
			swPctFSR = 99;
static	BOOL		sbWarned;
static	int		siNumColors, siHide;
static	RECT		sRt;
static	char		*spsMode;

switch (awMsg)
    {
    case WM_CREATE:
	switch ((WORD)GetWinFlags() & (WF_ENHANCED | WF_STANDARD |
		 WF_LARGEFRAME | WF_SMALLFRAME))
	    {
	    case WF_ENHANCED:	 spsMode = "386 Enhanced";      break;
	    case WF_STANDARD:	 spsMode = "Standard";          break;
	    case WF_LARGEFRAME:  spsMode = "Large-EMS Real";    break;
	    case WF_SMALLFRAME:  spsMode = "Small-EMS Real";    break;
	    default:		 spsMode = "Real";              break;
	    }
	shModuleGDI  = GetModuleHandle("GDI" );
	shModuleUser = GetModuleHandle("USER");
	siHide = GetProfileInt(mszClassName, "Hide", 9);
	break;

    case WM_SIZE:
	//  center the icon and text appropriately
	*(DWORD *)&sRt.left   = 0L;
	*(DWORD *)&sRt.right  = alParam;  //  same as GetClientRect
	aiSmCyIcon = GetSystemMetrics(SM_CYICON);
	InflateRect(&sRt, -((sRt.right	-
		GetSystemMetrics(SM_CXICON)) / 2 + 1),
		-((sRt.bottom - aiSmCyIcon)  / 2 + 1));
	sRt.bottom = sRt.top  + aiSmCyIcon   / 2;
	break;

    case WM_TIMER:
	//  calculate the Free System Resources percentages
	adwKernel = GetFreeSpace(0) / 1024;	//  1K granularity
	adwGDI	  = GetHeapSpaces(shModuleGDI );
	adwUser   = GetHeapSpaces(shModuleUser);

	if (sdwKernel < adwKernel)  //	maximum global heap (in K)
	    sdwKernel = adwKernel;  //	    that's been available
	awPctKernel = (WORD)(10000L *	     adwKernel	/
					     sdwKernel );
	awPctGDI    = (WORD)(10000L * LOWORD(adwGDI   ) /
				      HIWORD(adwGDI   ));
	awPctUser   = (WORD)(10000L * LOWORD(adwUser  ) /
				      HIWORD(adwUser  ));

	if (swPctKernel  != awPctKernel   //  basis-point comparisons
	||  swPctGDI	 != awPctGDI	  //	instead of absolutes,
	||  swPctUser	 != awPctUser  )  //	to prevent flickering
	    {
	    swPctKernel   = awPctKernel;
	    swPctGDI	  = awPctGDI   ;
	    swPctUser	  = awPctUser  ;
	    awPctFSR  = min(awPctGDI, awPctUser);   //	normal FSRs
	    if (awPctFSR  > awPctKernel)
		awPctFSR  = awPctKernel;    //	including global heap
	    if (swPctFSR != awPctFSR / 100)   //  percent comparison
		{
		swPctFSR  = awPctFSR / 100;
		InvalidateRect(ahWnd, &sRt, FALSE);
		UpdateWindow(ahWnd);
		}
	    wsprintf(aszText,
		    "%s-Mode Free Memory... %luK/%luK=%u%%\r\n"
		    "GDI... %u/%u=%u%%    USER... %u/%u=%u%%\r\n"
		    "Free System Resources... %u%%\r\n", (LPSTR)spsMode,
			   adwKernel ,	      sdwKernel , awPctKernel / 100,
		    LOWORD(adwGDI   ), HIWORD(adwGDI   ), awPctGDI    / 100,
		    LOWORD(adwUser  ), HIWORD(adwUser  ), awPctUser   / 100,
		    swPctFSR);
	    SetDlgItemText(mhDlgMain, ID_TEXT, aszText);
	    if (mwWarn < swPctFSR)	//  high FSRs
		sbWarned  = FALSE;
	    else			//   low FSRs
		if (sbWarned == FALSE)
		    {
		    sbWarned  = TRUE ;		//  show the dialog
		    PostMessage(ahWnd, WM_QUERYOPEN, 0, 0L);
		    }
	    }
	else
	    if (siHide-- == 0
	    &&	mhDlgOptions == 0)
		ShowWindow(mhDlgMain, SW_HIDE); //  hide the dialog
	break;

    case WM_PAINTICON:
	if (ahDc = BeginPaint(ahWnd, &aPs))
	    {
	    DrawIcon(ahDc, sRt.left - 1, sRt.top - 1,
		    LoadIcon(mWc.hInstance, miIcon?  "PLAIN":  "CLASSIC"));
	    if (siNumColors == 0)
		siNumColors  =	GetProfileInt(mszClassName, "Colors",
				GetDeviceCaps(ahDc, NUMCOLORS));
	    if (siNumColors >= 16)	//  check for colors (1.0: >= 8)
		SetBkMode(ahDc, TRANSPARENT);
	    DrawText(ahDc,   aszText,	//  paint over icon
		    wsprintf(aszText, "%u%%", swPctFSR), &sRt,
		    DT_CENTER | DT_VCENTER | DT_SINGLELINE |
		    DT_NOCLIP | DT_NOPREFIX);
	    EndPaint(ahWnd, &aPs);
	    }
	break;

    case WM_QUERYOPEN:
	ShowWindow(mhDlgMain, SW_SHOW); 	//  show the dialog
	BringWindowToTop(mhDlgMain);
	break;

    case WM_CLOSE:
	KillTimer(ahWnd, ID_TIMER);
	DestroyWindow(mhDlgMain);
	mhDlgMain = 0;
	DestroyWindow(ahWnd);
	break;

    case WM_DESTROY:
	PostQuitMessage(FALSE);
	break;

    default:
	return DefWindowProc(ahWnd, awMsg, awParam, alParam);
    }
return FALSE;
}

////////////////////////////////////////////////////////////////////////

extern int   FAR PASCAL DlgProc(HWND ahDlg, WORD awMsg,
				WORD awParam, DWORD alParam)
{
auto	RECT		aRt;

			alParam;

switch (awMsg)
    {
    case WM_INITDIALOG:
	mhDlgMain = ahDlg;

	//  center dialog box
	GetWindowRect(ahDlg, &aRt);
	OffsetRect(&aRt, -aRt.left  , -aRt.top	 );
	MoveWindow(ahDlg,   //	correct way to center a dialog:
		((GetSystemMetrics(SM_CXSCREEN) - aRt.right ) / 2 + 4) & ~7,
		 (GetSystemMetrics(SM_CYSCREEN) - aRt.bottom) / 2,
		aRt.right , aRt.bottom, FALSE);

	//  initialize controls
	SetWindowText(ahDlg, mszWindowName);
	SendMessage(mhWnd, WM_TIMER, 0, 0L);
	return TRUE;	//  did process the message

    case WM_COMMAND:
	if (awParam == ID_OPTIONS)
	    if (mhDlgOptions)
		BringWindowToTop(mhDlgOptions);
	    else
		{
		auto	FARPROC 	aFpDlgProc;

		aFpDlgProc = MakeProcInstance(DlgIcon, mWc.hInstance);
		DialogBox(mWc.hInstance, "ICON", mhWnd, aFpDlgProc);
		FreeProcInstance(aFpDlgProc);
		SetFocus(GetDlgItem(ahDlg, ID_OPTIONS));
		}
	else
	    if (mhDlgOptions == 0)
		ShowWindow(ahDlg, SW_HIDE);	//  hide the dialog
	return TRUE;	//  did process the message
    }
return FALSE;	//  did not process the message
}

////////////////////////////////////////////////////////////////////////

extern int   FAR PASCAL DlgIcon(HWND ahDlg, WORD awMsg,
				WORD awParam, DWORD alParam)
{
auto	RECT		aRt;
auto	char		aszText[64];

switch (awMsg)
    {
    case WM_INITDIALOG:
	mhDlgOptions = ahDlg;

	//  overlay parent dialog box
	GetWindowRect(mhDlgMain, &aRt);
	MoveWindow(ahDlg, aRt.left  ,  aRt.top	 ,
			  aRt.right  - aRt.left  ,
			  aRt.bottom - aRt.top	 , FALSE);

	//  initialize controls
	SetWindowText(ahDlg, mszWindowName);
	CheckRadioButton(ahDlg, ID_ICON_CLASSIC, ID_ICON_PLAIN,
				ID_ICON_CLASSIC + miIcon);
	SetDlgItemText(ahDlg, ID_NAME, mszWindowName);
	GetProfileString(mszClassName, mszWinIniWarn, "20",
		aszText, sizeof(aszText));
	SetDlgItemText(ahDlg, ID_PERCENT, aszText);
	return TRUE;	//  did process the message

    case WM_CTLCOLOR:
	if (HIWORD(alParam) == CTLCOLOR_STATIC)
	    switch (GetDlgCtrlID(LOWORD(alParam)))
		{
		case ID_ICO_CLASSIC:
		case ID_ICO_PLAIN  :
		    return (int)GetStockObject(NULL_BRUSH);
		}
	break;	//  did not process the message

    case WM_COMMAND:
	switch (awParam)
	    {
	    case IDOK:
		//  icon
		miIcon = IsDlgButtonChecked(ahDlg, ID_ICON_PLAIN);
		WriteProfileString(mszClassName, mszWinIniIcon,
						 miIcon?  "1":  "0");
		InvalidateRect(mhWnd, NULL, TRUE);

		//  name
		GetDlgItemText(ahDlg, ID_NAME,	  mszWindowName,
					   sizeof(mszWindowName));
		WriteProfileString(mszClassName,  mszWinIniName,
						  mszWindowName);
		SetWindowText(mhDlgMain, mszWindowName);
		SetWindowText(mhWnd    , mszWindowName);

		//  %
		GetDlgItemText(ahDlg, ID_PERCENT, aszText,
					   sizeof(aszText));
		WriteProfileString(mszClassName,  mszWinIniWarn,
						  aszText);
		mwWarn = GetProfileInt(mszClassName, mszWinIniWarn, mwWarn);

		PostMessage((HWND)-1, WM_WININICHANGE, 0, 0L);
		//  fall through
	    case IDCANCEL:
		mhDlgOptions = 0;
		EndDialog(ahDlg, 0);
		break;
	    }
	return TRUE;	//  did process the message
    }
return FALSE;	//  did not process the message
}

