#ifndef __IOSTATUS_H__
#define __IOSTATUS_H__

#define STATUS1_INIT                   0xFFFF

#define STATUS1_START                  0x0000
#define STATUS1_BOOT_SECTOR            0x0001
#define STATUS1_DIRECTORY              0x0002
#define STATUS1_FAT                    0x0003
#define STATUS1_SYSTEM_FILE            0x0004
#define STATUS1_CYLINDER               0x0005
#define STATUS1_HEAD                   0x0006
#define STATUS1_SYSTEM                 0x0008
#define STATUS1_END                    0x0009

#define STATUS1_ERROR                  0x000B

#define STATUS2_FILE                   0x0001

#define STATUS3_OPEN_FAIL              0x0001
#define STATUS3_OPEN_FLAGS_BAD         0x0002
#define STATUS3_OPEN_INPUT_BAD         0x0003
#define STATUS3_OPEN_NOT_SUPPORTED     0x0004
#define STATUS3_OPEN_FILE_IO_ERROR     0x0005

#define STATUS2_FILE_READ              0x0002
#define STATUS2_FILE_WRITE             0x0003

#define STATUS2_WRITE                  0x0004
#define STATUS2_READ                   0x0005
#define STATUS2_FORMAT                 0x0006
#define STATUS2_FORMATTING             0x0007

#define STATUS2_SYSTEM                 0x0008

#define STATUS2_SYSTEM_FILE_MISSING    0x0009
#define STATUS2_SYSTEM_FILE_OPEN       0x000A

#define STATUS2_MEMORY                 0x000B

#define STATUS2_SYSTEM_FILE            0x000C

#define STATUS2_FAT                    0x000D

#define STATUS2_DIRECTORY              0x000E

#define STATUS2_BOOT_SECTOR            0x000F

#define STATUS2_DISK_SPACE             0x0010

#define STATUS2_HEAD                   0x0011

#define STATUS2_COMPARE                0x0012

#define STATUS2_DPT                    0x0013

#define STATUS2_SECTORS                0x0014

#define MAXSECTORSIZE 512
#define MAXSECTORS     36
#define MAXHEADS        2
#define MAXCYLINDERS   80

#endif /* __IOSTATUS_H__ */
