// ============================================================================
// about.c -- dialog procedure for the "About..." dialog box.
// ============================================================================


#include <windows.h>
#include "resgauge.h"


// ============================================================================
// > > > > > > > > > > > > > > >  code  begins  < < < < < < < < < < < < < < < <
// ============================================================================
// Processes messages for the "About..." dialog box.
// ----------------------------------------------------------------------------
BOOL
CALLBACK
AboutDlgProc(
HWND      hDlg,   // window handle of the dialog
UINT      msg,    // message type
WPARAM    wParam, // 16 bits of information
LPARAM    lParam) // 32 additional bits of information
{
    int   i;
    BOOL  fReturn;
    HFONT hFont;

    fReturn = FALSE;
    switch ( msg )
    {
        case WM_INITDIALOG:
            // center the dialog
            CenterDialog(hDlg);

            // set the font of the text boxes
            hFont = GetStockObject(ANSI_VAR_FONT);
            SendDlgItemMessage(hDlg, IDOK, WM_SETFONT, (WPARAM) hFont, FALSE);
            for ( i = IDD_ABOUT1; i <= LAST_ABOUT; ++i )
                SendDlgItemMessage(hDlg, i, WM_SETFONT, (WPARAM) hFont, FALSE);

            // tell DefDlgProc() that this message was handled
            fReturn = TRUE;
            break;

        case WM_COMMAND:
            if ( (wParam == IDOK) || (wParam == IDCANCEL) )
            {
                EndDialog(hDlg, TRUE);
                fReturn = TRUE;
            }
            break;
    }

    return(fReturn);
} // AboutDlgProc


// ==============
// end of about.c
// ==============
