# include "windows.h"
# include "ewtdebug.h"

HANDLE hInst;
HWND hRulerWnd;
BYTE bSnapFlag = FALSE;

long FAR PASCAL MainWndProc (HWND, unsigned, WORD, LONG);
int InitApplication (HANDLE);
int InitInstance (HANDLE, int);

int PASCAL WinMain(hInstance, hPrevInstance, lpCmdLine, nCmdShow)
HANDLE hInstance;
HANDLE hPrevInstance;
LPSTR lpCmdLine;
int nCmdShow;
{
    MSG msg;

    if (!hPrevInstance)
        if (!InitApplication(hInstance))
            return (FALSE);

    if (!InitInstance(hInstance, nCmdShow))
        return (FALSE);

    while (GetMessage(&msg, NULL, NULL, NULL)) {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }
    return (msg.wParam);
}

BOOL InitApplication(hInstance)
HANDLE hInstance;
{
    WNDCLASS  wc;

    wc.style = NULL;
    wc.lpfnWndProc = MainWndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName =  (LPSTR) "TTT";
    wc.lpszClassName = (LPSTR) "Test_Class";

    return (RegisterClass(&wc));
}

BOOL InitInstance(hInstance, nCmdShow)
    HANDLE          hInstance;
    int             nCmdShow;
{
    HWND            hWnd;

    hInst = hInstance;

    hWnd = CreateWindow(
        "Test_Class",
        "Ruler Test Application",
        WS_OVERLAPPEDWINDOW,
        0,
        0,
        GetSystemMetrics(SM_CXSCREEN),
        GetSystemMetrics(SM_CYSCREEN),
        NULL,
        NULL,
        hInstance,
        NULL
    );

    if (!hWnd)
        return (FALSE);

    ShowWindow(hWnd, nCmdShow);
    UpdateWindow(hWnd);
    return (TRUE);

}

long FAR PASCAL MainWndProc(hWnd, message, wParam, lParam)
HWND hWnd;
unsigned message;
WORD wParam;
LONG lParam;
{
    int x;

    switch (message) {

    case WM_CREATE:
        CreateDebugWindow (hWnd);
        return (DefWindowProc(hWnd, message, wParam, lParam));

    case WM_COMMAND:
        switch (wParam) {
        case 100:
            DBG_PutString ("test 1", "this is a string");
            break;

        case 101:
            for (x=0; x<50; x++)
                DBG_PutInt ("test 2", x);
            break;

        case 102:
            for (x=0; x<100; x++)
                DBG_PutInt ("test 3", x);
            break;
        }
        break;

    default:
	    return (DefWindowProc(hWnd, message, wParam, lParam));
    }
    return (NULL);
}
