;----------------------------------------------------------
; MACRO DEFINITIONS INCLUDE FILES  (STDMAC.INC)
;----------------------------------------------------------
; STANDARD EQUATES:
;
TRUE    EQU     0FFFFh
FALSE   EQU     0
;
;Standard nonprintable ASCII characters
NUL     EQU     0
BEL     EQU     7
BS      EQU     8
HT      EQU     9
LF      EQU     10
FF      EQU     12
CR      EQU     13
SUBST   EQU     1Ah
ESCAPE  EQU     1Bh
SPACE   EQU     20h
COLON   EQU     3Ah
SCOLON  EQU     3Bh
;
; IBM Extended characters
SLINE   EQU     11000100b
;
;---------------------------------------------------------
;;** @DisChr ******************************* GENERAL PURPOSE MACRO ******
;; display an immediate character
IF1     ;; assemble only during Pass 1
@DisChr MACRO   char
	IFNB <char>     ;; was character argument specified?
			;; yes, so insert code
	push    ax      ;; save registers used
	push    dx
	mov     dl,char ;; load the character
	mov     ah,02h  ;; load func. number
	@DosCall        ;; call ms-dos
	pop     dx
	pop     ax
	ELSE            ;; otherwise
	.ERR            ;; generate error and output message
	%OUT @DisChr macro: "char" argument not supplied.
	ENDIF
	;;
	ENDM    ;; end of macro definition
ENDIF   ;; end of pass execution
;;
;;** DOS call *************************************************
;; Call an MS-DOS function
IF1     ;; assemble only during Pass 1
@DosCall MACRO
	int     21h
	ENDM    ;; end of macro definition
ENDIF   ;; end of pass execution
;;
;;** @ExitToDos ********************* GENERAL PURPOSE MACRO *********
;; Terminate process with optional ERRORLEVEL settings
IF1
@ExitToDos MACRO errorcode
	IFB <errorcode> ;; was errorcode spec'd?
	mov    ax,4C00h        ;; no load func & errorlevel 0
	ELSE
	mov     ah,4Ch
	mov     al,errorcode
	ENDIF
	@DosCall
	ENDM
ENDIF
;;
;; ** @DisStr *********************** GENERAL PURPOSE MACRO **********
;; Display a strng from memory with default "$"
;; end of string terminator or with a spceified terminator
;; Calls @DisStr1 or @DisStr2 internal macros.)
IF1     ;; assemble only in pass 1
@DisStr MACRO   string,terminator
	IFNB <string>   ;; was string specifid
			;; yes, so...
	  IFB <terminator> ;; was terminator spec'd?
		;; no, so insert the default code for "$"
		@DisStr1 string
	  ELSE ;; otherwise terminator spec'd
	    ;;    @DisStr2 string,terminator
	  ENDIF ;; end term check
	ELSE ;;otherwise string not spec'd
	.ERR    ;; gen error and message
	%OUT @DisStr macro: "string" agrument not supplied.
	ENDIF
	ENDM
ENDIF ;; end pass execution
;;
;;** @DisStr1 **********************************Support Macro **
;; Called by @DisStr to display string form memory with
;; default "$" end-of-string terminator.
IF1
@DisStr1 MACRO  string
	push    ax
	push    dx
	mov     dx,offset ds:string ;; point to string in mem
	mov     ah,09h
	@DosCall
	pop     dx
	pop     ax
	ENDM
ENDIF
