#include "io.h"
#include "stdio.h"
#include "fcntl.h"
#include "string.h"
#include "memory.h"
#include "sys\types.h"

#define S_IFMT          0170000         /* file type mask */
#define S_IFDIR         0040000         /* directory */
#define S_IFCHR         0020000         /* character special */
#define S_IFREG         0100000         /* regular */
#define S_IREAD         0000400         /* read permission, owner */
#define S_IWRITE        0000200         /* write permission, owner */
#define S_IEXEC         0000100         /* execute/search permission, owner */

#define FILENAME           13
#define TITLE              27
#define PORTSTR            15
#define TIMESTR            10
#define PHONE              26
#define INITSTR            26
#define PROFILE            20
#define LISTSTR            20
#define MAXBUFF            128
#define MINBUFF            32
#define RECBUFLEN          4096
#define XMITBUFLEN         4096

typedef struct tagSESSION
{
    char      szTitle[TITLE];
    char      szPhone[PHONE];
    int       iProtocol;
    char      szScript[FILENAME];
    int       bSessRsvd[10];
} SESSION;

typedef struct tagPORT
{
    int       iComPort;
    int       iBaudRate;
    int       iFlowCtl;
    int       iParity;
    int       iDataBits;
    int       iStopBits;
    int       bCarrier;
    int       bLockBaud;
    int       iParityCheck;
    int       bPortRsvd[10];
} PORT;

typedef struct tagTERMINAL
{
    int       iTerminal;
    int       iFontSize;
    int       iCaret;
    int       iBufLines;
    int       iRows;
    int       iCols;
    long      crFore;
    long      crBack;
    int       bCRLF;
    int       bAutoWrap;
    int       bEcho;
    int       bColors;
    char      szFont[LISTSTR];
    int       bTermRsvd[10];
} TERMINAL;

typedef struct tagZMODEMOPT
{
    int    bAutoDown;
    int    bUseCRC32;
    int    bResume;
    int    iSendMgtOpt;
    int    iRecvMgtOpt;
} ZMODEMOPT;

typedef struct tagDIR
{
    SESSION     Session;
    PORT        Port;
    TERMINAL    Terminal;
    ZMODEMOPT   ZModemOpt;
} DIR;

typedef struct OLDDIR
{
        char  szDirectoryName[30];
        char  szPhoneNumber[20];
        char  szAutoScript[80];
        int   iTerminal;
        int   iTransfer;
        int   iEcho;
        int   iCrLf;
        int   iMaxSize;
        int   iMaxChar;
        int   iModemType;
        int   iAutoAnswer;
        int   iFlowCtl;
        int   iComPort;
        int   iBaudRate;
        int   iParity;
        int   iDataBits;
        int   iStopBits;
        int   iCarrierDetect;
        int   iExtra2;
        int   iExtra3;
} OLDDIR;


main (int argc, char *argv[])
{
   int i;
   DIR Dir;
   int hDest;
   int hSource;
   OLDDIR OldDir;
   char szSource[30];
   char szDest[30];

   if (argc < 3)
   {
      printf ("Syntax is DIR2DR1 SOURCE DEST\n");
      printf ("where SOURCE is the orginal dir file\n");
      printf ("and DEST is the new dir file\n");
      printf ("example CONVERT MLINK.DIR NEW.DR1\n");
      printf ("You do not need to provide the file extensions\n");

      return 1;
   }
   
   strcpy (szSource, argv[1]);
   if (!strchr (argv[1], '.'))
      strcat (szSource, ".dir");

   strcpy (szDest, argv[2]);
   if (!strchr (argv[2], '.'))
      strcat (szDest, ".dr1");

   hDest   = creat (szDest, S_IWRITE);
   hSource = open (szSource, O_RDWR | O_BINARY);

   memset (&Dir, '\0', sizeof (DIR));
   memset (&OldDir, '\0', sizeof (OLDDIR));

   strcpy (Dir.Terminal.szFont, "Terminal");
   Dir.Terminal.crFore       = 12632256L;
   Dir.Terminal.crBack       = 8388608L;
   Dir.Terminal.iRows        = 25;
   Dir.ZModemOpt.bAutoDown   = 1;
   Dir.ZModemOpt.iSendMgtOpt = 1;

   i = sizeof (OLDDIR);
   while (read (hSource, &OldDir, sizeof (OLDDIR)))
   {
        strcpy (Dir.Session.szTitle, OldDir.szDirectoryName);
        Dir.Session.szTitle[TITLE] = 0;
        strcpy (Dir.Session.szPhone, OldDir.szPhoneNumber);

        Dir.Session.iProtocol   = OldDir.iTransfer - 470;

        Dir.Terminal.iTerminal  = OldDir.iTerminal - 440;
        Dir.Terminal.iBufLines  = OldDir.iMaxSize;
        Dir.Terminal.iCols      = OldDir.iMaxChar;
        Dir.Terminal.bCRLF      = OldDir.iCrLf;
        Dir.Terminal.bEcho      = OldDir.iEcho;
        Dir.Terminal.bColors    = Dir.Terminal.iTerminal ? 0 : 1;

        Dir.Port.iComPort   = OldDir.iComPort;
        Dir.Port.iBaudRate  = OldDir.iBaudRate; 
        Dir.Port.iFlowCtl   = OldDir.iFlowCtl;
        Dir.Port.iParity    = OldDir.iParity;
        Dir.Port.iDataBits  = OldDir.iDataBits;
        Dir.Port.iStopBits  = OldDir.iStopBits;

        write (hDest, &Dir, sizeof (DIR));
   } 
   close (hDest);
   close (hSource);
}



