VERSION 4.00
Begin VB.Form Main 
   Caption         =   "EasyNet Editor"
   ClientHeight    =   4500
   ClientLeft      =   1170
   ClientTop       =   1905
   ClientWidth     =   6225
   FillColor       =   &H0080FFFF&
   BeginProperty Font 
      name            =   "MS Sans Serif"
      charset         =   0
      weight          =   700
      size            =   8.25
      underline       =   0   'False
      italic          =   0   'False
      strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H80000008&
   Height          =   5190
   Left            =   1110
   LinkTopic       =   "Form1"
   ScaleHeight     =   4500
   ScaleWidth      =   6225
   Top             =   1275
   Width           =   6345
   Begin EasynetLib.Easynet Net1 
      Height          =   3105
      Left            =   240
      TabIndex        =   7
      Top             =   240
      Width           =   3795
      _Version        =   65537
      _ExtentX        =   6694
      _ExtentY        =   5477
      _StockProps     =   101
      BackColor       =   12632256
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         name            =   "MS Sans Serif"
         charset         =   0
         weight          =   700
         size            =   8.25
         underline       =   0   'False
         italic          =   0   'False
         strikethrough   =   0   'False
      EndProperty
      BorderStyle     =   1
      xGrid           =   5
      yGrid           =   5
      Shape           =   0
      FillColor       =   16777215
      DrawColor       =   8421504
      ForeColor       =   0
      DrawWidth       =   1
      Oriented        =   -1  'True
      ReadOnly        =   0   'False
      MultiSel        =   -1  'True
      ScrollBars      =   3
      CanDrawNode     =   -1  'True
      CanDrawLink     =   -1  'True
      CanMoveNode     =   -1  'True
      CanSizeNode     =   -1  'True
      CanStretchLink  =   -1  'True
      CanMultiLink    =   0   'False
      Transparent     =   0   'False
      DrawStyle       =   0
      Alignment       =   7
      ShowGrid        =   0   'False
      LinkHead        =   0
      DoSelChange     =   -1  'True
      DoAddNode       =   -1  'True
      DoAddLink       =   -1  'True
      Hiding          =   0   'False
      ImageFile       =   ""
      DisplayHandles  =   -1  'True
      Zoom            =   100
      AutoSize        =   0
      AutoScroll      =   -1  'True
   End
   Begin VB.PictureBox StatusPicture 
      Align           =   2  'Align Bottom
      BeginProperty Font 
         name            =   "MS Sans Serif"
         charset         =   0
         weight          =   700
         size            =   8.25
         underline       =   0   'False
         italic          =   0   'False
         strikethrough   =   0   'False
      EndProperty
      Height          =   855
      Left            =   0
      ScaleHeight     =   795
      ScaleWidth      =   6165
      TabIndex        =   0
      Top             =   3645
      Width           =   6225
      Begin VB.TextBox TextTag 
         Enabled         =   0   'False
         BeginProperty Font 
            name            =   "MS Sans Serif"
            charset         =   0
            weight          =   700
            size            =   8.25
            underline       =   0   'False
            italic          =   0   'False
            strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   720
         TabIndex        =   6
         Top             =   360
         Width           =   1935
      End
      Begin VB.TextBox TextText 
         Enabled         =   0   'False
         BeginProperty Font 
            name            =   "MS Sans Serif"
            charset         =   0
            weight          =   700
            size            =   8.25
            underline       =   0   'False
            italic          =   0   'False
            strikethrough   =   0   'False
         EndProperty
         Height          =   615
         Left            =   3420
         MultiLine       =   -1  'True
         ScrollBars      =   2  'Vertical
         TabIndex        =   5
         Top             =   60
         Width           =   2355
      End
      Begin VB.Label Label1 
         Caption         =   "Tag:"
         BeginProperty Font 
            name            =   "MS Sans Serif"
            charset         =   0
            weight          =   700
            size            =   8.25
            underline       =   0   'False
            italic          =   0   'False
            strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   180
         TabIndex        =   4
         Top             =   360
         Width           =   495
      End
      Begin VB.Label Label3 
         Caption         =   "Item:"
         BeginProperty Font 
            name            =   "MS Sans Serif"
            charset         =   0
            weight          =   700
            size            =   8.25
            underline       =   0   'False
            italic          =   0   'False
            strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   180
         TabIndex        =   3
         Top             =   60
         Width           =   555
      End
      Begin VB.Label LabelItem 
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            name            =   "MS Sans Serif"
            charset         =   0
            weight          =   700
            size            =   8.25
            underline       =   0   'False
            italic          =   0   'False
            strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   720
         TabIndex        =   2
         Top             =   60
         Width           =   1935
      End
      Begin VB.Label Label2 
         Caption         =   "Text:"
         BeginProperty Font 
            name            =   "MS Sans Serif"
            charset         =   0
            weight          =   700
            size            =   8.25
            underline       =   0   'False
            italic          =   0   'False
            strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   2880
         TabIndex        =   1
         Top             =   60
         Width           =   555
      End
   End
   Begin MSComDlg.CommonDialog CMDialog1 
      Left            =   4740
      Top             =   870
      _Version        =   65536
      _ExtentX        =   847
      _ExtentY        =   847
      _StockProps     =   0
   End
   Begin VB.Menu File 
      Caption         =   "&File"
      Begin VB.Menu NewMenu 
         Caption         =   "&New"
      End
      Begin VB.Menu OpenMenu 
         Caption         =   "&Open..."
      End
      Begin VB.Menu SaveMenu 
         Caption         =   "&Save"
      End
      Begin VB.Menu SaveAsMenu 
         Caption         =   "Save &As..."
      End
      Begin VB.Menu SEPARATOR1 
         Caption         =   "-"
      End
      Begin VB.Menu SaveAsMetafileMenu 
         Caption         =   "Save As &Metafile..."
      End
      Begin VB.Menu SEPARATOR8 
         Caption         =   "-"
      End
      Begin VB.Menu ExitMenu 
         Caption         =   "&Exit"
      End
   End
   Begin VB.Menu EditMenu 
      Caption         =   "&Edit"
      Begin VB.Menu CopyMenu 
         Caption         =   "&Copy clipboard"
      End
      Begin VB.Menu DeleteMenu 
         Caption         =   "&Delete"
      End
      Begin VB.Menu SEPARATOR2 
         Caption         =   "-"
      End
      Begin VB.Menu SelectAllMenu 
         Caption         =   "Select &All"
      End
      Begin VB.Menu SEPARATOR5 
         Caption         =   "-"
      End
      Begin VB.Menu SelectModeMenu 
         Caption         =   "&Select Mode"
      End
      Begin VB.Menu SEPARATOR10 
         Caption         =   "-"
      End
      Begin VB.Menu ZOrderMenu 
         Caption         =   "&ZOrder"
         Begin VB.Menu ZOrderBackMenu 
            Caption         =   "&Back"
            Enabled         =   0   'False
         End
         Begin VB.Menu ZOrderFrontMenu 
            Caption         =   "&Front"
            Enabled         =   0   'False
         End
      End
   End
   Begin VB.Menu DrawMenu 
      Caption         =   "&Draw"
      Begin VB.Menu PropertiesMenu 
         Caption         =   "&Properties..."
      End
   End
   Begin VB.Menu InfoMenu 
      Caption         =   "&Info"
      Begin VB.Menu AboutMenu 
         Caption         =   "&About..."
      End
   End
End
Attribute VB_Name = "Main"
Attribute VB_Creatable = False
Attribute VB_Exposed = False

Option Explicit

Const EXT_NET = "NET"
Const FILTER_NET = "Net Files(*.NET)|*.net|All Files(*.*)|*.*|"
Const EXT_WMF = "WMF"
Const FILTER_WMF = "Wmf Files(*.WMF)|*.wmf|All Files(*.*)|*.*|"

Dim Filename$
Dim wmfFileName$



        





Private Sub AboutMenu_Click()
  About.Show 1
End Sub

Private Sub CopyMenu_Click()
  Net1.CopySel
End Sub

Private Sub DeleteMenu_Click()
  Net1.DeleteSel
End Sub







Private Sub ExitMenu_Click()
  End
End Sub

Private Sub Form_Load()
  Net1.Left = 0
  Net1.Top = 0
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
  QueryUnload (Cancel)
End Sub

Private Sub Form_Resize()
  If WindowState <> 1 And ScaleHeight <> 0 Then
    Net1.Height = ScaleHeight - StatusPicture.Height
    Net1.Width = ScaleWidth
    StatusPicture.Top = Net1.Height
  End If
End Sub

Private Function GetFileName(Ext As String, Filter As String) As String
  Const OFN_OVERWRITEPROMPT = &H2&
  Const OFN_SHOWHELP = &H10&
  Const OFN_CREATEPROMPT = &H2000&

  'Display file open dialog
  CMDialog1.DefaultExt = "NET"
  CMDialog1.Filter = Filter
  CMDialog1.Flags = OFN_OVERWRITEPROMPT Or OFN_SHOWHELP Or OFN_CREATEPROMPT
  CMDialog1.Action = 1

  'Select a file and open it
  GetFileName = CMDialog1.Filename
End Function


Private Sub Net1_AddNode()
  ' Avoid too small nodes
  With Net1
    If .X2 - .X1 < 200 Then .X2 = .X1 + 200
    If .Y2 - .Y1 < 200 Then .Y2 = .Y1 + 200
  End With
End Sub



Private Sub Net1_DblClick()
  PropertiesMenu_Click
End Sub

Private Sub Net1_KeyDown(KeyCode As Integer, Shift As Integer)
  Const KEY_DELETE = &H2E
  If KeyCode = KEY_DELETE Then
    Net1.DeleteSel
  End If
End Sub

Private Sub Net1_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
  Dim area%
  Dim item&

  ' If mouse down don't change the mouse pointer
  Const LEFT_BUTTON = 1
  If (Button And LEFT_BUTTON) > 0 Then
    Exit Sub
  End If
  
  With Net1
    item = .PointedItem
    If item <> 0 Then
      LabelItem.Caption = Str(item)
      TextText.Text = .GetItemText(item)
      TextTag.Text = .GetItemTag(item)
    Else
      LabelItem.Caption = ""
      TextText.Text = ""
      TextTag.Text = ""
    End If
    area = .PointedArea
    Select Case area
    Case 0
      .MousePointer = 8
    Case 1
      .MousePointer = 7
    Case 2
      .MousePointer = 6
    Case 3
      .MousePointer = 9
    Case 5
      .MousePointer = 10
    Case Else
      If .SelectMode = True Then
        .MousePointer = 2
      Else
        .MousePointer = 0
      End If
    End Select
  End With
End Sub

Private Sub Net1_SelChange()
  If Net1.item <> 0 Then
    ZOrderFrontMenu.Enabled = True
    ZOrderBackMenu.Enabled = True
  Else
    ZOrderFrontMenu.Enabled = False
    ZOrderBackMenu.Enabled = False
  End If
End Sub

Private Sub NewMenu_Click()
  Dim Cancel%
  Call QueryUnload(Cancel)
  If Cancel = False Then
    Net1.DeleteAll
    Net1.SetChangedFlag False
  End If
End Sub




Private Sub OpenMenu_Click()
  Dim Cancel%

  Call QueryUnload(Cancel)
  If Cancel = False Then
    Filename = GetFileName(EXT_NET, FILTER_NET)
    If Filename <> "" Then
      Net1.DeleteAll
      MousePointer = 11
      OpenEasyNetFile Net1, Filename
      MousePointer = 0
      Net1.SetChangedFlag False
    End If
  End If
End Sub



Private Sub QueryUnload(Cancel As Integer)
  Dim Msg$, NL$
  Dim Response%

  If Net1.IsChanged Then
    Cancel = False

    ' Message box
    NL = Chr$(10) & Chr$(13)
    If Filename <> "" Then
      Msg = "The diagram in [" & Filename & "] has changed."
      Msg = Msg & NL
    End If
    Msg = Msg & "Do you want to save the changes?"
    Response = MsgBox(Msg, 51, Filename)

    Select Case Response

    ' Yes
    Case 6
      If Filename = "" Then
        'Get the filename to save the file
        Filename = GetFileName(EXT_NET, FILTER_NET)
        'If the user did not specify a file name,
        'cancel the unload; otherwise, save it.
        If Filename = "" Then
          Cancel = True
        Else
          SaveEasyNetFile Net1, Filename
        End If
      Else
        SaveEasyNetFile Net1, Filename
      End If

    ' No
    Case 7

    ' Cancel
    Case 2
      Cancel = True

    End Select
  End If
End Sub




Private Sub PropertiesMenu_Click()
  ItemProp.Show 1
End Sub

Private Sub SaveAsMenu_Click()
  Const OFN_OVERWRITEPROMPT = &H2&
  Const OFN_SHOWHELP = &H10&
  Const OFN_CREATEPROMPT = &H2000&

  'Display file save dialog
  CMDialog1.DefaultExt = EXT_NET
  CMDialog1.Filter = FILTER_NET
  CMDialog1.Flags = OFN_OVERWRITEPROMPT Or OFN_SHOWHELP Or OFN_CREATEPROMPT
  CMDialog1.Filename = Filename
  CMDialog1.DialogTitle = "Save As..."
  CMDialog1.Action = 2

  'Select a file
  Filename = CMDialog1.Filename

  If Filename <> "" Then
    MousePointer = 11
    SaveEasyNetFile Net1, Filename
    MousePointer = 0
    Net1.SetChangedFlag False
  End If
End Sub


Private Sub SaveAsMetafileMenu_Click()
  Const OFN_OVERWRITEPROMPT = &H2&
  Const OFN_SHOWHELP = &H10&
  Const OFN_CREATEPROMPT = &H2000&
  
  'Display file save dialog
  CMDialog1.DefaultExt = EXT_WMF
  CMDialog1.Filter = FILTER_WMF
  CMDialog1.Flags = OFN_OVERWRITEPROMPT Or OFN_SHOWHELP Or OFN_CREATEPROMPT
  CMDialog1.Filename = wmfFileName
  CMDialog1.DialogTitle = "Save As Metafile..."
  CMDialog1.Action = 2

  'Select a file
  wmfFileName = CMDialog1.Filename

  If wmfFileName <> "" Then
    MousePointer = 11
    Net1.SaveImage wmfFileName
    MousePointer = 0
  End If
End Sub

Private Sub SaveMenu_Click()
  If Net1.IsChanged() = True Then
    If Len(Filename) <> 0 Then
      MousePointer = 11
      SaveEasyNetFile Net1, Filename
      MousePointer = 0
      Net1.SetChangedFlag False
    Else
      SaveAsMenu_Click
    End If
  End If
End Sub

Private Sub SelectAllMenu_Click()
  Net1.SelectAll
End Sub

Private Sub SelectModeMenu_Click()
  Net1.SelectMode = Not Net1.SelectMode
  If Net1.SelectMode = True Then
    SelectModeMenu.Checked = True
    Net1.MousePointer = 2
  Else
    SelectModeMenu.Checked = False
    Net1.MousePointer = 0
  End If
End Sub

Private Sub ZOrderBackMenu_Click()
  Net1.ItemZOrder = True
End Sub

Private Sub ZOrderFrontMenu_Click()
  Net1.ItemZOrder = False
End Sub

