unit Demomain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, StdCtrls, DB, DBTables, SqlBuild;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    sbBuildSQL: TSpeedButton;
    SQLBuilder1: TSQLBuilder;
    cbChangeAlias: TCheckBox;
    cbUpdateQueries: TCheckBox;
    cbDeleteQueries: TCheckBox;
    procedure sbBuildSQLClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.sbBuildSQLClick(Sender: TObject);
begin
  {Set SQLBuilder options to match selected options}
  If Not cbChangeAlias.Checked then
    SQLBuilder1.Options := SQLBuilder1.Options-[sbAllowChangeAlias];
  If Not cbUpdateQueries.Checked then
    SQLBuilder1.Options := SQLBuilder1.Options-[sbAllowUpdates];
  If Not cbDeleteQueries.Checked then
    SQLBuilder1.Options := SQLBuilder1.Options-[sbAllowDeletes];

  {Build the query }
  If SQLBuilder1.Execute then
    memo1.lines.Assign(SQLBuilder1.SQL);
end;

end.
