{------------------------------------------------------------------------------}
{- Program    : UTIME2DT.PAS                                                  -}
{- Programmer : Todd Fiske                                                    -}
{-                                                                            -}
{- Purpose    : Convert a unix number of seconds to date and time             -}
{-                                                                            -}
{- Revision   : 02/17/1994 - first version                                    -}
{- History      01/16/1995 - cleaned up for uploading                         -}
{-                                                                            -}
{- Language   : Turbo Pascal 7.0                                              -}
{-                                                                            -}
{------------------------------------------------------------------------------}
program utime2dt;

uses
   dos,
   unixtime;

var
   t : longint;
   d : DateTime;

{------------------------------------------------------------------------------}
{- Seconds to date and time test                                              -}
{------------------------------------------------------------------------------}
begin
   writeln;
   writeln('UnixTime 2 DT');

   if paramcount = 0 then begin
      writeln;
      writeln('utime2dt <timelongint>');
      halt;
   end;

   writeln;
   writeln('Unpacking Unix time longint');

   t := str2int(paramstr(1));
   UnpackUnixTime(t, d);

   writeln;
   writeln('year      : ', d.year  : 4);
   writeln('month     : ', d.month : 4);
   writeln('day       : ', d.day   : 4);
   writeln('hour      : ', d.hour  : 4);
   writeln('minute    : ', d.min   : 4);
   writeln('second    : ', d.sec   : 4);

   writeln;
   writeln('formatted : ', FormatUnixTime(t));
end.

   (**
   writeln;
   PackUnixTime(d, t);
   writeln('repacked  : ', t);

   PackTime(d, t);
   writeln;
   writeln('packed    : ', t);

   assign(f, 'uttest.pas');
   reset(f);
   GetFTime(f, t);
   close(f);

   writeln('today     : ', t);
   **)
