unit Childwn3;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, DBNETCON, DB, DBTables, Grids, DBGrids;

type
  TMDIMultiTable = class(TForm)
    DBGrid1: TDBGrid;
    DBGrid2: TDBGrid;
    DBGrid3: TDBGrid;
    DataSource1: TDataSource;
    Table1: TTable;
    DBNetConnectChild1: TDBNetConnectChild;
    DataSource2: TDataSource;
    Table2: TTable;
    DBNetConnectChild2: TDBNetConnectChild;
    DataSource3: TDataSource;
    Table3: TTable;
    DBNetConnectChild3: TDBNetConnectChild;
    ListBox1: TListBox;
    Label1: TLabel;
    DBNetConnectChild4: TDBNetConnectChild;
    Label2: TLabel;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Table1AfterPost(DataSet: TDataset);
    procedure Table1AfterDelete(DataSet: TDataset);
    procedure DBNetConnectChild1Update(Sender: TObject; Channel: Longint;
      Stamp: TDateTime);
    procedure DBNetConnectChild2Update(Sender: TObject; Channel: Longint;
      Stamp: TDateTime);
    procedure DBNetConnectChild3Update(Sender: TObject; Channel: Longint;
      Stamp: TDateTime);
    procedure Table2AfterDelete(DataSet: TDataset);
    procedure Table2AfterPost(DataSet: TDataset);
    procedure Table3AfterDelete(DataSet: TDataset);
    procedure Table3AfterPost(DataSet: TDataset);
    procedure DBNetConnectChild4Update(Sender: TObject; Channel: Longint;
      Stamp: TDateTime);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  MDIMultiTable: TMDIMultiTable;

implementation

{$R *.DFM}

procedure TMDIMultiTable.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  action := cafree;
end;

procedure TMDIMultiTable.Table1AfterPost(DataSet: TDataset);
begin
  DBNetConnectChild1.SendChange;
end;

procedure TMDIMultiTable.Table1AfterDelete(DataSet: TDataset);
begin
  DBNetConnectChild1.SendChange;
end;

procedure TMDIMultiTable.Table2AfterDelete(DataSet: TDataset);
begin
  DBNetConnectChild2.SendChange;
end;

procedure TMDIMultiTable.Table2AfterPost(DataSet: TDataset);
begin
  DBNetConnectChild2.SendChange;
end;

procedure TMDIMultiTable.Table3AfterDelete(DataSet: TDataset);
begin
  DBNetConnectChild3.SendChange;
end;

procedure TMDIMultiTable.Table3AfterPost(DataSet: TDataset);
begin
  DBNetConnectChild3.SendChange;
end;

procedure TMDIMultiTable.DBNetConnectChild1Update(Sender: TObject;
  Channel: Longint; Stamp: TDateTime);
begin
  Table1.Refresh;
end;

procedure TMDIMultiTable.DBNetConnectChild2Update(Sender: TObject;
  Channel: Longint; Stamp: TDateTime);
begin
  Table2.Refresh;
end;

procedure TMDIMultiTable.DBNetConnectChild3Update(Sender: TObject;
  Channel: Longint; Stamp: TDateTime);
begin
  Table3.Refresh;
end;

procedure TMDIMultiTable.DBNetConnectChild4Update(Sender: TObject; Channel: Longint; Stamp: TDateTime);
var S : String;
begin
  S := Format('CH: %s at %s',[IntTOStr(Channel),TimeToStr(Stamp)]);
  If Listbox1.Items.Count > 100
    then ListBox1.Items.Clear;
  ListBox1.Items.Add(s);
  if ListBox1.Items.Count > 0 then
    ListBox1.ItemIndex := ListBox1.Items.Count-1;
end;

procedure TMDIMultiTable.FormCreate(Sender: TObject);
begin
  Table1.open;
  Table2.Open;
  Table3.Open;
end;

procedure TMDIMultiTable.FormDestroy(Sender: TObject);
begin
  Table1.Close;
  Table2.Close;
  Table3.Close;
end;

end.
