unit Childwin;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, DBNETCON,
  Grids, DBGrids, DB, DBTables;

type
  TMDIHoldings = class(TForm)
    DataSource1: TDataSource;
    Table1: TTable;
    DBGrid1: TDBGrid;
    NCHoldingsChild: TDBNetConnectChild;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Table1AfterPost(DataSet: TDataset);
    procedure Table1AfterDelete(DataSet: TDataset);
    procedure NCHoldingsChildUpdate(Sender: TObject; Channel: Longint;
      Stamp: TDateTime);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

implementation

{$R *.DFM}


procedure TMDIHoldings.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TMDIHoldings.Table1AfterPost(DataSet: TDataset);
begin
  NCHoldingsChild.SendChange;
end;

procedure TMDIHoldings.Table1AfterDelete(DataSet: TDataset);
begin
  NCHoldingsChild.SendChange;
end;

procedure TMDIHoldings.NCHoldingsChildUpdate(Sender: TObject; Channel: Longint;
  Stamp: TDateTime);
begin
  Table1.Refresh;
end;

procedure TMDIHoldings.FormCreate(Sender: TObject);
begin
  Table1.Open;
end;

procedure TMDIHoldings.FormDestroy(Sender: TObject);
begin
  Table1.Close;
end;

end.
