VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "Phone"
Attribute VB_Creatable = False
Attribute VB_Exposed = True
Option Explicit

Public PhoneNumber As String
Public Usage As String
Public ObjectID As Long

Public Function FormattedPhoneNumber() As String
' Return a displayable, fully formatted
'   version of Me

    If Len(PhoneNumber) <= 7 Then
        FormattedPhoneNumber = Format$(PhoneNumber, "000-0000")
    ElseIf Len(PhoneNumber) <= 10 Then
        FormattedPhoneNumber = Format$(PhoneNumber, "(000) 000-0000")
    ElseIf Len(PhoneNumber) = 11 Then
        FormattedPhoneNumber = Format$(PhoneNumber, "0 (000) 000-0000")
    Else
        FormattedPhoneNumber = PhoneNumber
    End If

End Function


Public Function InitializeFromRecordSet(Optional ByVal RecordSet As Variant) As Phone
' Populate my variables from the RecordSet
'   (in support of DBAwareCollection)

    On Local Error Resume Next
    
    PhoneNumber = RecordSet("PhoneNumber")
    Usage = RecordSet("Usage")
    ObjectID = RecordSet("ObjectID")

    Set InitializeFromRecordSet = Me
End Function


Public Function InitializeRecordSet(Optional ByVal RecordSet As Variant) As Long
' Populate the RecordSet with my variables.
'   Do not initialize the ObjectID column.
'   Return any error code encountered.
'   (in support of DBAwareCollection)

    On Local Error GoTo InitializeRecordSet_SetError
    Err = 0
    
    RecordSet("PhoneNumber") = PhoneNumber
    RecordSet("Usage") = Usage
    
    GoTo InitializeRecordSet_SetError

InitializeRecordSet_SetError:
    InitializeRecordSet = Err
    Exit Function
End Function


Public Function NewInstanceOfMyClass() As Phone
' Return a new instance of this class
'   (in support of DBAwareCollection)

    Set NewInstanceOfMyClass = New Phone
End Function


Public Function ObjectType() As String
' Return the type of this Class
'   (in support of DBAwareCollection)
    
    ObjectType = "Phone"
End Function


Public Function TableName() As String
' Return the Table with which this Class is associated
'   (in support of DBAwareCollection)
    
    TableName = "Phones"
End Function

