VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "Company"
Attribute VB_Creatable = False
Attribute VB_Exposed = True
Option Explicit

'Private pvtPersonsCollection As New Persons
Private pvtPersonsCollection As New DBAwareCollection



Public Function TableName() As String
    TableName = "Company"
End Function

Public Function EmptyPersons() As Variant
' Return an emptied Persons collection
'   (handy when wanting to begin processing the Company
'   after having already done some things with it)

    Set pvtPersonsCollection = Nothing
    Set pvtPersonsCollection = New DBAwareCollection

    Set EmptyPersons = Persons()
End Function

Public Function ObjectType() As String
    ObjectType = "Company"
End Function

Public Function Persons(Optional ByVal ObjectID As Variant) As Variant
' Returns a DBAwareCollection of Person objects which are
'   contained by this Company object,
' or
' Returns a Person object whose ObjectID matches the ObjectID
'   parameter.

    Dim tempNewPerson As New Person

' check for need to populate the collection from the database
    If Not pvtPersonsCollection.DatabaseHasBeenReferenced Then
        pvtPersonsCollection.SetDatabaseParameters _
            Database:=CompanyDatabase, _
            OrderByClause:="LastName ASC, FirstName ASC"

        Set pvtPersonsCollection = _
            pvtPersonsCollection.InstantiateFromDatabase( _
                Parent:=Me, _
                SampleObject:=tempNewPerson)
    End If
    
' check for a request for a specific Person
    If Not IsMissing(ObjectID) Then
        Set Persons = pvtPersonsCollection.Item(ObjectID)

' else, return the entire collection
    Else
        Set Persons = pvtPersonsCollection
    End If
End Function
Public Function AddPerson(Optional ByVal Item As Variant, Optional ByVal Parent As Variant) As DBAwareCollection
' Return a Person, added to my pvtPersonsCollection
'   (just a wrapper method for Persons.Add)

    Set AddPerson = Me.Persons.Add( _
        Item:=Item, _
        Parent:=Me)
End Function



Private Sub Class_Initialize()
    Set pvtPersonsCollection = Nothing
End Sub



Public Property Get ObjectID() As Long
    ObjectID = 1
End Property



