VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "Address"
Attribute VB_Creatable = False
Attribute VB_Exposed = True
Option Explicit

Public Line1 As String
Public Line2 As String
Public Line3 As String
Public City As String
Public StateCode As String
Public ZipCode As Long
Public ZipSupplement As Integer
Public ZipExtension As Integer
Public ForeignZipCode As String
Public Status As String
Public Usage As String
Public ObjectID As Long


Public Function TableName() As String
' Return the Table with which this Class is associated
'   (in support of DBAwareCollection)
    
    TableName = "Addresses"
End Function

Public Function FormattedAddress() As String
' Return a displayable, fully formatted
'   version of Me

    Dim ReturnString As String
    
    If Line1 > "" Then
        ReturnString = pvtContatenateWithCRLF( _
                        String1:=ReturnString, _
                        String2:=Line1)
    End If
    
    If Line2 > "" Then
        ReturnString = pvtContatenateWithCRLF( _
                        String1:=ReturnString, _
                        String2:=Line2)
    End If
    
    If Line3 > "" Then
        ReturnString = pvtContatenateWithCRLF( _
                        String1:=ReturnString, _
                        String2:=Line3)
    End If
    
    If City > "" Then
        ReturnString = pvtContatenateWithCRLF( _
                        String1:=ReturnString, _
                        String2:=City) _
                        & ", "
    End If
    
    If StateCode > "" Then
        ReturnString = ReturnString & StateCode
    End If
    
    If ZipCode >= 0 Then
        ReturnString = ReturnString & " " & FormattedZip
    End If
    
    FormattedAddress = ReturnString
End Function

Private Function pvtContatenateWithCRLF(Optional String1 As Variant, Optional String2 As Variant) As String

    Dim ReturnString As String
    
    ReturnString = ""
    
    If Not IsMissing(String1) Then
        ReturnString = String1
        If String1 > "" Then
            ReturnString = ReturnString & vbCrLf
        End If
    End If
    
    If Not IsMissing(String2) Then
        If String2 > "" Then
            ReturnString = ReturnString & String2
        End If
    End If

    pvtContatenateWithCRLF = ReturnString
End Function
Public Function FormattedZip() As String

    Dim ReturnString As String
    
    ReturnString = ""
    
    If ZipCode >= 0 Then
        ReturnString = ReturnString & Format$(ZipCode, "#####")
    End If
    
    If ZipSupplement >= 0 Then
        If ReturnString = "" Then
            ReturnString = Format$(ZipSupplement, "####")
        Else
            ReturnString = ReturnString & "-" & Format$(ZipSupplement, "####")
        End If
    End If
    
    If ZipExtension >= 0 Then
        If ReturnString = "" Then
            ReturnString = Format$(ZipExtension, "##")
        Else
            ReturnString = ReturnString & "-" & Format$(ZipExtension, "##")
        End If
    End If

    FormattedZip = ReturnString
End Function


Private Sub Class_Initialize()
    
    ZipCode = -1
    ZipSupplement = -1
    ZipExtension = -1
    ForeignZipCode = ""
    Status = "Current"
    Usage = "Primary"

End Sub



Public Function ObjectType() As String
' Return the type of this Class
'   (in support of DBAwareCollection)
    
    ObjectType = "Address"
End Function
Public Function InitializeFromRecordSet(Optional ByVal RecordSet As Variant) As Address
' Populate my variables from the RecordSet
'   (in support of DBAwareCollection)

    On Local Error Resume Next
    
    Line1 = RecordSet("Line1")
    Line2 = RecordSet("Line2")
    Line3 = RecordSet("Line3")
    City = RecordSet("City")
    StateCode = RecordSet("StateCode")
    ZipCode = RecordSet("ZipCode")
    ZipSupplement = RecordSet("ZipSupplement")
    ZipExtension = RecordSet("ZipExtension")
    ForeignZipCode = RecordSet("ForeignZipCode")
    Status = RecordSet("Status")
    Usage = RecordSet("Usage")
    ObjectID = RecordSet("ObjectID")

    Set InitializeFromRecordSet = Me
End Function

Public Function NewInstanceOfMyClass() As Address
' Return a new instance of this class
'   (in support of DBAwareCollection)

    Set NewInstanceOfMyClass = New Address
End Function



Public Function InitializeRecordSet(Optional ByVal RecordSet As Variant) As Long
' Populate the RecordSet with my variables.
'   Do not initialize the ObjectID column.
'   Return any error code encountered.
'   (in support of DBAwareCollection)

    On Local Error GoTo InitializeRecordSet_SetError
    Err = 0
    
    RecordSet("Line1") = Line1
    RecordSet("Line2") = Line2
    RecordSet("Line3") = Line3
    RecordSet("City") = City
    RecordSet("StateCode") = StateCode
    RecordSet("ZipCode") = ZipCode
    RecordSet("ZipSupplement") = ZipSupplement
    RecordSet("ZipExtension") = ZipExtension
    RecordSet("ForeignZipCode") = ForeignZipCode
    RecordSet("Status") = Status
    RecordSet("Usage") = Usage
    
    GoTo InitializeRecordSet_SetError

InitializeRecordSet_SetError:
    InitializeRecordSet = Err
    Exit Function
End Function


