Option Explicit
'***************************************************************
'*   Name of File:      STATBAR.BAS                            *
'*   Author:            M. John Rodriguez                      *
'*   Date Created:      May 07, 1995                           *
'*   Last Modified:     Aug 18, 1995                           *
'*   Current Version:   3.00.00                                *
'***************************************************************
'   Questions or Comments are welcome!
'   M. John Rodriguez
'     CIS ID: 100321,620
'   Internet: jrodrigu@cpd.hqusareur.army.mil
'           : 100321.620@compuserve.com
'
'   See the README.TXT file for more information or just look through the code!
'
Type RECT
    Left As Integer
    Top As Integer
    Right As Integer
    Bottom As Integer
End Type

Type PanelStyleType
    iLeft As Integer            'Left Position of the panel
    iTop As Integer             'Top position of the panel
    iWidth As Integer           'Width of the panel
    iHeight As Integer          'Height of the Panel
    iBorderStyle As Integer            'Type of panel 0-Recessed, 1-Raised, 2-Flat: User Defined
    iFormat As Integer          'Format of the panel - Text, Date, Time, etc...: User Defined
    iTextFormat As Integer      'Format of Text in the panel VCENTER, CENTER, etc.: User Defined
    iOther As Integer           'Used for Icon Information or Percentage in the Meter Bar
    lOther As Long              'User for color of the meter bar or whatever else needs to be used
End Type

Type PanelType
    sCaption As String          'Caption contained in the panel
    PanelStyle As PanelStyleType 'Panel Information
    iFontBold As Integer        'Whether or not font is bold
    iFont3D As Integer          'Whether or not font is 3D
    sFontName As String         'Font Name - Defaults to statusbar setting
    sFontSize As String         'Font Size - Defaults to statusbar setting
    lFontColor As Long          'Font Color - Defaults to statusbar setting
    bVisible As Integer         'Let's you hide or show any panel you wish
End Type

Type DrawProperties
    lBackColor As Long
    iDrawMode As Integer
    iDrawStyle As Integer
    iDrawWidth As Integer
    lFillColor As Long
    iFillStyle As Integer
    bFontBold As Integer
    bFontItalic As Integer
    sFontName As String * 30
    sFontSize As String * 10
    bFontStrikeThru As Integer
    bFontTransparent As Integer
    bFontUnderline As Integer
    lForeColor As Long
    iScaleMode As Integer
End Type


'Constants for the DrawText API call
Global Const DT_TOP = &H0
Global Const DT_LEFT = &H0
Global Const DT_CENTER = &H1
Global Const DT_RIGHT = &H2
Global Const DT_VCENTER = &H4
Global Const DT_BOTTOM = &H8
Global Const DT_WORDBREAK = &H10
Global Const DT_SINGLELINE = &H20
Global Const DT_EXPANDTABS = &H40
Global Const DT_TABSTOP = &H80
Global Const DT_NOCLIP = &H100
Global Const DT_EXTERNALLEADING = &H200
Global Const DT_CALCRECT = &H400
Global Const DT_NOPREFIX = &H800
Global Const DT_INTERNAL = &H1000

'Types of panels
Global Const SBAR_PANEL_RECESSED = 0
Global Const SBAR_PANEL_RAISED = 1
Global Const SBAR_PANEL_FLAT = 2

'Format of the panels
Global Const SBAR_TEXT = 0            'Panel just contains text
Global Const SBAR_DATE = 1            'Panel contains the date
Global Const SBAR_TIME = 2            'Panel contains the time
Global Const SBAR_WEEKDAY = 3         'Panel contains the weekday
Global Const SBAR_FULLDATE = 4        'Panel Shows date as Tuesday Jan 1, 1995
Global Const SBAR_CAPSLOCK = 5        'Panel is a CAPLOCK toggle display
Global Const SBAR_NUMLOCK = 6         'Panel is a NUMLOCK toggle display
Global Const SBAR_SCROLL = 7          'Panel is a SCROLL LOCK toggle display
Global Const SBAR_COUNTER = 8         'Panel is a counter display
Global Const SBAR_FIXEDTEXT = 9       'Panel contains a fixed text
Global Const SBAR_MINICON = 10        'Panel is a miniature icon display
Global Const SBAR_ICONMIX = 11        'Panel is a miniature icon/text display
Global Const SBAR_BUTTON = 12         'Panel will emulate a button and fire and event when clicked
Global Const SBAR_METER = 13          'Panel is a meter control that displays progress


'Specific information for drawing the panels
Global Const SBAR_BORDERSIZE = 3      'Space between StatusBar borders and panels in pixels
Global Const SBAR_PANELGAP = 4        'Gap between panels
Global Const SBAR_TEXTGAP = 1         'Gap in between the text and the border in pixels
Global Const SBAR_METERWIDTH = 100    'Width in pixels of the Meter panel

'Some colors
Global Const SBAR_WHITEBORDER = &HFFFFFF    'For 3D Effect - White Bar
Global Const SBAR_DGREYBORDER = &H808080    'For 3D Effect - Drk Grey Bar
Global Const SBAR_BACKGROUND = &HC0C0C0     'Color to paint the picture box
Global Const SBAR_FONTCOLOR = &H0           'Black forecolor to draw text

'Virtual Keys definitions for the GetKeyState API
Global Const KEY_NUMLOCK = &H90
Global Const KEY_SCROLL = &H91
Global Const KEY_CAPITAL = &H14     'Caplocks Key

Declare Function GetKeyState Lib "User" (ByVal nVirtKey As Integer) As Integer
Declare Function DrawText Lib "User" (ByVal hDC As Integer, ByVal lpStr As String, ByVal nCount As Integer, lpRect As RECT, ByVal wFormat As Integer) As Integer
Declare Function BitBlt Lib "GDI" (ByVal hDestDC As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal hSrcDC As Integer, ByVal XSrc As Integer, ByVal YSrc As Integer, ByVal dwRop As Long) As Integer

Global Const SRCCOPY = &HCC0020     ' (DWORD) dest = source
Global Const SRCPAINT = &HEE0086    ' (DWORD) dest = source OR dest
Global Const SRCAND = &H8800C6      ' (DWORD) dest = source AND dest
Global Const SRCINVERT = &H660046   ' (DWORD) dest = source XOR dest
Global Const SRCERASE = &H440328    ' (DWORD) dest = source AND (NOT dest )
Global Const NOTSRCCOPY = &H330008  ' (DWORD) dest = (NOT source)
Global Const NOTSRCERASE = &H1100A6 ' (DWORD) dest = (NOT src) AND (NOT dest)
Global Const MERGECOPY = &HC000CA   ' (DWORD) dest = (source AND pattern)
Global Const MERGEPAINT = &HBB0226  ' (DWORD) dest = (NOT source) OR dest
Global Const PATCOPY = &HF00021     ' (DWORD) dest = pattern
Global Const PATPAINT = &HFB0A09    ' (DWORD) dest = DPSnoo
Global Const PATINVERT = &H5A0049   ' (DWORD) dest = pattern XOR dest
Global Const DSTINVERT = &H550009   ' (DWORD) dest = (NOT dest)
Global Const BLACKNESS = &H42&      ' (DWORD) dest = BLACK
Global Const WHITENESS = &HFF0062   ' (DWORD) dest = WHITE

'Sub CreatePanels ()

'Use this procedure to create the panels you want...
'Call it from the Form_Load() Event...
'For use in multiple forms, cut and paste this into the general declarations section of
'each form.  See the README.TXT file for more information.

'Dim iMaxPanels%

'iMaxPanels% = 3

'ReDim sb_panels(iMaxPanels%)

'sb_panels(1).PanelStyle.iBorderStyle = SBAR_PANEL_RAISED
'sb_panels(1).PanelStyle.iFormat = SBAR_TEXT
'sb_panels(1).sFontName =
'sb_panels(1).sFontSize =
'sb_panels(1).lFontColor =
'sb_panels(1).iFont3D = True
'sb_panels(1).iFontBold = True

'sb_panels(2).PanelStyle.iBorderStyle = SBAR_PANEL_RAISED
'sb_panels(2).PanelStyle.iFormat = SBAR_DATE
'sb_panels(2).sFontName = "Courier New"
'sb_panels(2).sFontSize = "6.0"
'sb_panels(2).lFontColor = &HFF
'sb_panels(2).iFont3D = True
'sb_panels(2).iFontBold = True

'sb_panels(3).PanelStyle.iBorderStyle = SBAR_PANEL_RAISED
'sb_panels(3).PanelStyle.iFormat = SBAR_TIME
'sb_panels(3).sFontName = "Courier New"
'sb_panels(3).sFontSize = "6.0"
'sb_panels(3).lFontColor = &HFF
'sb_panels(3).iFont3D = True
'sb_panels(3).iFontBold = True

'End Sub

Sub ButtonClick (uPanel As PanelType)

'Here is where you process the code for the button clicks...

MsgBox "User clicked " + uPanel.sCaption, 0, "Status Bar Demo"


End Sub

Sub DisplayStatusBar (ctrlStatusBar As Control, puPanels() As PanelType)

'You call this from the PictureBox's Resize Event to redisplay the status bar after adjustments

Dim iCnt%, sTest$, iNumTextPanels%
Dim iMaxPanels%, iPTextWidth%
Dim iLeftPos%
Dim iNewWidth%, iLeftOverSpace%
Dim sbarRECT As RECT
Dim uProps As DrawProperties

'Turn of the status timer for now...
ctrlStatusBar.Parent.StatTimer.Enabled = False

SaveControlProperties ctrlStatusBar, uProps

'Clear the status bar
ctrlStatusBar.AutoRedraw = True
ctrlStatusBar.Cls

Make3DStatusBar ctrlStatusBar

'Find out how many panels we got..
iMaxPanels% = UBound(puPanels)

'Calculate how much space we have to work with
iLeftOverSpace% = ctrlStatusBar.ScaleWidth - ((SBAR_BORDERSIZE * 2) + ((iMaxPanels% - 1) * SBAR_PANELGAP))

'Let's got through each panel
For iCnt% = 1 To iMaxPanels%
    If puPanels(iCnt%).bVisible Then
	'Clear the test variable
	sTest$ = ""
	'Now let's set up a test strings to format the panel widths
	Select Case puPanels(iCnt%).PanelStyle.iFormat
	    Case SBAR_DATE        'Format for the Date Panel
		sTest$ = " XX/XX/XXXX "
	    Case SBAR_TIME        'Format for the Time Panel
		sTest$ = " XX:XX xx "
	    Case SBAR_FULLDATE
		sTest$ = " XXXXXXXXX, XXX XX, XXXX "
	    Case SBAR_WEEKDAY     'Format for the WeekDay Panel
		sTest$ = " XXXXXXXXX "
	    Case SBAR_CAPSLOCK    'Format for the Capslock Panel
		sTest$ = " CAP "
	    Case SBAR_NUMLOCK     'Format for the NumLock Panel
		sTest$ = " NUM "
	    Case SBAR_SCROLL      'Format for the ScrollLock Panel
		sTest$ = " SCR "
	    Case SBAR_COUNTER     'Format for the Counter type panel
		sTest$ = " " + String$(puPanels(iCnt%).PanelStyle.iOther, "X") + " "
	    Case SBAR_TEXT, SBAR_ICONMIX   'Increment the number of text panels we have
		iNumTextPanels% = iNumTextPanels% + 1
	    Case SBAR_FIXEDTEXT, SBAR_BUTTON
		sTest$ = " " + puPanels(iCnt%).sCaption + " "
	    Case SBAR_MINICON
		puPanels(iCnt%).PanelStyle.iWidth = 24
		iLeftOverSpace% = iLeftOverSpace% - 24
	    Case SBAR_METER
		puPanels(iCnt%).PanelStyle.iWidth = SBAR_METERWIDTH + 2
		iLeftOverSpace% = iLeftOverSpace% - puPanels(iCnt%).PanelStyle.iWidth
	End Select
	'Do we have a test string?
	If sTest$ <> "" Then
	    'Alright, now copy the font information to the StatusBar
	    ctrlStatusBar.FontName = puPanels(iCnt%).sFontName
	    ctrlStatusBar.FontSize = puPanels(iCnt%).sFontSize
	    ctrlStatusBar.FontBold = puPanels(iCnt%).iFontBold
	    'Let's get a width for the Label control plus the Text Gap
	    iNewWidth% = ctrlStatusBar.TextWidth(sTest$) + (SBAR_TEXTGAP * 2)
	    'Set the width of the panel
	    puPanels(iCnt%).PanelStyle.iWidth = iNewWidth%
	    'Deduct the width from the left over spaces
	    iLeftOverSpace% = iLeftOverSpace% - iNewWidth%
	End If
    End If
Next

ctrlStatusBar.AutoRedraw = False
RestoreControlProperties ctrlStatusBar, uProps

'Calculate the space left over for all SBAR_TEXT types
iPTextWidth% = 0
If iNumTextPanels% > 0 Then
    If iLeftOverSpace% > 0 Then iPTextWidth% = iLeftOverSpace% \ iNumTextPanels%
End If

'OK, now set our starting position to place our panels.
iLeftPos% = SBAR_BORDERSIZE

For iCnt% = 1 To iMaxPanels%
    If puPanels(iCnt%).bVisible Then
	'If this panel is SBAR_TEXT then set the width from our calculations
	If puPanels(iCnt%).PanelStyle.iFormat = SBAR_TEXT Or puPanels(iCnt%).PanelStyle.iFormat = SBAR_ICONMIX Then puPanels(iCnt%).PanelStyle.iWidth = iPTextWidth%
	'If the control has any width...
	If puPanels(iCnt%).PanelStyle.iWidth > 0 Then
	    'Set the panels left position to be drawn...
	    puPanels(iCnt%).PanelStyle.iLeft = iLeftPos%
	    'Now draw the panel
	    DrawStatusPanel ctrlStatusBar, puPanels(iCnt%)
	    'Increment to our next position
	    iLeftPos% = iLeftPos% + puPanels(iCnt%).PanelStyle.iWidth + SBAR_PANELGAP
	End If
    End If
Next

'Reactivate the timer...
ctrlStatusBar.Parent.StatTimer.Enabled = True

End Sub

Sub DrawBorder (ctrlStatusBar As Control, puRect As RECT, ByVal piStyle%)

Dim lColorLTBorder&, lColorRBBorder&

'Ok, depending on the type of panel, set the border colors
If piStyle% = SBAR_PANEL_FLAT Then
    lColorLTBorder& = ctrlStatusBar.BackColor
    lColorRBBorder& = ctrlStatusBar.BackColor
ElseIf piStyle% = SBAR_PANEL_RAISED Then
    lColorLTBorder& = SBAR_WHITEBORDER
    lColorRBBorder& = SBAR_DGREYBORDER
Else
    lColorLTBorder& = SBAR_DGREYBORDER
    lColorRBBorder& = SBAR_WHITEBORDER
End If

'Now Draw the lines around the box area...
'Top
ctrlStatusBar.Line (puRect.Left, puRect.Top)-(puRect.Right, puRect.Top), lColorLTBorder&
'Left
ctrlStatusBar.Line (puRect.Left, puRect.Top)-(puRect.Left, puRect.Bottom), lColorLTBorder&
'Bottom
ctrlStatusBar.Line (puRect.Left, puRect.Bottom)-(puRect.Right, puRect.Bottom), lColorRBBorder&
'Right
ctrlStatusBar.Line (puRect.Right, puRect.Top)-(puRect.Right, puRect.Bottom), lColorRBBorder&

End Sub

Sub DrawStatusPanel (ctrlStatusBar As Control, puPanel As PanelType)

'This draws the panel with the caption.

Dim pRect As RECT, tRect As RECT, offsetRect As RECT, iconRect As RECT
Dim bSuc%, uProps As DrawProperties
Dim ctrlIcons As Control, iXPos%

If Not puPanel.bVisible Then Exit Sub

SaveControlProperties ctrlStatusBar, uProps

Set ctrlIcons = ctrlStatusBar.Parent.sbar_pics

'Set some of the properties now...
ctrlStatusBar.AutoRedraw = True
ctrlStatusBar.DrawWidth = 1
ctrlStatusBar.ForeColor = SBAR_FONTCOLOR

'Calculate the drawing box rectangle
pRect.Left = puPanel.PanelStyle.iLeft
pRect.Top = puPanel.PanelStyle.iTop
pRect.Right = pRect.Left + puPanel.PanelStyle.iWidth
pRect.Bottom = pRect.Top + puPanel.PanelStyle.iHeight

'Clear the drawing region of where the panel will be placed
ctrlStatusBar.Line (pRect.Left, pRect.Top)-(pRect.Right, pRect.Bottom), ctrlStatusBar.BackColor, BF

DrawBorder ctrlStatusBar, pRect, puPanel.PanelStyle.iBorderStyle
'Now we need to determine what kind of panel this is and draw it on the screen..
Select Case puPanel.PanelStyle.iFormat
    Case SBAR_MINICON
	'This is just a 16 x 16 bitmap that we use to show in it's place...
	'The iconRECT holds the position of the iCon
	iconRect.Left = pRect.Left + 4
	iconRect.Right = pRect.Left + 16
	iconRect.Top = ((pRect.Bottom - pRect.Top - 16) / 2) + pRect.Top
	iconRect.Bottom = pRect.Top + 16
	'Ok. now its time to draw the icon in place..
	If puPanel.PanelStyle.iOther > 0 Then
	    iXPos% = (puPanel.PanelStyle.iOther * 16) - 16
	    bSuc% = BitBlt(ctrlStatusBar.hDC, iconRect.Left, iconRect.Top, 16, 16, ctrlIcons.hDC, iXPos%, 0, SRCCOPY)
	End If
	'Thats it.. we are finished..
	GoTo DrawStatusPanel_Exit
    Case SBAR_ICONMIX
	If puPanel.PanelStyle.iWidth > 26 Then
	    iconRect.Left = pRect.Left + 4
	    iconRect.Right = pRect.Left + 16
	    iconRect.Top = ((pRect.Bottom - pRect.Top - 16) / 2) + pRect.Top
	    iconRect.Bottom = pRect.Top + 16
	    If puPanel.PanelStyle.iOther > 0 Then
		iXPos% = (puPanel.PanelStyle.iOther * 16) - 16
		bSuc% = BitBlt(ctrlStatusBar.hDC, iconRect.Left, iconRect.Top, 16, 16, ctrlIcons.hDC, iXPos%, 0, SRCCOPY)
	    End If
	    tRect.Left = iconRect.Right + 6
	    tRect.Top = pRect.Top + 1
	    tRect.Right = pRect.Right - 1
	    tRect.Bottom = pRect.Bottom - 1
	End If
    Case Else
	'Calculate the textbox rectangle - 1 pixel less than the rectangle..
	tRect.Left = pRect.Left + 2
	tRect.Top = pRect.Top + 1
	tRect.Right = pRect.Right - 2
	tRect.Bottom = pRect.Bottom - 1
	If puPanel.PanelStyle.iFormat = SBAR_BUTTON And puPanel.PanelStyle.iBorderStyle = SBAR_PANEL_RECESSED Then
	    'If this is a button and it is recessed, move the text over and down a pixel
	    'to give the illusion of a button depressing.
	    tRect.Left = tRect.Left + 1
	    tRect.Top = tRect.Top + 1
	    tRect.Right = tRect.Right + 1
	    tRect.Bottom = tRect.Bottom + 1
	End If
End Select

If puPanel.PanelStyle.iFormat = SBAR_METER Then
    'This just draws the meter for the panel..
    If puPanel.PanelStyle.iOther > 0 Then ctrlStatusBar.Line (pRect.Left + 1, pRect.Top + 1)-(pRect.Left + 1 + (SBAR_METERWIDTH * (puPanel.PanelStyle.iOther / 100)), pRect.Bottom - 1), puPanel.PanelStyle.lOther, BF
End If

'Change the scale mode one last time..
ctrlStatusBar.FontBold = puPanel.iFontBold
ctrlStatusBar.FontName = puPanel.sFontName
ctrlStatusBar.FontSize = puPanel.sFontSize

'Now if this is 3D
If puPanel.iFont3D Then
    'Set the offset by 1 pixel
    offsetRect.Left = tRect.Left + 1
    offsetRect.Top = tRect.Top + 1
    offsetRect.Right = tRect.Right + 1
    offsetRect.Bottom = tRect.Bottom + 1
    'Set the forecolor to white
    ctrlStatusBar.ForeColor = SBAR_WHITEBORDER
    'Draw the text
    bSuc% = DrawText(ctrlStatusBar.hDC, puPanel.sCaption, Len(puPanel.sCaption), offsetRect, puPanel.PanelStyle.iTextFormat)
End If

'Now draw the Caption...setting the ForeColor of the Status Bar
ctrlStatusBar.ForeColor = puPanel.lFontColor
'Draw the text
bSuc% = DrawText(ctrlStatusBar.hDC, puPanel.sCaption, Len(puPanel.sCaption), tRect, puPanel.PanelStyle.iTextFormat)

DrawStatusPanel_Exit:
ctrlStatusBar.AutoRedraw = False
'And now reset the Status Bar Settings..
RestoreControlProperties ctrlStatusBar, uProps

End Sub

Sub FlashMessage (ctrlStatusBar As Control, psCaption$)

'Function flashes a message in the Status bar by erasing the status bar and showing the information
Dim tRect As RECT, bSuc%

ctrlStatusBar.Parent.StatTimer.Enabled = False

tRect.Left = SBAR_BORDERSIZE
tRect.Top = SBAR_BORDERSIZE
tRect.Right = ctrlStatusBar.ScaleWidth - SBAR_BORDERSIZE
tRect.Bottom = ctrlStatusBar.ScaleHeight - SBAR_BORDERSIZE

ctrlStatusBar.AutoRedraw = True
ctrlStatusBar.Cls

Make3DStatusBar ctrlStatusBar

DrawBorder ctrlStatusBar, tRect, SBAR_PANEL_RECESSED
'Now draw the text..
tRect.Left = tRect.Left + 2
tRect.Top = tRect.Top + 1
tRect.Right = tRect.Right - 1
tRect.Bottom = tRect.Bottom - 1

bSuc% = DrawText(ctrlStatusBar.hDC, psCaption$, Len(psCaption$), tRect, DT_LEFT Or DT_VCENTER Or DT_SINGLELINE)

ctrlStatusBar.AutoRedraw = True


End Sub

Function InitializeStatusBar (frmWin As Form, puPanels() As PanelType) As Integer

'Use this procedure to initialize the Status bar.. call it from the Form_Load() Event
Dim iMaxHeight%, iCnt%
Dim iMaxPanels%, iMaxPanelHeight%
Dim iAlignCenter%, iAlignLeft%, iAlignRight%
Dim iOldScaleMode%

On Local Error Resume Next

'Find the number of panels to be passed
iMaxPanels% = UBound(puPanels)

'Do we have any panels?
If iMaxPanels% > 0 Then
    'Set up some basic settings for the format of panel text
    iAlignCenter% = DT_VCENTER Or DT_CENTER Or DT_SINGLELINE
    iAlignLeft% = DT_VCENTER Or DT_LEFT Or DT_SINGLELINE
    iAlignRight% = DT_VCENTER Or DT_RIGHT Or DT_SINGLELINE
    
    iOldScaleMode% = frmWin.ScaleMode
    frmWin.ScaleMode = 3

    'Set the color of the background for the picture box
    frmWin.StatusBar.BackColor = SBAR_BACKGROUND
    'Set the alignment of the picture box
    frmWin.StatusBar.Align = 2
    'Change the settings to Pixel
    frmWin.StatusBar.ScaleMode = 3
    'Set the border style to none... we will take cate of the border style ourselves..
    'frmWin.StatusBar.BorderStyle = 0
    'Set the max height to the tallest text +
    'the border above and below the panel + gap between border
    'and text and include the line around the picture control
    iMaxPanelHeight% = SetMaxHeight(frmWin.StatusBar, puPanels())
    iMaxHeight% = iMaxPanelHeight% + (SBAR_BORDERSIZE * 2) + (SBAR_TEXTGAP * 2)

    'Now set the height of the Status Bar
    frmWin.StatusBar.Height = iMaxHeight%
    'And reset the max panel height after adjusting to the new status bar height.
    iMaxPanelHeight% = frmWin.StatusBar.ScaleHeight - (SBAR_BORDERSIZE * 2)
    
    frmWin.ScaleMode = iOldScaleMode%

    'Now go through each panel and set the height of each panel the same
    'As well as a few other things...
    For iCnt% = 1 To iMaxPanels%
	puPanels(iCnt%).PanelStyle.iTop = SBAR_BORDERSIZE
	puPanels(iCnt%).PanelStyle.iHeight = iMaxPanelHeight%
	Select Case puPanels(iCnt%).PanelStyle.iFormat
	    Case SBAR_TEXT, SBAR_ICONMIX, SBAR_FIXEDTEXT
		puPanels(iCnt%).PanelStyle.iTextFormat = iAlignLeft%
	    Case SBAR_COUNTER
		puPanels(iCnt%).PanelStyle.iTextFormat = iAlignRight%
	    Case SBAR_METER
		puPanels(iCnt%).lFontColor = 0&
		puPanels(iCnt%).PanelStyle.iTextFormat = iAlignCenter%
	    Case SBAR_BUTTON
		puPanels(iCnt%).PanelStyle.iBorderStyle = SBAR_PANEL_RAISED
		puPanels(iCnt%).PanelStyle.iTextFormat = iAlignCenter%
	    Case Else
		puPanels(iCnt%).PanelStyle.iTextFormat = iAlignCenter%
	End Select
	If puPanels(iCnt%).sFontName = "" Then puPanels(iCnt%).sFontName = frmWin.StatusBar.FontName
	If puPanels(iCnt%).sFontSize = "" Then puPanels(iCnt%).sFontSize = frmWin.StatusBar.FontSize
    Next
    DisplayStatusBar frmWin.StatusBar, puPanels()

Else
    frmWin.StatusBar.Visible = False
End If

End Function

Sub Make3DStatusBar (ctrlStatusBar As Control)

Dim sbarRECT As RECT

'Now we need to display the status bar as raised.
sbarRECT.Left = 0
sbarRECT.Top = 0
sbarRECT.Right = ctrlStatusBar.ScaleWidth - 1
sbarRECT.Bottom = ctrlStatusBar.ScaleHeight - 1
'Draw top line
ctrlStatusBar.Line (sbarRECT.Left, sbarRECT.Top)-(sbarRECT.Right, sbarRECT.Top), SBAR_WHITEBORDER
'Draw Left Line
ctrlStatusBar.Line (sbarRECT.Left, sbarRECT.Top)-(sbarRECT.Left, sbarRECT.Bottom), SBAR_WHITEBORDER
'Draw bottom line
ctrlStatusBar.Line (sbarRECT.Left, sbarRECT.Bottom)-(sbarRECT.Right, sbarRECT.Bottom), SBAR_DGREYBORDER
'Draw Right Line
ctrlStatusBar.Line (sbarRECT.Right, sbarRECT.Top)-(sbarRECT.Right, sbarRECT.Bottom), SBAR_DGREYBORDER


End Sub

Sub RestoreControlProperties (ctrlControl As Control, puProperties As DrawProperties)

'ctrlControl.BackColor = puProperties.lBackColor
'ctrlControl.DrawMode = puProperties.iDrawMode
'ctrlControl.DrawStyle = puProperties.iDrawStyle
'ctrlControl.DrawWidth = puProperties.iDrawWidth
'ctrlControl.FillColor = puProperties.lFillColor
'ctrlControl.FillStyle = puProperties.iFillStyle
ctrlControl.FontBold = puProperties.bFontBold
ctrlControl.FontItalic = puProperties.bFontItalic
ctrlControl.FontName = Trim$(puProperties.sFontName)
ctrlControl.FontSize = Trim$(puProperties.sFontSize)
ctrlControl.FontStrikethru = puProperties.bFontStrikeThru
ctrlControl.FontUnderline = puProperties.bFontUnderline
ctrlControl.ForeColor = puProperties.lForeColor
'ctrlControl.ScaleMode = puProperties.iScaleMode

End Sub

Sub RestoreFormProperties (frmForm As Form, puProperties As DrawProperties)

'frmForm.BackColor = puProperties.lBackColor
'frmForm.DrawMode = puProperties.iDrawMode
'frmForm.DrawStyle = puProperties.iDrawStyle
'frmForm.DrawWidth = puProperties.iDrawWidth
'frmForm.FillColor = puProperties.lFillColor
'frmForm.FillStyle = puProperties.iFillStyle
frmForm.FontBold = puProperties.bFontBold
frmForm.FontItalic = puProperties.bFontItalic
frmForm.FontName = Trim$(puProperties.sFontName)
frmForm.FontSize = Trim$(puProperties.sFontSize)
frmForm.FontStrikethru = puProperties.bFontStrikeThru
frmForm.FontUnderline = puProperties.bFontUnderline
frmForm.ForeColor = puProperties.lForeColor
'frmForm.ScaleMode = puProperties.iScaleMode

End Sub

Sub SaveControlProperties (ctrlControl As Control, puProperties As DrawProperties)

'puProperties.lBackColor = ctrlControl.BackColor
'puProperties.iDrawMode = ctrlControl.DrawMode
'puProperties.iDrawStyle = ctrlControl.DrawStyle
'puProperties.iDrawWidth = ctrlControl.DrawWidth
'puProperties.lFillColor = ctrlControl.FillColor
'puProperties.iFillStyle = ctrlControl.FillStyle
puProperties.bFontBold = ctrlControl.FontBold
puProperties.bFontItalic = ctrlControl.FontItalic
puProperties.sFontName = ctrlControl.FontName
puProperties.sFontSize = ctrlControl.FontSize
puProperties.bFontStrikeThru = ctrlControl.FontStrikethru
puProperties.bFontUnderline = ctrlControl.FontUnderline
puProperties.lForeColor = ctrlControl.ForeColor
'puProperties.iScaleMode = ctrlControl.ScaleMode


End Sub

Sub SaveFormProperties (frmForm As Form, puProperties As DrawProperties)

puProperties.lBackColor = frmForm.BackColor
puProperties.iDrawMode = frmForm.DrawMode
puProperties.iDrawStyle = frmForm.DrawStyle
puProperties.iDrawWidth = frmForm.DrawWidth
puProperties.lFillColor = frmForm.FillColor
puProperties.iFillStyle = frmForm.FillStyle
puProperties.bFontBold = frmForm.FontBold
puProperties.bFontItalic = frmForm.FontItalic
puProperties.sFontName = frmForm.FontName
puProperties.sFontSize = frmForm.FontSize
puProperties.bFontStrikeThru = frmForm.FontStrikethru
puProperties.bFontUnderline = frmForm.FontUnderline
puProperties.lForeColor = frmForm.ForeColor
puProperties.iScaleMode = frmForm.ScaleMode

End Sub

Sub SBarMouseDown (ctrlStatusBar As Control, piButton%, piShift%, pnXPos!, pnYPos!, puPanels() As PanelType)

Dim iXPos%, iYPos%, iCnt%, iGotit%
Dim drawRect As RECT

If piButton% = 1 Then
    iXPos% = pnXPos!
    iYPos% = pnYPos!
    For iCnt% = 1 To UBound(puPanels)
	If puPanels(iCnt%).PanelStyle.iFormat = SBAR_BUTTON Then
	    drawRect.Left = puPanels(iCnt%).PanelStyle.iLeft
	    drawRect.Right = drawRect.Left + puPanels(iCnt%).PanelStyle.iWidth
	    drawRect.Top = puPanels(iCnt%).PanelStyle.iTop
	    drawRect.Bottom = drawRect.Top + puPanels(iCnt%).PanelStyle.iHeight

	    If (iXPos% > drawRect.Left) And (iXPos% < drawRect.Right) Then
		If (iYPos% > drawRect.Top) And (iYPos% < drawRect.Bottom) Then
		    iGotit% = iCnt%
		    puPanels(iCnt%).PanelStyle.iBorderStyle = SBAR_PANEL_RECESSED
		End If
	    End If
	    If (iGotit% = 0) And (puPanels(iCnt%).PanelStyle.iBorderStyle = SBAR_PANEL_RECESSED) Then
		puPanels(iCnt%).PanelStyle.iBorderStyle = SBAR_PANEL_RAISED
		DrawStatusPanel ctrlStatusBar, puPanels(iCnt%)
	    End If
	End If
    Next
    If iGotit% Then DrawStatusPanel ctrlStatusBar, puPanels(iGotit%)
End If

End Sub

Sub SBarMouseUp (ctrlStatusBar As Control, piButton%, piShift%, pnXPos!, pnYPos!, puPanels() As PanelType)

Dim iXPos%, iYPos%, iCnt%, iGotit%
Dim drawRect As RECT

If piButton% = 1 Then
    iXPos% = pnXPos!
    iYPos% = pnYPos!
    For iCnt% = 1 To UBound(puPanels)
	If puPanels(iCnt%).PanelStyle.iFormat = SBAR_BUTTON Then
	    puPanels(iCnt%).PanelStyle.iBorderStyle = SBAR_PANEL_RAISED
	    DrawStatusPanel ctrlStatusBar, puPanels(iCnt%)
	    drawRect.Left = puPanels(iCnt%).PanelStyle.iLeft
	    drawRect.Right = drawRect.Left + puPanels(iCnt%).PanelStyle.iWidth
	    drawRect.Top = puPanels(iCnt%).PanelStyle.iTop
	    drawRect.Bottom = drawRect.Top + puPanels(iCnt%).PanelStyle.iHeight
	    If (iXPos% > drawRect.Left) And (iXPos% < drawRect.Right) Then
		If (iYPos% > drawRect.Top) And (iYPos% < drawRect.Bottom) Then iGotit% = iCnt%
	    End If
	End If
    Next
    If iGotit% > 0 Then
	If puPanels(iGotit%).PanelStyle.iFormat = SBAR_BUTTON Then ButtonClick puPanels(iGotit%)
    End If
End If

End Sub

Function SetMaxHeight (ctrlStatusBar As Control, puPanels() As PanelType) As Integer

'Function Calculates the MaxHeight based on the font name and font size

Dim uProps As DrawProperties
Dim iMaxPanels%, iMaxHeight%, iCnt%, sTemp$, iTestHeight%

'Save the old settings
SaveControlProperties ctrlStatusBar, uProps

'Here we have a test sample
sTemp$ = "TEST"

iMaxHeight% = 18

'Get the number of panels
iMaxPanels% = UBound(puPanels)

'Go through each panel, checking for font information and then checking the
'height of the test string.  The font with the highest size will determine how
'large the status bar is in height.
For iCnt% = 1 To iMaxPanels%
    'Make sure we have font names to use
    If puPanels(iCnt%).sFontName = "" Then ctrlStatusBar.FontName = Trim$(uProps.sFontName) Else ctrlStatusBar.FontName = puPanels(iCnt%).sFontName
    If puPanels(iCnt%).sFontSize = "" Then ctrlStatusBar.FontSize = Trim$(uProps.sFontSize) Else ctrlStatusBar.FontSize = puPanels(iCnt%).sFontSize
    'Set the remaining settings
    ctrlStatusBar.FontBold = puPanels(iCnt%).iFontBold
    'Get the height
    iTestHeight% = ctrlStatusBar.TextHeight(sTemp$)
    'If it is higher than what we got, make it the new height
    If iTestHeight% > iMaxHeight% Then iMaxHeight% = iTestHeight%
Next iCnt%

'Return the old settings
RestoreControlProperties ctrlStatusBar, uProps
'Return our maximum height
SetMaxHeight = iMaxHeight%

End Function

Sub UpdateKeyPanels (cStatBar As Control, uPanels() As PanelType)


'This procedure can be called from the Form_KeyDown() event to better optimize
'the update of the toggle keys.   All you have to do is set the KeyPreview property
'of the form to True (except for MDI Forms.. you have to set it for each child)
'and then call this routine.


Dim iCnt%, iKeyState%, iNumPanels%

'Get the number of panels
iNumPanels% = UBound(uPanels)

'Go through each panel and place the appropriate information in it
For iCnt% = 1 To iNumPanels%
    Select Case uPanels(iCnt%).PanelStyle.iFormat
	Case SBAR_CAPSLOCK    'Check the toggle of the Caps Lock Key
	    iKeyState% = GetKeyState(KEY_CAPITAL)
	    If (iKeyState% And 1) = 1 Then UpdateTextPanel cStatBar, uPanels(iCnt%), "CAP" Else UpdateTextPanel cStatBar, uPanels(iCnt%), ""
	Case SBAR_NUMLOCK     'Check the toggle of the Num Lock Key
	    iKeyState% = GetKeyState(KEY_NUMLOCK)
	    If (iKeyState% And 1) = 1 Then UpdateTextPanel cStatBar, uPanels(iCnt%), "NUM" Else UpdateTextPanel cStatBar, uPanels(iCnt%), ""
	Case SBAR_SCROLL      'Check the toggle of the Scroll Lock key
	    iKeyState% = GetKeyState(KEY_SCROLL)
	    If (iKeyState% And 1) = 1 Then UpdateTextPanel cStatBar, uPanels(iCnt%), "SCR" Else UpdateTextPanel cStatBar, uPanels(iCnt%), ""
    End Select
Next

End Sub

Sub UpdateStatusPanels (cStatBar As Control, uPanels() As PanelType)

'You can call this one from the StatTimer_Timer() event to update all
'status panels (Date, Time, ToggleKeys).
'Toggle keys are a little slower but will work effectively if needed.


Dim iCnt%, iKeyState%, iNumPanels%

'Get the number of panels
iNumPanels% = UBound(uPanels)

'Go through each panel and place the appropriate information in it
For iCnt% = 1 To iNumPanels%
    Select Case uPanels(iCnt%).PanelStyle.iFormat
	Case SBAR_DATE        'Show today's date
	    UpdateTextPanel cStatBar, uPanels(iCnt%), Format$(Now, "m/d/yyyy")
	Case SBAR_TIME        'Show the Time
	    UpdateTextPanel cStatBar, uPanels(iCnt%), Format$(Now, "h:mm am/pm")
	Case SBAR_FULLDATE
	    UpdateTextPanel cStatBar, uPanels(iCnt%), Format$(Now, "dddd, mmm dd, yyyy")
	Case SBAR_WEEKDAY
	    UpdateTextPanel cStatBar, uPanels(iCnt%), Format$(Now, "dddd")
	Case SBAR_CAPSLOCK    'Check the toggle of the Caps Lock Key
	    iKeyState% = GetKeyState(KEY_CAPITAL)
	    If (iKeyState% And 1) = 1 Then UpdateTextPanel cStatBar, uPanels(iCnt%), "CAP" Else UpdateTextPanel cStatBar, uPanels(iCnt%), ""
	Case SBAR_NUMLOCK     'Check the toggle of the Num Lock Key
	    iKeyState% = GetKeyState(KEY_NUMLOCK)
	    If (iKeyState% And 1) = 1 Then UpdateTextPanel cStatBar, uPanels(iCnt%), "NUM" Else UpdateTextPanel cStatBar, uPanels(iCnt%), ""
	Case SBAR_SCROLL      'Check the toggle of the Scroll Lock key
	    iKeyState% = GetKeyState(KEY_SCROLL)
	    If (iKeyState% And 1) = 1 Then UpdateTextPanel cStatBar, uPanels(iCnt%), "SCR" Else UpdateTextPanel cStatBar, uPanels(iCnt%), ""
    End Select
Next


End Sub

Sub UpdateTextPanel (cStatBar As Control, uPanel As PanelType, ByVal sNewCaption As String)

'All this panel does is check to see if you have a new caption.  If the caption is the
'same, then it does nothing since it isn't necessary.  If it does change, the caption
'panel is updates and then redrawn.

sNewCaption = " " + sNewCaption + " "

If sNewCaption <> uPanel.sCaption Then
    uPanel.sCaption = sNewCaption
    DrawStatusPanel cStatBar, uPanel
End If

End Sub

Sub UpdateTimePanels (cStatBar As Control, uPanels() As PanelType)

'All you have to do is call this procedure to update the time.  Call this from
'any Timer() event to update the panels.


Dim iCnt%, iNumPanels%

'Get the number of panels
iNumPanels% = UBound(uPanels)

'Go through each panel and place the appropriate information in it
For iCnt% = 1 To iNumPanels%
    Select Case uPanels(iCnt%).PanelStyle.iFormat
	Case SBAR_DATE        'Show today's date
	    UpdateTextPanel cStatBar, uPanels(iCnt%), Format$(Now, "m/d/yyyy")
	Case SBAR_TIME        'Show the Time
	    UpdateTextPanel cStatBar, uPanels(iCnt%), Format$(Now, "h:mm am/pm")
	Case SBAR_WEEKDAY
	    UpdateTextPanel cStatBar, uPanels(iCnt%), Format$(Now, "dddd")
	Case SBAR_FULLDATE
	    UpdateTextPanel cStatBar, uPanels(iCnt%), Format$(Now, "dddd, mmm dd, yyyy")
    End Select
Next

End Sub

